/*---------------------------------------------------------------------------*\
  $Id$
  NAME
	poll - select(2)-based poll() emulation function for BSD systems.
  SYNOPSIS
	#include "poll.h"
	struct pollfd
	{
	    int     fd;
	    short   events;
	    short   revents;
	}
	int poll (struct pollfd *pArray, unsigned long n_fds, int timeout)
  DESCRIPTION
	This file, and the accompanying "poll.c", implement the System V
	poll(2) system call for BSD systems (which typically do not provide
	poll()).  Poll() provides a method for multiplexing input and output
	on multiple open file descriptors; in traditional BSD systems, that
	capability is provided by select().  While the semantics of select()
	differ from those of poll(), poll() can be readily emulated in terms
	of select() -- which is how this function is implemented.
  REFERENCES
	Stevens, W. Richard. Unix Network Programming.  Prentice-Hall, 1990.
  NOTES
	1. This software requires an ANSI C compiler.
  LICENSE
  This software is released under the following BSD license, adapted from
  http://opensource.org/licenses/bsd-license.php
  Copyright (c) 1995-2011, Brian M. Clapper
  All rights reserved.
  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions are met:
  * Redistributions of source code must retain the above copyright notice,
    this list of conditions and the following disclaimer.
  * Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.
  * Neither the name of the clapper.org nor the names of its contributors
    may be used to endorse or promote products derived from this software
    without specific prior written permission.
  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
  IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
  THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
  PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
\*---------------------------------------------------------------------------*/

#ifndef _POLL_EMUL_H_
#define _POLL_EMUL_H_

#define POLLIN		0x01
#define POLLPRI		0x02
#define POLLOUT		0x04
#define POLLERR		0x08
#define POLLHUP		0x10
#define POLLNVAL	0x20

struct pollfd
{
    int     fd;
    short   events;
    short   revents;
};

typedef unsigned long nfds_t;

#ifdef __cplusplus
extern "C"
{
#endif

#if (__STDC__ > 0) || defined(__cplusplus)
extern int poll (struct pollfd *pArray, nfds_t n_fds, int timeout);
#else
extern int poll();
#endif

#ifdef __cplusplus
}
#endif

#endif /* _POLL_EMUL_H_ */
