/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.jmx;

import java.net.URI;
import org.apache.activemq.broker.Connector;
import org.apache.activemq.broker.jmx.ConnectorViewMBean;
import org.apache.activemq.command.BrokerInfo;

public class ConnectorView
implements ConnectorViewMBean {
    private final Connector connector;

    public ConnectorView(Connector connector) {
        this.connector = connector;
    }

    public void start() throws Exception {
        this.connector.start();
    }

    @Override
    public String getBrokerName() {
        return this.getBrokerInfo().getBrokerName();
    }

    public void stop() throws Exception {
        this.connector.stop();
    }

    public String getBrokerURL() {
        return this.getBrokerInfo().getBrokerURL();
    }

    public BrokerInfo getBrokerInfo() {
        return this.connector.getBrokerInfo();
    }

    @Override
    public void resetStatistics() {
        this.connector.resetStatistics();
    }

    @Override
    public void enableStatistics() {
        this.connector.getStatistics().setEnabled(true);
    }

    @Override
    public void disableStatistics() {
        this.connector.getStatistics().setEnabled(false);
    }

    @Override
    public boolean isStatisticsEnabled() {
        return this.connector.getStatistics().isEnabled();
    }

    @Override
    public int connectionCount() {
        return this.connector.connectionCount();
    }

    @Override
    public boolean isUpdateClusterClients() {
        return this.connector.isUpdateClusterClients();
    }

    @Override
    public boolean isRebalanceClusterClients() {
        return this.connector.isRebalanceClusterClients();
    }

    @Override
    public boolean isUpdateClusterClientsOnRemove() {
        return this.connector.isUpdateClusterClientsOnRemove();
    }

    @Override
    public String getUpdateClusterFilter() {
        return this.connector.getUpdateClusterFilter();
    }

    @Override
    public boolean isAllowLinkStealingEnabled() {
        return this.connector.isAllowLinkStealing();
    }

    @Override
    public long getMaxConnectionExceededCount() {
        return this.connector.getMaxConnectionExceededCount();
    }

    @Override
    public boolean isAutoStart() {
        return this.connector.isAutoStart();
    }

    @Override
    public boolean isStarted() {
        return this.connector.isStarted();
    }

    @Override
    public String getConnectURI() {
        URI tmpConnectUri = null;
        try {
            tmpConnectUri = this.connector.getConnectUri();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return tmpConnectUri != null ? tmpConnectUri.toString() : null;
    }

    @Override
    public String getPublishableConnectURI() {
        URI publishableConnectURI = null;
        try {
            publishableConnectURI = this.connector.getPublishableConnectURI();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return publishableConnectURI != null ? publishableConnectURI.toString() : null;
    }

    @Override
    public String getBrokerInfoString() {
        return this.getBrokerInfo().toString();
    }

    @Override
    public boolean isEnableStatusMonitor() {
        return this.connector.isEnableStatusMonitor();
    }

    @Override
    public String getURI() {
        URI tmpURI = this.connector.getUri();
        return tmpURI != null ? tmpURI.toString() : null;
    }

    @Override
    public String getDiscoveryURI() {
        URI tmpDiscoveryURI = this.connector.getDiscoveryUri();
        return tmpDiscoveryURI != null ? tmpDiscoveryURI.toString() : null;
    }

    @Override
    public boolean isAuditNetworkProducers() {
        return this.connector.isAuditNetworkProducers();
    }

    @Override
    public int getMaximumProducersAllowedPerConnection() {
        return this.connector.getMaximumProducersAllowedPerConnection();
    }

    @Override
    public int getMaximumConsumersAllowedPerConnection() {
        return this.connector.getMaximumConsumersAllowedPerConnection();
    }

    @Override
    public int getConnectionCount() {
        return this.connector.connectionCount();
    }
}

