/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.io.Closeable;
import java.io.InputStream;
import java.util.Properties;
import org.apache.camel.util.IOHelper;

class VersionHolder {
    public static final String VERSION = VersionHolder.doGetVersion();
    private static final String POM_PROPERTIES = "/META-INF/maven/org.apache.camel/camel-base-engine/pom.properties";

    VersionHolder() {
    }

    private static String doGetVersion() {
        InputStream is = null;
        try {
            is = VersionHolder.class.getResourceAsStream(POM_PROPERTIES);
            if (is != null) {
                Properties p = new Properties();
                p.load(is);
                String string = p.getProperty("version", "");
                return string;
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (is != null) {
                IOHelper.close((Closeable)is);
            }
        }
        return VersionHolder.fallbackResolver();
    }

    private static String fallbackResolver() {
        String resolvedVersion = null;
        Package aPackage = VersionHolder.class.getPackage();
        if (aPackage != null && (resolvedVersion = aPackage.getImplementationVersion()) == null) {
            resolvedVersion = aPackage.getSpecificationVersion();
        }
        if (resolvedVersion == null) {
            resolvedVersion = "";
        }
        return resolvedVersion;
    }
}

