/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.pool;

import jakarta.jms.Connection;
import java.io.IOException;
import java.util.HashMap;
import java.util.Properties;
import javax.naming.NamingException;
import javax.naming.Reference;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.Service;
import org.apache.activemq.jms.pool.ConnectionPool;
import org.apache.activemq.jndi.JNDIReferenceFactory;
import org.apache.activemq.jndi.JNDIStorableInterface;
import org.apache.activemq.pool.PooledConnection;
import org.apache.activemq.transport.TransportListener;
import org.apache.activemq.util.IntrospectionSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PooledConnectionFactory
extends org.apache.activemq.jms.pool.PooledConnectionFactory
implements JNDIStorableInterface,
Service {
    public static final String POOL_PROPS_PREFIX = "pool";
    private static final transient Logger LOG = LoggerFactory.getLogger(org.apache.activemq.jms.pool.PooledConnectionFactory.class);

    public PooledConnectionFactory() {
    }

    public PooledConnectionFactory(ActiveMQConnectionFactory activeMQConnectionFactory) {
        this.setConnectionFactory(activeMQConnectionFactory);
    }

    public PooledConnectionFactory(String brokerURL) {
        this.setConnectionFactory(new ActiveMQConnectionFactory(brokerURL));
    }

    protected void buildFromProperties(Properties props) {
        ActiveMQConnectionFactory activeMQConnectionFactory = new ActiveMQConnectionFactory();
        activeMQConnectionFactory.buildFromProperties(props);
        this.setConnectionFactory(activeMQConnectionFactory);
        IntrospectionSupport.setProperties((Object)this, new HashMap<Object, Object>(props), POOL_PROPS_PREFIX);
    }

    @Override
    protected void populateProperties(Properties props) {
        ((ActiveMQConnectionFactory)this.getConnectionFactory()).populateProperties(props);
        super.populateProperties(props);
    }

    @Override
    public void setProperties(Properties properties) {
        this.buildFromProperties(properties);
    }

    @Override
    public Properties getProperties() {
        Properties properties = new Properties();
        this.populateProperties(properties);
        return properties;
    }

    @Override
    public Reference getReference() throws NamingException {
        return JNDIReferenceFactory.createReference(this.getClass().getName(), this);
    }

    @Override
    protected Connection newPooledConnection(ConnectionPool connection) {
        return new PooledConnection(connection);
    }

    @Override
    protected ConnectionPool createConnectionPool(Connection connection) {
        return new ConnectionPool(connection){

            @Override
            protected Connection wrap(final Connection connection) {
                ((ActiveMQConnection)connection).addTransportListener(new TransportListener(){

                    @Override
                    public void onCommand(Object command) {
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void onException(IOException error) {
                        1 var2_2 = this;
                        synchronized (var2_2) {
                            this.setHasExpired(true);
                            if (!PooledConnectionFactory.this.stopped.get()) {
                                LOG.info("Expiring connection " + String.valueOf(connection) + " on IOException: " + error.getMessage());
                                LOG.debug("Expiring connection " + String.valueOf(connection) + " on IOException: ", error);
                            }
                        }
                    }

                    @Override
                    public void transportInterupted() {
                    }

                    @Override
                    public void transportResumed() {
                    }
                });
                this.setHasExpired(((ActiveMQConnection)connection).isTransportFailed());
                return connection;
            }

            @Override
            protected void unWrap(Connection connection) {
                if (connection != null) {
                    ((ActiveMQConnection)connection).cleanUpTempDestinations();
                }
            }
        };
    }
}

