/*!
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { Badge, type BadgeProps } from "@chakra-ui/react";
import * as React from "react";

import type { TaskInstanceState } from "openapi/requests/types.gen";

import { StateIcon } from "./StateIcon";

export type Props = {
  readonly state?: TaskInstanceState | null;
} & BadgeProps;

export const StateBadge = React.forwardRef<HTMLDivElement, Props>(({ children, state, ...rest }, ref) => (
  <Badge
    borderRadius="full"
    color={`${state === null ? undefined : state}.contrast`}
    colorPalette={state === null ? "none" : state}
    data-testid="state-badge"
    fontSize="sm"
    px={children === undefined ? 1 : 2}
    py={1}
    ref={ref}
    variant="solid"
    {...rest}
  >
    {state === undefined ? undefined : <StateIcon state={state} />}
    {children}
  </Badge>
));
