/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.profile;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.util.ArrayList;
import java.util.Collection;
import org.openjdk.jmh.infra.BenchmarkParams;
import org.openjdk.jmh.infra.IterationParams;
import org.openjdk.jmh.profile.InternalProfiler;
import org.openjdk.jmh.results.AggregationPolicy;
import org.openjdk.jmh.results.IterationResult;
import org.openjdk.jmh.results.Result;
import org.openjdk.jmh.results.ScalarResult;

public class MemPoolProfiler
implements InternalProfiler {
    static final double BYTES_PER_KIB = 1024.0;

    @Override
    public String getDescription() {
        return "Memory pool/footprint profiling via standard MBeans";
    }

    @Override
    public void beforeIteration(BenchmarkParams benchmarkParams, IterationParams iterationParams) {
        for (MemoryPoolMXBean b : ManagementFactory.getMemoryPoolMXBeans()) {
            b.resetPeakUsage();
        }
    }

    @Override
    public Collection<? extends Result> afterIteration(BenchmarkParams benchmarkParams, IterationParams iterationParams, IterationResult result) {
        ArrayList<ScalarResult> results = new ArrayList<ScalarResult>();
        long sumCodeHeap = 0L;
        long sum = 0L;
        for (MemoryPoolMXBean bean : ManagementFactory.getMemoryPoolMXBeans()) {
            long used = bean.getPeakUsage().getUsed();
            if (bean.getName().contains("CodeHeap") || bean.getName().contains("Code Cache")) {
                sumCodeHeap += used;
            }
            sum += used;
            results.add(new ScalarResult("mempool." + bean.getName() + ".used", (double)used / 1024.0, "KiB", AggregationPolicy.MAX));
        }
        results.add(new ScalarResult("mempool.total.codeheap.used", (double)sumCodeHeap / 1024.0, "KiB", AggregationPolicy.MAX));
        results.add(new ScalarResult("mempool.total.used", (double)sum / 1024.0, "KiB", AggregationPolicy.MAX));
        return results;
    }
}

