/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.profile;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSpec;
import org.openjdk.jmh.infra.BenchmarkParams;
import org.openjdk.jmh.profile.AbstractPerfAsmProfiler;
import org.openjdk.jmh.profile.ProfilerException;
import org.openjdk.jmh.results.BenchmarkResult;
import org.openjdk.jmh.results.Result;
import org.openjdk.jmh.util.Deduplicator;
import org.openjdk.jmh.util.HashMultimap;
import org.openjdk.jmh.util.InputStreamDrainer;
import org.openjdk.jmh.util.IntervalMap;
import org.openjdk.jmh.util.Multiset;
import org.openjdk.jmh.util.TreeMultiset;
import org.openjdk.jmh.util.Utils;

public class WinPerfAsmProfiler
extends AbstractPerfAsmProfiler {
    private static final String MSG_UNABLE_START = "Unable to start the profiler. Try running JMH as Administrator, and ensure that previous profiling session is stopped. Use 'xperf -stop' to stop the active profiling session.";
    private static final String MSG_UNABLE_STOP = "Unable to stop the profiler. Please try running JMH as Administrator.";
    private final String xperfProviders;
    private final String symbolDir;
    private final String path;
    private volatile String pid;
    private OptionSpec<String> optXperfDir;
    private OptionSpec<String> optXperfProviders;
    private OptionSpec<String> optSymbolDir;

    public WinPerfAsmProfiler(String initLine) throws ProfilerException {
        super(initLine, "SampledProfile");
        try {
            String xperfDir = this.set.valueOf(this.optXperfDir);
            this.xperfProviders = this.set.valueOf(this.optXperfProviders);
            this.symbolDir = this.set.valueOf(this.optSymbolDir);
            this.path = xperfDir != null && !xperfDir.isEmpty() ? xperfDir + File.separatorChar + "xperf" : "xperf";
        }
        catch (OptionException e) {
            throw new ProfilerException(e.getMessage());
        }
        Collection<String> errsOn = Utils.tryWith(this.path, "-on", this.xperfProviders);
        if (!errsOn.isEmpty()) {
            throw new ProfilerException("Unable to start the profiler. Try running JMH as Administrator, and ensure that previous profiling session is stopped. Use 'xperf -stop' to stop the active profiling session.: " + errsOn);
        }
        Collection<String> errsStop = Utils.tryWith(this.path, "-stop");
        if (!errsStop.isEmpty()) {
            throw new ProfilerException("Unable to stop the profiler. Please try running JMH as Administrator.: " + errsStop);
        }
    }

    @Override
    protected void addMyOptions(OptionParser parser) {
        this.optXperfDir = parser.accepts("xperf.dir", "Path to \"xperf\" installation directory. Empty by default, so that xperf is expected to be in PATH.").withRequiredArg().ofType(String.class).describedAs("path");
        this.optXperfProviders = parser.accepts("xperf.providers", "xperf providers to use.").withRequiredArg().ofType(String.class).describedAs("string").defaultsTo("loader+proc_thread+profile", (String[])new String[0]);
        this.optSymbolDir = parser.accepts("symbol.dir", "Path to a directory with jvm.dll symbols (optional).").withRequiredArg().ofType(String.class).describedAs("string");
    }

    @Override
    public Collection<String> addJVMInvokeOptions(BenchmarkParams params) {
        return Collections.emptyList();
    }

    @Override
    public void beforeTrial(BenchmarkParams params) {
        Collection<String> errs = Utils.tryWith(this.path, "-on", this.xperfProviders);
        if (!errs.isEmpty()) {
            throw new IllegalStateException("Unable to start the profiler. Try running JMH as Administrator, and ensure that previous profiling session is stopped. Use 'xperf -stop' to stop the active profiling session.: " + errs);
        }
    }

    @Override
    public Collection<? extends Result> afterTrial(BenchmarkResult br, long pid, File stdOut, File stdErr) {
        if (pid == 0L) {
            throw new IllegalStateException("perfasm needs the forked VM PID, but it is not initialized.");
        }
        this.pid = String.valueOf(pid);
        return super.afterTrial(br, pid, stdOut, stdErr);
    }

    @Override
    public String getDescription() {
        return "Windows xperf + PrintAssembly Profiler";
    }

    @Override
    protected void parseEvents() {
        Collection<String> errs = Utils.tryWith(this.path, "-d", this.perfBinData.getAbsolutePath());
        if (!errs.isEmpty()) {
            throw new IllegalStateException("Unable to stop the profiler. Please try running JMH as Administrator.: " + errs);
        }
        try {
            ProcessBuilder pb = new ProcessBuilder(this.path, "-i", this.perfBinData.getAbsolutePath(), "-symbols", "-a", "dumper");
            if (this.symbolDir != null) {
                pb.environment().put("_NT_SYMBOL_PATH", this.symbolDir);
            }
            Process p = pb.start();
            FileOutputStream fos = new FileOutputStream(this.perfParsedData.file());
            InputStreamDrainer errDrainer = new InputStreamDrainer(p.getErrorStream(), fos);
            InputStreamDrainer outDrainer = new InputStreamDrainer(p.getInputStream(), fos);
            errDrainer.start();
            outDrainer.start();
            p.waitFor();
            errDrainer.join();
            outDrainer.join();
        }
        catch (IOException | InterruptedException ex) {
            throw new IllegalStateException(ex);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    protected AbstractPerfAsmProfiler.PerfEvents readEvents(double skipMs, double lenMs) {
        double readFrom = skipMs / 1000.0;
        double readTo = (skipMs + lenMs) / 1000.0;
        try (FileReader fr = new FileReader(this.perfParsedData.file());){
            AbstractPerfAsmProfiler.PerfEvents perfEvents;
            try (BufferedReader reader = new BufferedReader(fr);){
                String line;
                Deduplicator<AbstractPerfAsmProfiler.MethodDesc> dedup = new Deduplicator<AbstractPerfAsmProfiler.MethodDesc>();
                HashMultimap<AbstractPerfAsmProfiler.MethodDesc, Long> methods = new HashMultimap<AbstractPerfAsmProfiler.MethodDesc, Long>();
                LinkedHashMap<String, Multiset<Long>> events = new LinkedHashMap<String, Multiset<Long>>();
                for (String evName : this.requestedEventNames) {
                    events.put(evName, new TreeMultiset());
                }
                while ((line = reader.readLine()) != null) {
                    String timeStr;
                    double time;
                    line = line.trim();
                    String[] elems = line.split(",\\s+");
                    String evName = elems[0].trim();
                    if (!((String)this.requestedEventNames.get(0)).equals(evName)) continue;
                    String pidStr = elems[2].trim();
                    int pidOpenIdx = pidStr.indexOf("(");
                    int pidCloseIdx = pidStr.indexOf(")");
                    if (pidOpenIdx == -1 || pidCloseIdx == -1 || pidCloseIdx < pidOpenIdx || !this.pid.equals(pidStr = pidStr.substring(pidOpenIdx + 1, pidCloseIdx).trim()) || (time = Double.parseDouble(timeStr = elems[1].trim()) / 1000000.0) < readFrom || time > readTo) continue;
                    String addrStr = elems[4].trim().replace("0x", "");
                    String libSymStr = elems[7].trim();
                    String lib = libSymStr.substring(0, libSymStr.indexOf(33));
                    String symbol = libSymStr.substring(libSymStr.indexOf(33) + 1);
                    Multiset evs = (Multiset)events.get(evName);
                    assert (evs != null);
                    try {
                        Long addr = Long.parseLong(addrStr, 16);
                        evs.add(addr);
                        methods.put(dedup.dedup(AbstractPerfAsmProfiler.MethodDesc.nativeMethod(symbol, lib)), addr);
                    }
                    catch (NumberFormatException e) {
                        evs.add(0L);
                    }
                }
                IntervalMap<AbstractPerfAsmProfiler.MethodDesc> methodMap = new IntervalMap<AbstractPerfAsmProfiler.MethodDesc>();
                for (AbstractPerfAsmProfiler.MethodDesc md : methods.keys()) {
                    Collection longs = methods.get(md);
                    methodMap.add(md, (Long)Utils.min(longs), (Long)Utils.max(longs));
                }
                perfEvents = new AbstractPerfAsmProfiler.PerfEvents(this.requestedEventNames, events, methodMap);
            }
            return perfEvents;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected String perfBinaryExtension() {
        return ".etl";
    }
}

