/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sasi.utils;

import java.io.IOException;
import java.util.Iterator;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.index.sasi.disk.OnDiskIndex;
import org.apache.cassandra.index.sasi.utils.CombinedTerm;
import org.apache.cassandra.index.sasi.utils.RangeIterator;
import org.apache.cassandra.index.sasi.utils.RangeUnionIterator;

public class OnDiskIndexIterator
extends RangeIterator<OnDiskIndex.DataTerm, CombinedTerm> {
    private final AbstractType<?> comparator;
    private final Iterator<OnDiskIndex.DataTerm> terms;

    public OnDiskIndexIterator(OnDiskIndex index) {
        super(index.min(), index.max(), Long.MAX_VALUE);
        this.comparator = index.getComparator();
        this.terms = index.iterator();
    }

    public static RangeIterator<OnDiskIndex.DataTerm, CombinedTerm> union(OnDiskIndex ... union) {
        RangeUnionIterator.Builder<OnDiskIndex.DataTerm, CombinedTerm> builder = RangeUnionIterator.builder();
        for (OnDiskIndex e : union) {
            if (e == null) continue;
            builder.add(new OnDiskIndexIterator(e));
        }
        return builder.build();
    }

    @Override
    protected CombinedTerm computeNext() {
        return this.terms.hasNext() ? new CombinedTerm(this.comparator, this.terms.next()) : (CombinedTerm)this.endOfData();
    }

    @Override
    protected void performSkipTo(OnDiskIndex.DataTerm nextToken) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws IOException {
    }
}

