/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools.nodetool;

import io.airlift.airline.Command;
import java.io.PrintStream;
import org.apache.cassandra.tools.NodeProbe;
import org.apache.cassandra.tools.NodeTool;

@Command(name="proxyhistograms", description="Print statistic histograms for network operations")
public class ProxyHistograms
extends NodeTool.NodeToolCmd {
    @Override
    public void execute(NodeProbe probe) {
        PrintStream out = probe.output().out;
        String[] percentiles = new String[]{"50%", "75%", "95%", "98%", "99%", "Min", "Max"};
        Double[] readLatency = probe.metricPercentilesAsArray(probe.getProxyMetric("Read"));
        Double[] writeLatency = probe.metricPercentilesAsArray(probe.getProxyMetric("Write"));
        Double[] rangeLatency = probe.metricPercentilesAsArray(probe.getProxyMetric("RangeSlice"));
        Double[] casReadLatency = probe.metricPercentilesAsArray(probe.getProxyMetric("CASRead"));
        Double[] casWriteLatency = probe.metricPercentilesAsArray(probe.getProxyMetric("CASWrite"));
        Double[] viewWriteLatency = probe.metricPercentilesAsArray(probe.getProxyMetric("ViewWrite"));
        out.println("proxy histograms");
        out.println(String.format("%-10s%19s%19s%19s%19s%19s%19s", "Percentile", "Read Latency", "Write Latency", "Range Latency", "CAS Read Latency", "CAS Write Latency", "View Write Latency"));
        out.println(String.format("%-10s%19s%19s%19s%19s%19s%19s", "", "(micros)", "(micros)", "(micros)", "(micros)", "(micros)", "(micros)"));
        for (int i = 0; i < percentiles.length; ++i) {
            out.println(String.format("%-10s%19.2f%19.2f%19.2f%19.2f%19.2f%19.2f", percentiles[i], readLatency[i], writeLatency[i], rangeLatency[i], casReadLatency[i], casWriteLatency[i], viewWriteLatency[i]));
        }
        out.println();
    }
}

