/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.data.converter.types;

import java.util.Comparator;
import java.util.function.Function;
import org.apache.cassandra.bridge.BigNumberConfig;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.types.DataType;
import org.jetbrains.annotations.NotNull;

public interface SparkType
extends Comparator<Object> {
    default public DataType dataType() {
        return this.dataType(BigNumberConfig.DEFAULT);
    }

    public DataType dataType(BigNumberConfig var1);

    default public Object toSparkSqlType(@NotNull Object value, boolean isFrozen) {
        return value;
    }

    default public Object sparkSqlRowValue(GenericInternalRow row, int position) {
        return row.isNullAt(position) ? null : this.toTestRowType(this.nativeSparkSqlRowValue(row, position));
    }

    default public Object nativeSparkSqlRowValue(GenericInternalRow row, int position) {
        return row.isNullAt(position) ? null : this.toTestRowType(this.nativeSparkSqlRowValue(row, position));
    }

    default public Object sparkSqlRowValue(Row row, int position) {
        return row.isNullAt(position) ? null : this.toTestRowType(this.nativeSparkSqlRowValue(row, position));
    }

    default public Object nativeSparkSqlRowValue(Row row, int position) {
        return row.isNullAt(position) ? null : this.toTestRowType(this.nativeSparkSqlRowValue(row, position));
    }

    default public Object toTestRowType(Object value) {
        return value;
    }

    default public boolean equals(Object first, Object second) {
        if (first == second) {
            return true;
        }
        if (first == null || second == null) {
            return false;
        }
        return this.equalsTo(first, second);
    }

    default public boolean equalsTo(Object first, Object second) {
        return this.compare(first, second) == 0;
    }

    @Override
    default public int compare(Object first, Object second) {
        if (first == null || second == null) {
            return first == second ? 0 : (first == null ? -1 : 1);
        }
        return this.compareTo(first, second);
    }

    public static int compareArrays(Object[] first, Object[] second, Function<Integer, SparkType> types) {
        for (int index = 0; index < Math.min(first.length, second.length); ++index) {
            int comparison = types.apply(index).compare(first[index], second[index]);
            if (comparison == 0) continue;
            return comparison;
        }
        return Integer.compare(first.length, second.length);
    }

    public static boolean equalsArrays(Object[] first, Object[] second, Function<Integer, SparkType> types) {
        for (int index = 0; index < Math.min(first.length, second.length); ++index) {
            if (types.apply(index).equals(first[index], second[index])) continue;
            return false;
        }
        return first.length == second.length;
    }

    default public int compareTo(Object first, Object second) {
        throw new UnsupportedOperationException("compareTo not implemented");
    }
}

