/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable.format.bti;

import com.google.common.collect.ImmutableSet;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.io.compress.CompressionMetadata;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.format.SSTableFormat;
import org.apache.cassandra.io.sstable.format.Version;
import org.apache.cassandra.io.sstable.format.bti.BtiFormat;
import org.apache.cassandra.io.sstable.format.bti.BtiTableReader;
import org.apache.cassandra.io.sstable.format.bti.PartitionIndex;
import org.apache.cassandra.io.sstable.format.bti.PartitionIterator;
import org.apache.cassandra.io.util.ChannelProxy;
import org.apache.cassandra.io.util.File;
import org.apache.cassandra.io.util.FileHandle;
import org.apache.cassandra.io.util.ReadOnlyInputStreamFileChannel;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.schema.TableMetadataRef;
import org.apache.cassandra.spark.data.FileType;
import org.apache.cassandra.spark.data.SSTable;
import org.apache.cassandra.spark.reader.BigIndexReader;
import org.apache.cassandra.spark.reader.IndexConsumer;
import org.apache.cassandra.spark.reader.IndexEntry;
import org.apache.cassandra.spark.reader.ReaderUtils;
import org.apache.cassandra.spark.reader.SSTableCache;
import org.apache.cassandra.spark.sparksql.filters.PartitionKeyFilter;
import org.apache.cassandra.spark.sparksql.filters.SparkRangeFilter;
import org.apache.cassandra.spark.utils.streaming.BufferingInputStream;
import org.apache.cassandra.utils.FilterFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BtiReaderUtils {
    private static final Set<Component> indexComponents = ImmutableSet.of((Object)BtiFormat.Components.DATA, (Object)BtiFormat.Components.PARTITION_INDEX, (Object)BtiFormat.Components.ROW_INDEX);

    private BtiReaderUtils() {
        throw new IllegalStateException(String.valueOf(this.getClass()) + " is static utility class and shall not be instantiated");
    }

    public static boolean primaryIndexContainsAnyKey(@NotNull SSTable ssTable, @NotNull TableMetadata metadata, @NotNull Descriptor descriptor, @NotNull List<PartitionKeyFilter> filters) throws IOException {
        AtomicBoolean exists = new AtomicBoolean(false);
        BtiReaderUtils.withPartitionIndex(ssTable, descriptor, metadata, true, true, (dataFileHandle, partitionFileHandle, rowFileHandle, partitionIndex) -> {
            TableMetadataRef metadataRef = TableMetadataRef.forOfflineTools((TableMetadata)metadata);
            BtiTableReader btiTableReader = (BtiTableReader)((BtiTableReader.Builder)((BtiTableReader.Builder)((BtiTableReader.Builder)((BtiTableReader.Builder)new BtiTableReader.Builder(descriptor).setDataFile(dataFileHandle)).setPartitionIndex(partitionIndex).setRowIndexFile(rowFileHandle).setComponents(indexComponents)).setTableMetadataRef(metadataRef)).setFilter(FilterFactory.AlwaysPresent)).build(null, false, false);
            try (PartitionIterator iter = btiTableReader.keyReader();){
                while (true) {
                    if (!iter.isExhausted()) {
                        ByteBuffer buffer = iter.key();
                        boolean anyMatch = filters.stream().anyMatch(filter -> filter.matches(buffer));
                        if (anyMatch) {
                            exists.set(true);
                            return;
                        }
                        iter.advance();
                        continue;
                    }
                    break;
                }
            }
            finally {
                btiTableReader.selfRef().release();
            }
            exists.set(false);
        });
        return exists.get();
    }

    public static void consumePrimaryIndex(@NotNull SSTable ssTable, @NotNull TableMetadata metadata, @NotNull Descriptor descriptor, @Nullable SparkRangeFilter range, @NotNull IndexConsumer consumer) throws IOException {
        long dataFileLength = ssTable.length(FileType.DATA);
        TableMetadataRef metadataRef = TableMetadataRef.forOfflineTools((TableMetadata)metadata);
        org.apache.cassandra.spark.reader.CompressionMetadata compressionMetadata = SSTableCache.INSTANCE.compressionMetadata(ssTable, descriptor.version.hasMaxCompressedLength(), metadata.params.crcCheckChance);
        BtiReaderUtils.withPartitionIndex(ssTable, descriptor, metadata, true, true, (dataFileHandle, partitionFileHandle, rowFileHandle, partitionIndex) -> {
            BtiTableReader btiTableReader = (BtiTableReader)((BtiTableReader.Builder)((BtiTableReader.Builder)((BtiTableReader.Builder)((BtiTableReader.Builder)new BtiTableReader.Builder(descriptor).setDataFile(dataFileHandle)).setPartitionIndex(partitionIndex).setRowIndexFile(rowFileHandle).setComponents(indexComponents)).setTableMetadataRef(metadataRef)).setFilter(FilterFactory.AlwaysPresent)).build(null, false, false);
            try (PartitionIterator iter = btiTableReader.keyReader();){
                ByteBuffer prevKey = null;
                long prevPos = 0L;
                BigInteger prevToken = null;
                boolean started = false;
                while (!iter.isExhausted()) {
                    ByteBuffer key = iter.key();
                    long pos = iter.dataPosition();
                    DecoratedKey decoratedKey = metadata.partitioner.decorateKey(key);
                    BigInteger token = ReaderUtils.tokenToBigInteger((Token)decoratedKey.getToken());
                    if (prevKey != null && (range == null || range.overlaps(prevToken))) {
                        started = true;
                        long uncompressed = pos - prevPos;
                        long compressed = compressionMetadata == null ? uncompressed : BigIndexReader.calculateCompressedSize(compressionMetadata, dataFileLength, prevPos, pos - 1L);
                        consumer.accept((Object)new IndexEntry(prevKey, prevToken, uncompressed, compressed));
                    } else if (started) {
                        return;
                    }
                    prevKey = key;
                    prevPos = pos;
                    prevToken = token;
                    iter.advance();
                }
                if (prevKey != null && (range == null || range.overlaps(prevToken))) {
                    long end = compressionMetadata == null ? dataFileLength : compressionMetadata.getDataLength();
                    long uncompressed = end - prevPos;
                    long compressed = compressionMetadata == null ? uncompressed : BigIndexReader.calculateCompressedSize(compressionMetadata, dataFileLength, prevPos, end - 1L);
                    consumer.accept((Object)new IndexEntry(prevKey, prevToken, uncompressed, compressed));
                }
            }
            finally {
                btiTableReader.selfRef().release();
            }
        });
    }

    public static void readPrimaryIndex(@NotNull SSTable sstable, @NotNull IPartitioner partitioner, @NotNull Descriptor descriptor, double crcCheckChance, @NotNull Function<ByteBuffer, Boolean> tracker) throws IOException {
        BtiReaderUtils.withPartitionIndex(sstable, descriptor, partitioner, crcCheckChance, true, true, (dataFileHandle, partitionFileHandle, rowFileHandle, partitionIndex) -> {
            try (PartitionIterator iter = PartitionIterator.create((PartitionIndex)partitionIndex, (IPartitioner)partitioner, (FileHandle)rowFileHandle, (FileHandle)dataFileHandle, (Version)descriptor.version);){
                while (!iter.isExhausted()) {
                    ByteBuffer key = iter.key();
                    if (((Boolean)tracker.apply(key)).booleanValue()) {
                        return;
                    }
                    iter.advance();
                }
            }
        });
    }

    private static void withPartitionIndex(@NotNull SSTable sstable, @NotNull Descriptor descriptor, @NotNull TableMetadata metadata, boolean loadDataFile, boolean loadRowsIndex, @NotNull BtiPartitionIndexConsumer consumer) throws IOException {
        BtiReaderUtils.withPartitionIndex(sstable, descriptor, metadata.partitioner, metadata.params.crcCheckChance, loadDataFile, loadRowsIndex, consumer);
    }

    private static void withPartitionIndex(@NotNull SSTable sstable, @NotNull Descriptor descriptor, @NotNull IPartitioner partitioner, double crcCheckChance, boolean loadDataFile, boolean loadRowsIndex, @NotNull BtiPartitionIndexConsumer consumer) throws IOException {
        File file = new File(sstable.getDataFileName());
        CompressionMetadata compression = BtiReaderUtils.getCompressionMetadata(sstable, crcCheckChance, descriptor);
        try (FileHandle dataFileHandle = loadDataFile ? BtiReaderUtils.createFileHandle(file, sstable.openDataStream(), sstable.length(FileType.DATA), compression) : null;
             FileHandle partitionFileHandle = BtiReaderUtils.createFileHandle(file, sstable.openPrimaryIndexStream(), sstable.length(FileType.PARTITIONS_INDEX), null);
             FileHandle rowFileHandle = loadRowsIndex ? BtiReaderUtils.createFileHandle(file, sstable.openRowIndexStream(), sstable.length(FileType.ROWS_INDEX), null) : null;
             PartitionIndex partitionIndex = PartitionIndex.load((FileHandle)partitionFileHandle, (IPartitioner)partitioner, (boolean)false);){
            consumer.accept(dataFileHandle, partitionFileHandle, rowFileHandle, partitionIndex);
        }
    }

    private static FileHandle createFileHandle(File file, InputStream stream, long size, CompressionMetadata compression) throws IOException {
        if (stream == null) {
            throw new FileNotFoundException("Cannot find file " + file.absolutePath());
        }
        ReadOnlyInputStreamFileChannel fileChannel = new ReadOnlyInputStreamFileChannel((BufferingInputStream)stream, size);
        ChannelProxy proxy = new ChannelProxy(file, (FileChannel)fileChannel);
        FileHandle.Builder builder = new FileHandle.Builder(file);
        if (compression != null) {
            builder.withCompressionMetadata(compression);
        }
        return builder.complete(f -> proxy);
    }

    private static CompressionMetadata getCompressionMetadata(SSTable ssTable, double crcCheckChance, Descriptor descriptor) throws IOException {
        org.apache.cassandra.spark.reader.CompressionMetadata compressionMetadata = SSTableCache.INSTANCE.compressionMetadata(ssTable, descriptor.version.hasMaxCompressedLength(), crcCheckChance);
        if (compressionMetadata != null) {
            return compressionMetadata.toInternal(descriptor.fileFor(SSTableFormat.Components.COMPRESSION_INFO), ssTable.length(FileType.DATA));
        }
        return null;
    }

    public static interface BtiPartitionIndexConsumer {
        public void accept(FileHandle var1, FileHandle var2, FileHandle var3, PartitionIndex var4) throws IOException;
    }
}

