/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cdc.kafka;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import org.apache.cassandra.cdc.msg.CdcEvent;
import org.apache.kafka.clients.producer.ProducerRecord;

public interface RecordProducer {
    public static final RecordProducer DEFAULT = new RecordProducer(){};
    public static final String KEYSPACE_HEADER = "keyspace";
    public static final String TABLE_HEADER = "table";

    default public ProducerRecord<String, byte[]> buildRecord(String keyspace, String table, String topic, String key, byte[] payload) {
        ProducerRecord record = new ProducerRecord(topic, (Object)key, (Object)payload);
        RecordProducer.addHeader(record, KEYSPACE_HEADER, keyspace);
        RecordProducer.addHeader(record, TABLE_HEADER, table);
        return record;
    }

    default public List<ProducerRecord<String, byte[]>> buildRecords(CdcEvent cdcEvent, String topic, String key, byte[] payload) {
        return this.buildRecords(cdcEvent.keyspace, cdcEvent.table, topic, key, payload);
    }

    default public List<ProducerRecord<String, byte[]>> buildRecords(String keyspace, String table, String topic, String key, byte[] payload) {
        return Collections.singletonList(this.buildRecord(keyspace, table, topic, key, payload));
    }

    public static <K, V> void addHeader(ProducerRecord<K, V> record, String name, short value) {
        RecordProducer.addHeader(record, name, ByteBuffer.allocate(2).putShort(value).array());
    }

    public static <K, V> void addHeader(ProducerRecord<K, V> record, String name, int value) {
        RecordProducer.addHeader(record, name, ByteBuffer.allocate(4).putInt(value).array());
    }

    public static <K, V> void addHeader(ProducerRecord<K, V> record, String name, String value) {
        RecordProducer.addHeader(record, name, RecordProducer.toBytes(value));
    }

    public static <K, V> void addHeader(ProducerRecord<K, V> record, String name, byte[] value) {
        record.headers().add(name, value);
    }

    public static byte[] toBytes(String str) {
        return str.getBytes(StandardCharsets.UTF_8);
    }
}

