/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.bulkwriter;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.cassandra.spark.bulkwriter.TableInfoProvider;
import org.apache.cassandra.spark.common.schema.ColumnType;
import org.apache.cassandra.spark.common.schema.ColumnTypes;
import org.apache.cassandra.spark.data.CqlField;
import org.apache.cassandra.spark.data.CqlTable;
import org.jetbrains.annotations.NotNull;

public class CqlTableInfoProvider
implements TableInfoProvider {
    private static final Pattern DEPRECATED_OPTIONS = Pattern.compile("(?:\\s+AND)?\\s+(?:dclocal_)?read_repair_chance\\s*=\\s*[+\\-.\\dE]+", 2);
    private static final Pattern LEADING_CONJUNCTION = Pattern.compile("(?<=\\bWITH)\\s+AND\\b", 2);
    private final String createTableStatement;
    private final CqlTable cqlTable;
    private static final Map<String, ColumnType<?>> DATA_TYPES = ImmutableMap.builder().put((Object)"bigint", ColumnTypes.LONG).put((Object)"blob", ColumnTypes.BYTES).put((Object)"double", ColumnTypes.DOUBLE).put((Object)"int", ColumnTypes.INT).put((Object)"boolean", ColumnTypes.BOOLEAN).put((Object)"text", ColumnTypes.STRING).put((Object)"timestamp", ColumnTypes.TIMESTAMP).put((Object)"uuid", ColumnTypes.UUID).put((Object)"varchar", ColumnTypes.STRING).put((Object)"ascii", ColumnTypes.STRING).put((Object)"timeuuid", ColumnTypes.UUID).build();

    public CqlTableInfoProvider(String createTableStatement, CqlTable cqlTable) {
        this.createTableStatement = createTableStatement;
        this.cqlTable = cqlTable;
    }

    @Override
    public CqlField.CqlType getColumnType(String columnName) {
        CqlField cqlField = this.cqlTable.column(columnName);
        if (cqlField == null) {
            throw new IllegalArgumentException("Unknown fields in data frame => " + columnName);
        }
        return cqlField.type();
    }

    @Override
    public List<ColumnType<?>> getPartitionKeyTypes() {
        List<ColumnType<?>> types = this.cqlTable.partitionKeys().stream().map(cqlField -> {
            String typeName = cqlField.type().cqlName().toLowerCase();
            ColumnType<?> type = DATA_TYPES.get(typeName);
            if (type == null) {
                throw new RuntimeException("Could not find ColumnType for type name " + typeName);
            }
            return type;
        }).collect(Collectors.toList());
        return types;
    }

    @Override
    public boolean columnExists(String columnName) {
        return this.cqlTable.column(columnName) != null;
    }

    @Override
    public List<String> getPartitionKeyColumnNames() {
        return this.cqlTable.partitionKeys().stream().map(CqlField::name).collect(Collectors.toList());
    }

    @Override
    public String getCreateStatement() {
        return CqlTableInfoProvider.removeDeprecatedOptions(this.createTableStatement);
    }

    @Override
    public List<String> getPrimaryKeyColumnNames() {
        return this.cqlTable.primaryKey().stream().map(CqlField::name).collect(Collectors.toList());
    }

    @Override
    public String getName() {
        return this.cqlTable.table();
    }

    @Override
    public String getKeyspaceName() {
        return this.cqlTable.keyspace();
    }

    @Override
    public boolean hasSecondaryIndex() {
        return this.cqlTable.indexCount() > 0;
    }

    @Override
    public List<String> getColumnNames() {
        return this.cqlTable.columns().stream().map(CqlField::name).collect(Collectors.toList());
    }

    @VisibleForTesting
    @NotNull
    static String removeDeprecatedOptions(@NotNull String cql) {
        cql = DEPRECATED_OPTIONS.matcher(cql).replaceAll("");
        cql = LEADING_CONJUNCTION.matcher(cql).replaceAll("");
        return cql;
    }
}

