/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.bulkwriter.token;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Range;
import java.math.BigInteger;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.spark.bulkwriter.ClusterInfo;
import org.apache.cassandra.spark.bulkwriter.JobInfo;
import org.apache.cassandra.spark.bulkwriter.token.ConsistencyLevel;
import org.apache.cassandra.spark.bulkwriter.token.TokenRangeMapping;
import org.apache.cassandra.spark.common.model.CassandraInstance;
import org.apache.cassandra.spark.data.ReplicationFactor;
import org.jetbrains.annotations.Nullable;

public abstract class ReplicaAwareFailureHandler<I extends CassandraInstance> {
    public abstract List<ConsistencyFailurePerRange> getFailedRanges(TokenRangeMapping<I> var1, JobInfo var2, ClusterInfo var3);

    public abstract void addFailure(Range<BigInteger> var1, I var2, String var3);

    public abstract Set<I> getFailedInstances();

    protected abstract List<ConsistencyFailurePerRange> getFailedRangesInternal(TokenRangeMapping<I> var1, ConsistencyLevel var2, @Nullable String var3, ReplicationFactor var4);

    public class ConsistencyFailurePerRange {
        public final Range<BigInteger> range;
        public final FailuresPerInstance failuresPerInstance;

        public ConsistencyFailurePerRange(Range<BigInteger> range, FailuresPerInstance failuresPerInstance) {
            this.range = range;
            this.failuresPerInstance = failuresPerInstance;
        }
    }

    public class FailuresPerInstance {
        private final Multimap<I, String> errorMessagesPerInstance;

        public FailuresPerInstance() {
            this.errorMessagesPerInstance = ArrayListMultimap.create();
        }

        public FailuresPerInstance(Multimap<I, String> errorMessagesPerInstance) {
            this.errorMessagesPerInstance = ArrayListMultimap.create(errorMessagesPerInstance);
        }

        public FailuresPerInstance copy() {
            return new FailuresPerInstance(this.errorMessagesPerInstance);
        }

        public Set<I> instances() {
            return this.errorMessagesPerInstance.keySet();
        }

        public void addErrorForInstance(I instance, String errorMessage) {
            this.errorMessagesPerInstance.put(instance, (Object)errorMessage);
        }

        public boolean hasError(I instance) {
            return this.errorMessagesPerInstance.containsKey(instance) && !this.errorMessagesPerInstance.get(instance).isEmpty();
        }

        public Set<Map.Entry<I, Collection<String>>> entrySet() {
            return this.errorMessagesPerInstance.asMap().entrySet();
        }

        public String toString() {
            return this.errorMessagesPerInstance.toString();
        }
    }
}

