/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark;

import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.apache.cassandra.bridge.CassandraBridge;
import org.apache.cassandra.bridge.CassandraVersion;
import org.apache.cassandra.spark.TestUtils;
import org.apache.cassandra.spark.data.CqlField;
import org.apache.cassandra.spark.data.VersionRunner;
import org.apache.cassandra.spark.utils.test.TestSchema;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class PartitionSizeTests
extends VersionRunner {
    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.spark.data.VersionRunner#versions"})
    public void testReadingPartitionSize(CassandraVersion version) {
        TestUtils.runTest(version, (partitioner, dir, bridge) -> {
            int numRows = 200;
            int numCols = 25;
            TestSchema schema = TestSchema.builder((CassandraBridge)bridge).withPartitionKey("a", (CqlField.CqlType)bridge.text()).withClusteringKey("b", (CqlField.CqlType)bridge.aInt()).withColumn("c", (CqlField.CqlType)bridge.aInt()).withColumn("d", (CqlField.CqlType)bridge.text()).build();
            HashMap sizes = new HashMap(numRows);
            schema.writeSSTable(dir, bridge, partitioner, writer -> {
                for (int i = 0; i < numRows; ++i) {
                    String key = UUID.randomUUID().toString();
                    int size = 0;
                    for (int j = 0; j < numCols; ++j) {
                        String str = TestUtils.randomLowEntropyString();
                        writer.write(new Object[]{key, j, i + j, str});
                        size += 8 + str.getBytes(StandardCharsets.UTF_8).length;
                    }
                    sizes.put(key, size);
                }
            });
            Dataset<Row> ds = TestUtils.openLocalPartitionSizeSource(bridge, partitioner, dir, schema.keyspace, schema.createStatement, version, Collections.emptySet(), null);
            List rows = ds.collectAsList();
            Assertions.assertThat((List)rows).hasSize(numRows);
            for (Row row : rows) {
                String key = row.getString(0);
                long uncompressed = row.getLong(1);
                long compressed = row.getLong(2);
                Assertions.assertThat(sizes).containsKey((Object)key);
                long len = ((Integer)sizes.get(key)).intValue();
                Assertions.assertThat((long)len).isLessThan(uncompressed);
                Assertions.assertThat((long)Math.abs(uncompressed - len)).isLessThan(500L);
                Assertions.assertThat((long)compressed).isLessThan(uncompressed);
                Assertions.assertThat((float)((float)compressed / (float)uncompressed)).isLessThan(0.1f);
            }
        });
    }
}

