/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.bulkwriter;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NotNull;

public class MockScheduledExecutorService
extends ScheduledThreadPoolExecutor {
    private Runnable command;
    private boolean stopped = false;
    private long period;
    private TimeUnit timeUnit;
    List<MockScheduledFuture<?>> futures = new ArrayList();

    public MockScheduledExecutorService() {
        super(0);
    }

    @Override
    @NotNull
    public ScheduledFuture<?> scheduleWithFixedDelay(@NotNull Runnable command, long initialDelay, long period, @NotNull TimeUnit unit) {
        this.period = period;
        this.timeUnit = unit;
        this.command = command;
        return new MockScheduledFuture(command);
    }

    public ScheduledFuture<?> submit(Runnable command) {
        MockScheduledFuture future = new MockScheduledFuture(command);
        this.futures.add(future);
        return future;
    }

    @Override
    @NotNull
    public <T> Future<T> submit(@NotNull Callable<T> task) {
        MockScheduledFuture<T> future = new MockScheduledFuture<T>(task);
        this.futures.add(future);
        return future;
    }

    @Override
    @NotNull
    public List<Runnable> shutdownNow() {
        this.stopped = true;
        return new ArrayList<Runnable>();
    }

    @Override
    public void shutdown() {
        this.stopped = true;
    }

    public void assertFuturesCalled() {
        this.futures.forEach(MockScheduledFuture::assertGetCalled);
    }

    public void runCommand() {
        this.command.run();
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public long getPeriod() {
        return this.period;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    static class MockScheduledFuture<V>
    implements ScheduledFuture<V> {
        private final Callable<V> command;
        private boolean getCalled = false;

        MockScheduledFuture(Callable<V> command) {
            this.command = command;
        }

        MockScheduledFuture(Runnable command) {
            this.command = () -> {
                command.run();
                return null;
            };
        }

        @Override
        public long getDelay(@NotNull TimeUnit unit) {
            return 0L;
        }

        @Override
        public int compareTo(@NotNull Delayed that) {
            return 0;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return false;
        }

        @Override
        public V get() throws InterruptedException, ExecutionException {
            this.getCalled = true;
            try {
                return this.command.call();
            }
            catch (Exception exception) {
                throw new ExecutionException(exception);
            }
        }

        @Override
        public V get(long timeout, @NotNull TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            this.getCalled = true;
            return null;
        }

        public void assertGetCalled() {
            assert (this.getCalled);
        }
    }
}

