/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.reflect;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.reflect.AbstractCallback;
import org.apache.cayenne.util.Util;

class CallbackOnEntity
extends AbstractCallback {
    private final Method callbackMethod;

    CallbackOnEntity(Class<?> objectClass, String methodName) throws IllegalArgumentException {
        this(CallbackOnEntity.findMethod(objectClass, methodName));
    }

    CallbackOnEntity(Method method) throws IllegalArgumentException {
        if (!CallbackOnEntity.validateMethod(method)) {
            throw new IllegalArgumentException("Class " + method.getDeclaringClass().getName() + " has no valid callback method '" + method.getName() + "'");
        }
        this.callbackMethod = method;
        if (!Util.isAccessible(this.callbackMethod)) {
            this.callbackMethod.setAccessible(true);
        }
    }

    @Override
    public void performCallback(Object entity) {
        try {
            this.callbackMethod.invoke(entity, (Object[])null);
        }
        catch (Exception e) {
            throw new CayenneRuntimeException("Error invoking entity callback method " + this.callbackMethod.getName(), (Throwable)e, new Object[0]);
        }
    }

    public String toString() {
        return "callback-entity: " + this.callbackMethod.getDeclaringClass().getName() + "." + this.callbackMethod.getName();
    }

    private static boolean validateMethod(Method method) {
        int modifiers = method.getModifiers();
        return !Modifier.isStatic(modifiers) && Void.TYPE.isAssignableFrom(method.getReturnType()) && method.getParameterTypes().length == 0;
    }

    private static Method findMethod(Class<?> objectClass, String methodName) throws IllegalArgumentException {
        Method method;
        try {
            method = objectClass.getDeclaredMethod(methodName, new Class[0]);
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalArgumentException("Class " + objectClass.getName() + " has no valid callback method '" + methodName + "'");
        }
        return method;
    }
}

