/*
 * Decompiled with CFR 0.152.
 */
package one.jfr.event;

import one.jfr.event.Event;

public class EventAggregator {
    private static final int INITIAL_CAPACITY = 1024;
    private final boolean threads;
    private final boolean total;
    private Event[] keys;
    private long[] values;
    private int size;

    public EventAggregator(boolean threads, boolean total) {
        this.threads = threads;
        this.total = total;
        this.keys = new Event[1024];
        this.values = new long[1024];
    }

    public void collect(Event e) {
        int mask = this.keys.length - 1;
        int i = this.hashCode(e) & mask;
        while (this.keys[i] != null) {
            if (this.sameGroup(this.keys[i], e)) {
                int n = i;
                this.values[n] = this.values[n] + (this.total ? e.value() : 1L);
                return;
            }
            i = i + 1 & mask;
        }
        this.keys[i] = e;
        long l = this.values[i] = this.total ? e.value() : 1L;
        if (++this.size * 2 > this.keys.length) {
            this.resize(this.keys.length * 2);
        }
    }

    public long getValue(Event e) {
        int mask = this.keys.length - 1;
        int i = this.hashCode(e) & mask;
        while (this.keys[i] != null && !this.sameGroup(this.keys[i], e)) {
            i = i + 1 & mask;
        }
        return this.values[i];
    }

    public void forEach(Visitor visitor) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (this.keys[i] == null) continue;
            visitor.visit(this.keys[i], this.values[i]);
        }
    }

    private int hashCode(Event e) {
        return e.hashCode() + (this.threads ? e.tid * 31 : 0);
    }

    private boolean sameGroup(Event e1, Event e2) {
        return e1.stackTraceId == e2.stackTraceId && (!this.threads || e1.tid == e2.tid) && e1.sameGroup(e2);
    }

    private void resize(int newCapacity) {
        Event[] newKeys = new Event[newCapacity];
        long[] newValues = new long[newCapacity];
        int mask = newKeys.length - 1;
        block0: for (int i = 0; i < this.keys.length; ++i) {
            if (this.keys[i] == null) continue;
            int j = this.hashCode(this.keys[i]) & mask;
            while (true) {
                if (newKeys[j] == null) {
                    newKeys[j] = this.keys[i];
                    newValues[j] = this.values[i];
                    continue block0;
                }
                j = j + 1 & mask;
            }
        }
        this.keys = newKeys;
        this.values = newValues;
    }

    public static interface Visitor {
        public void visit(Event var1, long var2);
    }
}

