/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.network.protocol;

import java.io.InputStream;
import java.util.List;
import org.apache.celeborn.common.network.protocol.EncryptedMessageWithHeader;
import org.apache.celeborn.common.network.protocol.Message;
import org.apache.celeborn.common.network.protocol.ResponseMessage;
import org.apache.celeborn.shaded.io.netty.buffer.ByteBuf;
import org.apache.celeborn.shaded.io.netty.buffer.Unpooled;
import org.apache.celeborn.shaded.io.netty.channel.ChannelHandler;
import org.apache.celeborn.shaded.io.netty.channel.ChannelHandlerContext;
import org.apache.celeborn.shaded.io.netty.handler.codec.MessageToMessageEncoder;
import org.apache.celeborn.shaded.io.netty.handler.stream.ChunkedStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public final class SslMessageEncoder
extends MessageToMessageEncoder<Message> {
    private static final Logger logger = LoggerFactory.getLogger(SslMessageEncoder.class);
    public static final SslMessageEncoder INSTANCE = new SslMessageEncoder();

    private SslMessageEncoder() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void encode(ChannelHandlerContext ctx, Message in, List<Object> out) throws Exception {
        Object body = null;
        int bodyLength = 0;
        if (in.body() != null) {
            try {
                bodyLength = (int)in.body().size();
                body = in.body().convertToNettyForSsl();
            }
            catch (Exception e) {
                in.body().release();
                if (!(in instanceof ResponseMessage)) {
                    throw e;
                }
                ResponseMessage resp = (ResponseMessage)in;
                String error = e.getMessage() != null ? e.getMessage() : "null";
                logger.error(String.format("Error processing %s for client %s", in, ctx.channel().remoteAddress()), (Throwable)e);
                this.encode(ctx, resp.createFailureResponse(error), out);
                return;
            }
        }
        Message.Type msgType = in.type();
        int headerLength = 4 + msgType.encodedLength() + 4 + in.encodedLength();
        ByteBuf header = ctx.alloc().heapBuffer(headerLength);
        header.writeInt(in.encodedLength());
        msgType.encode(header);
        header.writeInt(bodyLength);
        in.encode(header);
        assert (header.writableBytes() == 0);
        if (body != null && bodyLength > 0) {
            if (body instanceof ByteBuf) {
                out.add(Unpooled.wrappedBuffer(header, (ByteBuf)body));
                return;
            } else {
                if (!(body instanceof InputStream) && !(body instanceof ChunkedStream)) throw new IllegalArgumentException("Body must be a ByteBuf, ChunkedStream or an InputStream");
                out.add(new EncryptedMessageWithHeader(in.body(), header, body, bodyLength));
            }
            return;
        } else {
            out.add(header);
        }
    }
}

