/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.rm.soap;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.TimerTask;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.Bus;
import org.apache.cxf.binding.soap.SoapHeader;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.SoapVersion;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.DeferredConduitSelector;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.interceptor.AbstractOutDatabindingInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.interceptor.InterceptorChain;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.io.CachedOutputStreamCallback;
import org.apache.cxf.io.WriteOnCloseOutputStream;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.phase.PhaseChainCache;
import org.apache.cxf.phase.PhaseInterceptor;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.phase.PhaseManager;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.staxutils.PartialXMLStreamReader;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.staxutils.W3CDOMStreamWriter;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.MessageObserver;
import org.apache.cxf.workqueue.SynchronousExecutor;
import org.apache.cxf.ws.addressing.AddressingProperties;
import org.apache.cxf.ws.addressing.AttributedURIType;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.ws.addressing.soap.MAPCodec;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.builder.jaxb.JaxbAssertion;
import org.apache.cxf.ws.rm.ProtocolVariation;
import org.apache.cxf.ws.rm.RMCaptureOutInterceptor;
import org.apache.cxf.ws.rm.RMConfiguration;
import org.apache.cxf.ws.rm.RMContextUtils;
import org.apache.cxf.ws.rm.RMEndpoint;
import org.apache.cxf.ws.rm.RMException;
import org.apache.cxf.ws.rm.RMManager;
import org.apache.cxf.ws.rm.RMProperties;
import org.apache.cxf.ws.rm.RMUtils;
import org.apache.cxf.ws.rm.RetransmissionQueue;
import org.apache.cxf.ws.rm.RetryStatus;
import org.apache.cxf.ws.rm.SourceSequence;
import org.apache.cxf.ws.rm.manager.RetryPolicyType;
import org.apache.cxf.ws.rm.persistence.RMStore;
import org.apache.cxf.ws.rm.v200702.Identifier;
import org.apache.cxf.ws.rm.v200702.SequenceType;
import org.apache.cxf.ws.rmp.v200502.RMAssertion;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RetransmissionQueueImpl
implements RetransmissionQueue {
    private static final Logger LOG = LogUtils.getL7dLogger(RetransmissionQueueImpl.class);
    private final Map<String, List<ResendCandidate>> candidates = new HashMap<String, List<ResendCandidate>>();
    private final Map<String, List<ResendCandidate>> suspendedCandidates = new HashMap<String, List<ResendCandidate>>();
    private Resender resender;
    private RMManager manager;
    private int unacknowledgedCount;

    public RetransmissionQueueImpl(RMManager m) {
        this.manager = m;
    }

    public RMManager getManager() {
        return this.manager;
    }

    public void setManager(RMManager m) {
        this.manager = m;
    }

    @Override
    public void addUnacknowledged(Message message) {
        this.cacheUnacknowledged(message);
    }

    @Override
    public synchronized int countUnacknowledged(SourceSequence seq) {
        List<ResendCandidate> sequenceCandidates = this.getSequenceCandidates(seq);
        return sequenceCandidates == null ? 0 : sequenceCandidates.size();
    }

    @Override
    public int countUnacknowledged() {
        return this.unacknowledgedCount;
    }

    @Override
    public boolean isEmpty() {
        return this.getUnacknowledged().isEmpty();
    }

    @Override
    public void purgeAcknowledged(SourceSequence seq) {
        this.purgeCandidates(seq, false);
    }

    @Override
    public void purgeAll(SourceSequence seq) {
        this.purgeCandidates(seq, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purgeCandidates(SourceSequence seq, boolean any) {
        ArrayList<Long> purged = new ArrayList<Long>();
        ArrayList<ResendCandidate> resends = new ArrayList<ResendCandidate>();
        Identifier sid = seq.getIdentifier();
        RetransmissionQueueImpl retransmissionQueueImpl = this;
        synchronized (retransmissionQueueImpl) {
            LOG.fine("Start purging resend candidates.");
            List<ResendCandidate> sequenceCandidates = this.getSequenceCandidates(seq);
            if (null != sequenceCandidates) {
                for (int i = sequenceCandidates.size() - 1; i >= 0; --i) {
                    ResendCandidate candidate = sequenceCandidates.get(i);
                    long m = candidate.getNumber();
                    if (!any && !seq.isAcknowledged(m)) continue;
                    sequenceCandidates.remove(i);
                    candidate.resolved();
                    --this.unacknowledgedCount;
                    purged.add(m);
                    resends.add(candidate);
                }
                if (sequenceCandidates.isEmpty()) {
                    this.candidates.remove(sid.getValue());
                }
            }
            LOG.fine("Completed purging resend candidates.");
        }
        if (!purged.isEmpty()) {
            RMStore store = this.manager.getStore();
            if (null != store) {
                store.removeMessages(sid, purged, true);
            }
            RMEndpoint rmEndpoint = seq.getSource().getReliableEndpoint();
            for (ResendCandidate resend : resends) {
                rmEndpoint.handleAcknowledgment(sid.getValue(), resend.getNumber(), resend.getMessage());
            }
        }
    }

    @Override
    public List<Long> getUnacknowledgedMessageNumbers(SourceSequence seq) {
        ArrayList<Long> unacknowledged = new ArrayList<Long>();
        List<ResendCandidate> sequenceCandidates = this.getSequenceCandidates(seq);
        if (null != sequenceCandidates) {
            for (int i = 0; i < sequenceCandidates.size(); ++i) {
                ResendCandidate candidate = sequenceCandidates.get(i);
                unacknowledged.add(candidate.getNumber());
            }
        }
        return unacknowledged;
    }

    @Override
    public RetryStatus getRetransmissionStatus(SourceSequence seq, long num) {
        List<ResendCandidate> sequenceCandidates = this.getSequenceCandidates(seq);
        if (null != sequenceCandidates) {
            for (int i = 0; i < sequenceCandidates.size(); ++i) {
                ResendCandidate candidate = sequenceCandidates.get(i);
                if (num != candidate.getNumber()) continue;
                return candidate;
            }
        }
        return null;
    }

    @Override
    public Map<Long, RetryStatus> getRetransmissionStatuses(SourceSequence seq) {
        HashMap<Long, RetryStatus> cp = new HashMap<Long, RetryStatus>();
        List<ResendCandidate> sequenceCandidates = this.getSequenceCandidates(seq);
        if (null != sequenceCandidates) {
            for (int i = 0; i < sequenceCandidates.size(); ++i) {
                ResendCandidate candidate = sequenceCandidates.get(i);
                cp.put(candidate.getNumber(), candidate);
            }
        }
        return cp;
    }

    @Override
    public void start() {
        if (null != this.resender) {
            return;
        }
        LOG.fine("Starting retransmission queue");
        this.resender = this.getDefaultResender();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop(SourceSequence seq) {
        RetransmissionQueueImpl retransmissionQueueImpl = this;
        synchronized (retransmissionQueueImpl) {
            List<ResendCandidate> sequenceCandidates = this.getSequenceCandidates(seq);
            if (null != sequenceCandidates) {
                for (int i = sequenceCandidates.size() - 1; i >= 0; --i) {
                    ResendCandidate candidate = sequenceCandidates.get(i);
                    candidate.cancel();
                }
                LOG.log(Level.FINE, "Cancelled resends for sequence {0}.", seq.getIdentifier().getValue());
            }
        }
    }

    void stop() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void suspend(SourceSequence seq) {
        RetransmissionQueueImpl retransmissionQueueImpl = this;
        synchronized (retransmissionQueueImpl) {
            String key = seq.getIdentifier().getValue();
            List<ResendCandidate> sequenceCandidates = this.candidates.remove(key);
            if (null != sequenceCandidates) {
                for (int i = sequenceCandidates.size() - 1; i >= 0; --i) {
                    ResendCandidate candidate = sequenceCandidates.get(i);
                    candidate.suspend();
                }
                this.suspendedCandidates.put(key, sequenceCandidates);
                LOG.log(Level.FINE, "Suspended resends for sequence {0}.", key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resume(SourceSequence seq) {
        RetransmissionQueueImpl retransmissionQueueImpl = this;
        synchronized (retransmissionQueueImpl) {
            String key = seq.getIdentifier().getValue();
            List<ResendCandidate> sequenceCandidates = this.suspendedCandidates.remove(key);
            if (null != sequenceCandidates) {
                for (int i = 0; i < sequenceCandidates.size(); ++i) {
                    ResendCandidate candidate = sequenceCandidates.get(i);
                    candidate.resume();
                }
                this.candidates.put(key, sequenceCandidates);
                LOG.log(Level.FINE, "Resumed resends for sequence {0}.", key);
            }
        }
    }

    protected int getExponentialBackoff() {
        return 2;
    }

    protected ResendCandidate createResendCandidate(Message message) {
        return new ResendCandidate(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResendCandidate cacheUnacknowledged(Message message) {
        ResendCandidate candidate;
        RMProperties rmps = RMContextUtils.retrieveRMProperties(message, true);
        SequenceType st = rmps.getSequence();
        Identifier sid = st.getIdentifier();
        String key = sid.getValue();
        RetransmissionQueueImpl retransmissionQueueImpl = this;
        synchronized (retransmissionQueueImpl) {
            List<ResendCandidate> sequenceCandidates = this.getSequenceCandidates(key);
            if (null == sequenceCandidates) {
                sequenceCandidates = new ArrayList<ResendCandidate>();
                this.candidates.put(key, sequenceCandidates);
            }
            candidate = this.createResendCandidate(message);
            if (this.isSequenceSuspended(key)) {
                candidate.suspend();
            }
            sequenceCandidates.add(candidate);
            ++this.unacknowledgedCount;
        }
        LOG.fine("Cached unacknowledged message.");
        try {
            RMEndpoint rme = this.manager.getReliableEndpoint(message);
            rme.handleAccept(key, st.getMessageNumber(), message);
        }
        catch (RMException e) {
            LOG.log(Level.WARNING, "Could not find reliable endpoint for message");
        }
        return candidate;
    }

    protected Map<String, List<ResendCandidate>> getUnacknowledged() {
        return this.candidates;
    }

    protected List<ResendCandidate> getSequenceCandidates(SourceSequence seq) {
        return this.getSequenceCandidates(seq.getIdentifier().getValue());
    }

    protected List<ResendCandidate> getSequenceCandidates(String key) {
        List<ResendCandidate> sc = this.candidates.get(key);
        if (null == sc) {
            sc = this.suspendedCandidates.get(key);
        }
        return sc;
    }

    protected boolean isSequenceSuspended(String key) {
        return this.suspendedCandidates.containsKey(key);
    }

    protected final Resender getDefaultResender() {
        return new Resender(){

            @Override
            public void resend(Message message, boolean requestAcknowledge) {
                RMProperties properties = RMContextUtils.retrieveRMProperties(message, true);
                SequenceType st = properties.getSequence();
                if (st != null) {
                    LOG.log(Level.INFO, "RESEND_MSG", st.getMessageNumber());
                }
                if (message instanceof SoapMessage) {
                    RetransmissionQueueImpl.this.doResend((SoapMessage)message);
                } else {
                    RetransmissionQueueImpl.this.doResend(new SoapMessage(message));
                }
            }
        };
    }

    protected void replaceResender(Resender replacement) {
        this.resender = replacement;
    }

    protected JaxbAssertion<RMAssertion> getAssertion(AssertionInfo ai) {
        return (JaxbAssertion)ai.getAssertion();
    }

    private void readHeaders(XMLStreamReader xmlReader, SoapMessage message) throws XMLStreamException {
        Document doc;
        SoapVersion version = message.getVersion();
        PartialXMLStreamReader filteredReader = new PartialXMLStreamReader(xmlReader, version.getBody());
        Node nd = (Node)message.getContent(Node.class);
        W3CDOMStreamWriter writer = (W3CDOMStreamWriter)message.get(W3CDOMStreamWriter.class);
        if (writer != null) {
            StaxUtils.copy((XMLStreamReader)filteredReader, (XMLStreamWriter)writer);
            doc = writer.getDocument();
        } else if (nd instanceof Document) {
            doc = (Document)nd;
            StaxUtils.readDocElements((Document)doc, (Node)doc, (XMLStreamReader)filteredReader, (boolean)false, (boolean)false);
        } else {
            doc = StaxUtils.read((XMLStreamReader)filteredReader);
            message.setContent(Node.class, (Object)doc);
        }
        Element element = doc.getDocumentElement();
        QName header = version.getHeader();
        List elemList = DOMUtils.findAllElementsByTagNameNS((Element)element, (String)header.getNamespaceURI(), (String)header.getLocalPart());
        for (Element elem : elemList) {
            Element hel = DOMUtils.getFirstElement((Node)elem);
            while (hel != null) {
                SoapHeader sheader = new SoapHeader(DOMUtils.getElementQName((Element)hel), (Object)hel);
                message.getHeaders().add(sheader);
                hel = DOMUtils.getNextElement((Element)hel);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doResend(SoapMessage message) {
        InputStream is = null;
        try {
            OutputStream os;
            int event;
            PhaseInterceptorChain retransmitChain = this.manager.getRetransmitChain((Message)message);
            ProtocolVariation protocol = RMContextUtils.getProtocolVariation((Message)message);
            Endpoint endpoint = this.manager.getReliableEndpoint((Message)message).getEndpoint(protocol);
            PhaseChainCache cache = new PhaseChainCache();
            boolean after = true;
            if (retransmitChain == null) {
                retransmitChain = this.buildRetransmitChain(endpoint, cache);
                after = false;
            }
            message.setInterceptorChain((InterceptorChain)retransmitChain);
            message.remove((Object)"wrote.envelope.start");
            Set formats = message.getContentFormats();
            List callbacks = null;
            for (Class clas : formats) {
                Object content = message.getContent(clas);
                if (content == null) continue;
                LOG.info("Removing " + clas.getName() + " content of actual type " + content.getClass().getName());
                message.removeContent(clas);
                if (clas != OutputStream.class || !(content instanceof WriteOnCloseOutputStream)) continue;
                callbacks = ((WriteOnCloseOutputStream)content).getCallbacks();
            }
            CachedOutputStream cos = (CachedOutputStream)message.get((Object)"org.apache.cxf.ws.rm.content");
            cos.holdTempFile();
            is = cos.getInputStream();
            XMLStreamReader reader = StaxUtils.createXMLStreamReader((InputStream)is, (String)StandardCharsets.UTF_8.name());
            message.getHeaders().clear();
            if (reader.getEventType() != 1 && reader.nextTag() != 1) {
                throw new IllegalStateException("No document found");
            }
            this.readHeaders(reader, message);
            while ((event = reader.nextTag()) != 1) {
                if (event != 2) continue;
                throw new IllegalStateException("No body content present");
            }
            AddressingProperties maps = MAPCodec.getInstance((Bus)message.getExchange().getBus()).unmarshalMAPs(message);
            RMContextUtils.storeMAPs(maps, (Message)message, true, MessageUtils.isRequestor((Message)message));
            AttributedURIType to = null;
            if (null != maps) {
                to = maps.getTo();
            }
            if (null == to) {
                LOG.log(Level.SEVERE, "NO_ADDRESS_FOR_RESEND_MSG");
                return;
            }
            if (RMUtils.getAddressingConstants().getAnonymousURI().equals(to.getValue())) {
                LOG.log(Level.FINE, "Cannot resend to anonymous target");
                return;
            }
            Conduit c = message.getExchange().getConduit((Message)message);
            if (c == null) {
                c = this.buildConduit(message, endpoint, to);
            }
            c.prepare((Message)message);
            ListIterator iterator = retransmitChain.getIterator();
            while (iterator.hasNext()) {
                Interceptor incept = (Interceptor)iterator.next();
                if (incept.getClass().getName().startsWith("org.apache.cxf.jaxws.interceptors")) {
                    retransmitChain.remove(incept);
                    continue;
                }
                if (!(incept instanceof PhaseInterceptor) || !"marshal".equals(((PhaseInterceptor)incept).getPhase())) continue;
                retransmitChain.remove(incept);
            }
            retransmitChain.add((Interceptor)new CopyOutInterceptor(reader));
            if (callbacks != null && (os = (OutputStream)message.getContent(OutputStream.class)) != null) {
                WriteOnCloseOutputStream woc;
                if (os instanceof WriteOnCloseOutputStream) {
                    woc = (WriteOnCloseOutputStream)os;
                } else {
                    woc = new WriteOnCloseOutputStream(os);
                    message.setContent(OutputStream.class, (Object)woc);
                }
                for (CachedOutputStreamCallback cb : callbacks) {
                    woc.registerCallback(cb);
                }
            }
            message.put("org.apache.cxf.ws.rm.retransmitting", (Object)Boolean.TRUE);
            if (after) {
                retransmitChain.doInterceptStartingAfter((Message)message, RMCaptureOutInterceptor.class.getName());
            } else {
                retransmitChain.doIntercept((Message)message);
            }
            if (LOG.isLoggable(Level.INFO)) {
                RMProperties rmps = RMContextUtils.retrieveRMProperties((Message)message, true);
                SequenceType seq = rmps.getSequence();
                LOG.log(Level.INFO, "Retransmitted message " + seq.getMessageNumber() + " in sequence " + seq.getIdentifier().getValue());
            }
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "RESEND_FAILED_MSG", ex);
        }
        finally {
            if (null != is) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected Conduit buildConduit(SoapMessage message, Endpoint endpoint, AttributedURIType to) {
        final String address = to.getValue();
        DeferredConduitSelector cs = new DeferredConduitSelector(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public synchronized Conduit selectConduit(Message message) {
                Conduit conduit;
                EndpointInfo endpointInfo = this.endpoint.getEndpointInfo();
                EndpointReferenceType original = endpointInfo.getTarget();
                try {
                    if (null != address) {
                        endpointInfo.setAddress(address);
                    }
                    conduit = super.selectConduit(message);
                }
                finally {
                    endpointInfo.setAddress(original);
                }
                this.conduits.clear();
                return conduit;
            }
        };
        cs.setEndpoint(endpoint);
        Conduit c = cs.selectConduit((Message)message);
        c.setMessageObserver(new MessageObserver(){

            public void onMessage(Message message) {
                LOG.fine("Ignoring response to resent message.");
            }
        });
        cs.close();
        message.getExchange().setConduit(c);
        return c;
    }

    protected PhaseInterceptorChain buildRetransmitChain(Endpoint endpoint, PhaseChainCache cache) {
        Bus bus = this.getManager().getBus();
        List i1 = bus.getOutInterceptors();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Interceptors contributed by bus: " + i1);
        }
        List i2 = endpoint.getOutInterceptors();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Interceptors contributed by endpoint: " + i2);
        }
        List i3 = endpoint.getBinding().getOutInterceptors();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Interceptors contributed by binding: " + i3);
        }
        PhaseManager pm = (PhaseManager)bus.getExtension(PhaseManager.class);
        PhaseInterceptorChain retransmitChain = cache.get(pm.getOutPhases(), i1, i2, i3);
        return retransmitChain;
    }

    public static class CopyOutInterceptor
    extends AbstractOutDatabindingInterceptor {
        private final XMLStreamReader reader;

        public CopyOutInterceptor(XMLStreamReader rdr) {
            super("marshal");
            this.reader = rdr;
        }

        public void handleMessage(Message message) throws Fault {
            try {
                XMLStreamWriter writer = (XMLStreamWriter)message.getContent(XMLStreamWriter.class);
                StaxUtils.copy((XMLStreamReader)this.reader, (XMLStreamWriter)writer);
            }
            catch (XMLStreamException e) {
                throw new Fault("COULD_NOT_READ_XML_STREAM", LOG, (Throwable)e);
            }
        }
    }

    public static interface Resender {
        public void resend(Message var1, boolean var2);
    }

    protected class ResendCandidate
    implements Runnable,
    RetryStatus {
        private Message message;
        private long number;
        private Date next;
        private TimerTask nextTask;
        private int retries;
        private int maxRetries;
        private long nextInterval;
        private long backoff;
        private boolean pending;
        private boolean suspended;
        private boolean includeAckRequested;

        protected ResendCandidate(Message m) {
            this.message = m;
            this.retries = 0;
            RMConfiguration cfg = RetransmissionQueueImpl.this.manager.getEffectiveConfiguration(this.message);
            long baseRetransmissionInterval = cfg.getBaseRetransmissionInterval();
            this.backoff = cfg.isExponentialBackoff() ? 2L : 1L;
            this.next = new Date(System.currentTimeMillis() + baseRetransmissionInterval);
            this.nextInterval = baseRetransmissionInterval * this.backoff;
            RetryPolicyType rmrp = null != RetransmissionQueueImpl.this.manager.getSourcePolicy() ? RetransmissionQueueImpl.this.manager.getSourcePolicy().getRetryPolicy() : null;
            this.maxRetries = null != rmrp ? rmrp.getMaxRetries() : -1;
            AddressingProperties maps = RMContextUtils.retrieveMAPs(this.message, false, true);
            AttributedURIType to = null;
            if (null != maps) {
                to = maps.getTo();
                maps.exposeAs(cfg.getAddressingNamespace());
            }
            if (to != null && RMUtils.getAddressingConstants().getAnonymousURI().equals(to.getValue())) {
                LOG.log(Level.INFO, "Cannot resend to anonymous target.  Not scheduling a resend.");
                return;
            }
            RMProperties rmprops = RMContextUtils.retrieveRMProperties(this.message, true);
            if (null != rmprops) {
                this.number = rmprops.getSequence().getMessageNumber();
            }
            if (null != RetransmissionQueueImpl.this.manager.getTimer() && this.maxRetries != 0) {
                this.schedule();
            }
        }

        protected void initiate(boolean requestAcknowledge) {
            this.includeAckRequested = requestAcknowledge;
            this.pending = true;
            Endpoint ep = this.message.getExchange().getEndpoint();
            Executor executor = ep.getExecutor();
            if (null == executor) {
                executor = ep.getService().getExecutor();
                if (executor == null) {
                    executor = SynchronousExecutor.getInstance();
                } else {
                    LOG.log(Level.FINE, "Using service executor {0}", executor.getClass().getName());
                }
            } else {
                LOG.log(Level.FINE, "Using endpoint executor {0}", executor.getClass().getName());
            }
            try {
                executor.execute(this);
            }
            catch (RejectedExecutionException ex) {
                LOG.log(Level.SEVERE, "RESEND_INITIATION_FAILED_MSG", ex);
            }
        }

        @Override
        public void run() {
            try {
                if (this.isPending()) {
                    RetransmissionQueueImpl.this.resender.resend(this.message, this.includeAckRequested);
                    this.includeAckRequested = false;
                }
            }
            finally {
                this.attempted();
            }
        }

        public long getNumber() {
            return this.number;
        }

        @Override
        public int getRetries() {
            return this.retries;
        }

        @Override
        public int getMaxRetries() {
            return this.maxRetries;
        }

        @Override
        public Date getNext() {
            return this.next;
        }

        @Override
        public Date getPrevious() {
            if (this.retries > 0) {
                return new Date(this.next.getTime() - this.nextInterval / this.backoff);
            }
            return null;
        }

        @Override
        public long getNextInterval() {
            return this.nextInterval;
        }

        @Override
        public long getBackoff() {
            return this.backoff;
        }

        @Override
        public boolean isSuspended() {
            return this.suspended;
        }

        @Override
        public synchronized boolean isPending() {
            return this.pending;
        }

        protected synchronized void resolved() {
            this.pending = false;
            this.next = null;
            if (null != this.nextTask) {
                this.nextTask.cancel();
                this.releaseSavedMessage();
            }
        }

        protected synchronized void cancel() {
            if (null != this.nextTask) {
                this.nextTask.cancel();
                this.releaseSavedMessage();
            }
        }

        protected synchronized void suspend() {
            this.suspended = true;
            this.pending = false;
            if (null != this.nextTask) {
                this.nextTask.cancel();
            }
        }

        protected synchronized void resume() {
            this.suspended = false;
            this.next = new Date(System.currentTimeMillis());
            this.attempted();
        }

        private void releaseSavedMessage() {
            Closeable closeable;
            CachedOutputStream cos = (CachedOutputStream)this.message.get((Object)"org.apache.cxf.ws.rm.content");
            if (cos != null) {
                cos.releaseTempFileHold();
                try {
                    cos.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if ((closeable = (Closeable)this.message.get((Object)"org.apache.cxf.ws.rm.attachment.closeable")) != null) {
                try {
                    closeable.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        protected Message getMessage() {
            return this.message;
        }

        protected synchronized void attempted() {
            this.pending = false;
            ++this.retries;
            if (null != this.next && this.maxRetries != this.retries) {
                this.next = new Date(this.next.getTime() + this.nextInterval);
                this.nextInterval *= this.backoff;
                this.schedule();
            }
        }

        protected final synchronized void schedule() {
            if (null == RetransmissionQueueImpl.this.manager.getTimer()) {
                return;
            }
            class ResendTask
            extends TimerTask {
                ResendCandidate candidate;

                ResendTask(ResendCandidate c) {
                    this.candidate = c;
                }

                @Override
                public void run() {
                    if (!this.candidate.isPending()) {
                        this.candidate.initiate(ResendCandidate.this.includeAckRequested);
                    }
                }
            }
            this.nextTask = new ResendTask(this);
            try {
                RetransmissionQueueImpl.this.manager.getTimer().schedule(this.nextTask, this.next);
            }
            catch (IllegalStateException ex) {
                LOG.log(Level.WARNING, "SCHEDULE_RESEND_FAILED_MSG", ex);
            }
        }
    }
}

