/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import java.util.Objects;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ClusterTopologyChangeMessage_V3;

public class ClusterTopologyChangeMessage_V4
extends ClusterTopologyChangeMessage_V3 {
    private int serverVersion;

    public ClusterTopologyChangeMessage_V4(long uniqueEventID, String nodeID, String backupGroupName, String scaleDownGroupName, Pair<TransportConfiguration, TransportConfiguration> pair, boolean last, int serverVersion) {
        super((byte)-17, uniqueEventID, nodeID, backupGroupName, scaleDownGroupName, pair, last);
        this.serverVersion = serverVersion;
    }

    public ClusterTopologyChangeMessage_V4() {
        super((byte)-17);
    }

    public int getServerVersion() {
        return this.serverVersion;
    }

    @Override
    public void encodeRest(ActiveMQBuffer buffer) {
        super.encodeRest(buffer);
        buffer.writeInt(this.serverVersion);
    }

    @Override
    public void decodeRest(ActiveMQBuffer buffer) {
        super.decodeRest(buffer);
        this.serverVersion = buffer.readInt();
    }

    @Override
    public int hashCode() {
        return super.hashCode() + Objects.hashCode(this.serverVersion);
    }

    @Override
    protected String getPacketString() {
        StringBuilder sb = new StringBuilder(super.getPacketString());
        sb.append(", clientVersion=" + this.serverVersion);
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof ClusterTopologyChangeMessage_V4)) {
            return false;
        }
        ClusterTopologyChangeMessage_V4 other = (ClusterTopologyChangeMessage_V4)obj;
        return this.serverVersion == other.serverVersion;
    }
}

