/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server;

import io.undertow.predicate.Predicate;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.util.CopyOnWriteMap;
import io.undertow.util.HttpString;
import io.undertow.util.Methods;
import io.undertow.util.PathTemplate;
import io.undertow.util.PathTemplateMatch;
import io.undertow.util.PathTemplateMatcher;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public class RoutingHandler
implements HttpHandler {
    private final Map<HttpString, PathTemplateMatcher<RoutingMatch>> matches = new CopyOnWriteMap<HttpString, PathTemplateMatcher<RoutingMatch>>();
    private final PathTemplateMatcher<RoutingMatch> allMethodsMatcher = new PathTemplateMatcher();
    private volatile HttpHandler fallbackHandler = ResponseCodeHandler.HANDLE_404;
    private volatile HttpHandler invalidMethodHandler = ResponseCodeHandler.HANDLE_405;
    private final boolean rewriteQueryParameters;

    public RoutingHandler(boolean rewriteQueryParameters) {
        this.rewriteQueryParameters = rewriteQueryParameters;
    }

    public RoutingHandler() {
        this.rewriteQueryParameters = true;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        PathTemplateMatcher<RoutingMatch> matcher = this.matches.get(exchange.getRequestMethod());
        if (matcher == null) {
            this.handleNoMatch(exchange);
            return;
        }
        PathTemplateMatcher.PathMatchResult<RoutingMatch> match = matcher.match(exchange.getRelativePath());
        if (match == null) {
            this.handleNoMatch(exchange);
            return;
        }
        exchange.putAttachment(PathTemplateMatch.ATTACHMENT_KEY, match);
        if (this.rewriteQueryParameters) {
            for (Map.Entry entry : match.getParameters().entrySet()) {
                exchange.addQueryParam((String)entry.getKey(), (String)entry.getValue());
            }
        }
        for (HandlerHolder handlerHolder : match.getValue().predicatedHandlers) {
            if (!handlerHolder.predicate.resolve(exchange)) continue;
            handlerHolder.handler.handleRequest(exchange);
            return;
        }
        if (match.getValue().defaultHandler != null) {
            match.getValue().defaultHandler.handleRequest(exchange);
        } else {
            this.fallbackHandler.handleRequest(exchange);
        }
    }

    private void handleNoMatch(HttpServerExchange exchange) throws Exception {
        if (this.invalidMethodHandler != null && this.allMethodsMatcher.match(exchange.getRelativePath()) != null) {
            this.invalidMethodHandler.handleRequest(exchange);
            return;
        }
        this.fallbackHandler.handleRequest(exchange);
    }

    public synchronized RoutingHandler add(String method, String template, HttpHandler handler) {
        return this.add(new HttpString(method), template, handler);
    }

    public synchronized RoutingHandler add(HttpString method, String template, HttpHandler handler) {
        RoutingMatch res;
        PathTemplateMatcher<RoutingMatch> matcher = this.matches.get(method);
        if (matcher == null) {
            matcher = new PathTemplateMatcher();
            this.matches.put(method, matcher);
        }
        if ((res = matcher.get(template)) == null) {
            res = new RoutingMatch();
            matcher.add(template, res);
        }
        if (this.allMethodsMatcher.match(template) == null) {
            this.allMethodsMatcher.add(template, res);
        }
        res.defaultHandler = handler;
        return this;
    }

    public synchronized RoutingHandler get(String template, HttpHandler handler) {
        return this.add(Methods.GET, template, handler);
    }

    public synchronized RoutingHandler post(String template, HttpHandler handler) {
        return this.add(Methods.POST, template, handler);
    }

    public synchronized RoutingHandler put(String template, HttpHandler handler) {
        return this.add(Methods.PUT, template, handler);
    }

    public synchronized RoutingHandler delete(String template, HttpHandler handler) {
        return this.add(Methods.DELETE, template, handler);
    }

    public synchronized RoutingHandler add(String method, String template, Predicate predicate, HttpHandler handler) {
        return this.add(new HttpString(method), template, predicate, handler);
    }

    public synchronized RoutingHandler add(HttpString method, String template, Predicate predicate, HttpHandler handler) {
        RoutingMatch res;
        PathTemplateMatcher<RoutingMatch> matcher = this.matches.get(method);
        if (matcher == null) {
            matcher = new PathTemplateMatcher();
            this.matches.put(method, matcher);
        }
        if ((res = matcher.get(template)) == null) {
            res = new RoutingMatch();
            matcher.add(template, res);
        }
        if (this.allMethodsMatcher.match(template) == null) {
            this.allMethodsMatcher.add(template, res);
        }
        res.predicatedHandlers.add(new HandlerHolder(predicate, handler));
        return this;
    }

    public synchronized RoutingHandler get(String template, Predicate predicate, HttpHandler handler) {
        return this.add(Methods.GET, template, predicate, handler);
    }

    public synchronized RoutingHandler post(String template, Predicate predicate, HttpHandler handler) {
        return this.add(Methods.POST, template, predicate, handler);
    }

    public synchronized RoutingHandler put(String template, Predicate predicate, HttpHandler handler) {
        return this.add(Methods.PUT, template, predicate, handler);
    }

    public synchronized RoutingHandler delete(String template, Predicate predicate, HttpHandler handler) {
        return this.add(Methods.DELETE, template, predicate, handler);
    }

    public synchronized RoutingHandler addAll(RoutingHandler routingHandler) {
        for (Map.Entry<HttpString, PathTemplateMatcher<RoutingMatch>> entry : routingHandler.getMatches().entrySet()) {
            HttpString method = entry.getKey();
            PathTemplateMatcher<RoutingMatch> matcher = this.matches.get(method);
            if (matcher == null) {
                matcher = new PathTemplateMatcher();
                this.matches.put(method, matcher);
            }
            matcher.addAll(entry.getValue());
            for (PathTemplate template : entry.getValue().getPathTemplates()) {
                if (this.allMethodsMatcher.match(template.getTemplateString()) != null) continue;
                this.allMethodsMatcher.add(template, new RoutingMatch());
            }
        }
        return this;
    }

    public RoutingHandler remove(HttpString method, String path) {
        PathTemplateMatcher<RoutingMatch> handler = this.matches.get(method);
        if (handler != null) {
            handler.remove(path);
        }
        return this;
    }

    public RoutingHandler remove(String path) {
        this.allMethodsMatcher.remove(path);
        return this;
    }

    Map<HttpString, PathTemplateMatcher<RoutingMatch>> getMatches() {
        return this.matches;
    }

    public HttpHandler getFallbackHandler() {
        return this.fallbackHandler;
    }

    public RoutingHandler setFallbackHandler(HttpHandler fallbackHandler) {
        this.fallbackHandler = fallbackHandler;
        return this;
    }

    public HttpHandler getInvalidMethodHandler() {
        return this.invalidMethodHandler;
    }

    public RoutingHandler setInvalidMethodHandler(HttpHandler invalidMethodHandler) {
        this.invalidMethodHandler = invalidMethodHandler;
        return this;
    }

    private static class RoutingMatch {
        final List<HandlerHolder> predicatedHandlers = new CopyOnWriteArrayList<HandlerHolder>();
        volatile HttpHandler defaultHandler;

        private RoutingMatch() {
        }
    }

    private static class HandlerHolder {
        final Predicate predicate;
        final HttpHandler handler;

        private HandlerHolder(Predicate predicate, HttpHandler handler) {
            this.predicate = predicate;
            this.handler = handler;
        }
    }
}

