/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.serialize;

import java.io.IOException;
import java.util.Stack;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.NamespaceMap;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.serialize.HTMLTagHashSet;
import net.sf.saxon.serialize.XMLEmitter;
import net.sf.saxon.str.StringConstants;
import net.sf.saxon.str.StringTool;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.str.WhitespaceString;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaType;

public abstract class HTMLEmitter
extends XMLEmitter {
    private static final int REP_NATIVE = 0;
    private static final int REP_ENTITY = 1;
    private static final int REP_DECIMAL = 2;
    private static final int REP_HEX = 3;
    private final int nonASCIIRepresentation = 0;
    private final int excludedRepresentation = 1;
    private int inScript;
    protected int version = 5;
    private String parentElement;
    private NamespaceUri uri;
    private boolean escapeNonAscii = false;
    private final Stack<NodeName> nodeNameStack = new Stack();
    static HTMLTagHashSet emptyTags = new HTMLTagHashSet(31);
    private static final HTMLTagHashSet booleanAttributes = new HTMLTagHashSet(43);
    private static final HTMLTagHashSet booleanCombinations = new HTMLTagHashSet(57);

    private static int representationCode(String rep) {
        switch (rep = rep.toLowerCase()) {
            case "native": {
                return 0;
            }
            case "entity": {
                return 1;
            }
            case "decimal": {
                return 2;
            }
            case "hex": {
                return 3;
            }
        }
        return 1;
    }

    protected static void setEmptyTag(String tag) {
        emptyTags.add(tag);
    }

    protected static boolean isEmptyTag(String tag) {
        return emptyTags.contains(tag);
    }

    private static void setBooleanAttribute(String element, String attribute) {
        booleanAttributes.add(attribute);
        booleanCombinations.add(element + '+' + attribute);
    }

    private static boolean isBooleanAttribute(String element, String attribute, String value) {
        return attribute.equalsIgnoreCase(value) && booleanAttributes.contains(attribute) && (booleanCombinations.contains(element + '+' + attribute) || booleanCombinations.contains("*+" + attribute));
    }

    @Override
    public void setEscapeNonAscii(Boolean escape) {
        this.escapeNonAscii = escape;
    }

    protected abstract boolean isHTMLElement(NodeName var1);

    @Override
    public void open() throws XPathException {
    }

    @Override
    protected void openDocument() throws XPathException {
        assert (this.writer != null);
        if (this.started) {
            return;
        }
        String byteOrderMark = this.outputProperties.getProperty("byte-order-mark");
        if ("yes".equals(byteOrderMark) && "UTF-8".equalsIgnoreCase(this.outputProperties.getProperty("encoding"))) {
            try {
                this.writer.writeCodePoint(65279);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if ("yes".equals(this.outputProperties.getProperty("{http://saxon.sf.net/}single-quotes"))) {
            this.delimiter = (char)39;
            this.attSpecials = specialInAttSingle;
        }
        this.inScript = -1000000;
    }

    @Override
    protected void writeDocType(NodeName name, String displayName, String systemId, String publicId) throws XPathException {
        super.writeDocType(name, displayName, systemId, publicId);
    }

    @Override
    public void startElement(NodeName elemName, SchemaType type, AttributeMap attributes, NamespaceMap namespaces, Location location, int properties) throws XPathException {
        this.uri = elemName.getNamespaceUri();
        super.startElement(elemName, type, attributes, namespaces, location, properties);
        this.parentElement = (String)this.elementStack.peek();
        if (this.isHTMLElement(elemName) && (this.parentElement.equalsIgnoreCase("script") || this.parentElement.equalsIgnoreCase("style"))) {
            this.inScript = 0;
        }
        ++this.inScript;
        this.nodeNameStack.push(elemName);
    }

    public void startContentOLD() throws XPathException {
        this.closeStartTag();
    }

    @Override
    protected void writeAttribute(NodeName elCode, String attname, String value, int properties) throws XPathException {
        try {
            if (this.isHTMLElement(elCode) && HTMLEmitter.isBooleanAttribute(elCode.getLocalPart(), attname, value)) {
                this.writer.write(attname);
                return;
            }
            if (this.inScript > 0) {
                properties |= 1;
            }
            super.writeAttribute(elCode, attname, value, properties);
        }
        catch (IOException err) {
            throw new XPathException(err);
        }
    }

    @Override
    protected void writeEscape(UnicodeString chars, boolean inAttribute) throws IOException, XPathException {
        boolean[] specialChars;
        int segstart = 0;
        boolean[] blArray = specialChars = inAttribute ? this.attSpecials : specialInText;
        if (chars instanceof WhitespaceString) {
            ((WhitespaceString)chars).writeEscape(specialChars, this.writer);
            return;
        }
        boolean disabled = false;
        chars = chars.tidy();
        int[] codePoints = StringTool.expand(chars);
        while (segstart < codePoints.length) {
            int ch;
            int c;
            int i;
            if (this.escapeNonAscii) {
                for (i = segstart; i < codePoints.length && (c = codePoints[i]) < 127 && !specialChars[c]; ++i) {
                }
            } else {
                while (i < codePoints.length && ((c = codePoints[i]) < 127 ? !specialChars[c] : this.characterSet.inCharset(c) && c > 160)) {
                    ++i;
                }
            }
            if (i == codePoints.length) {
                this.writer.write(chars.substring(segstart));
                return;
            }
            if (i > segstart) {
                this.writer.write(chars.substring(segstart, i));
            }
            if ((ch = codePoints[i]) == 0) {
                disabled = !disabled;
            } else if (disabled) {
                this.writeCodePoint(ch);
            } else if (ch <= 127) {
                if (inAttribute) {
                    if (ch == 60) {
                        this.writer.writeCodePoint(60);
                    } else if (ch == 62) {
                        this.writer.writeAscii(StringConstants.ESCAPE_GT);
                    } else if (ch == 38) {
                        if (i + 1 < codePoints.length && codePoints[i + 1] == 123) {
                            this.writer.writeCodePoint(38);
                        } else {
                            this.writer.writeAscii(StringConstants.ESCAPE_AMP);
                        }
                    } else if (ch == 34) {
                        this.writer.writeAscii(StringConstants.ESCAPE_QUOT);
                    } else if (ch == 39) {
                        this.writer.writeAscii(StringConstants.ESCAPE_APOS);
                    } else if (ch == 10) {
                        this.writer.writeAscii(StringConstants.ESCAPE_NL);
                    } else if (ch == 9) {
                        this.writer.writeAscii(StringConstants.ESCAPE_TAB);
                    } else if (ch == 13) {
                        this.writer.writeAscii(StringConstants.ESCAPE_CR);
                    }
                } else if (ch == 60) {
                    this.writer.writeAscii(StringConstants.ESCAPE_LT);
                } else if (ch == 62) {
                    this.writer.writeAscii(StringConstants.ESCAPE_GT);
                } else if (ch == 38) {
                    this.writer.writeAscii(StringConstants.ESCAPE_AMP);
                } else if (ch == 13) {
                    this.writer.writeAscii(StringConstants.ESCAPE_CR);
                }
            } else if (ch < 160) {
                if (this.rejectControlCharacters()) {
                    throw new XPathException("Illegal HTML character: decimal " + ch, "SERE0014");
                }
                this.characterReferenceGenerator.outputCharacterReference(ch, this.writer);
            } else if (ch == 160) {
                this.writer.writeAscii(StringConstants.ESCAPE_NBSP);
            } else if (ch > 65535 || this.escapeNonAscii || !this.characterSet.inCharset(ch)) {
                this.characterReferenceGenerator.outputCharacterReference(ch, this.writer);
            } else {
                this.writer.writeCodePoint(ch);
            }
            segstart = ++i;
        }
    }

    protected abstract boolean rejectControlCharacters();

    @Override
    protected void writeEmptyElementTagCloser(String displayName, NodeName nameCode) throws IOException {
        if (this.isHTMLElement(nameCode)) {
            this.writer.writeAscii(StringConstants.EMPTY_TAG_MIDDLE);
            this.writer.write(displayName);
            this.writer.writeCodePoint(62);
        } else {
            this.writer.writeAscii(StringConstants.EMPTY_TAG_END);
        }
    }

    @Override
    public void endElement() throws XPathException {
        NodeName nodeName = this.nodeNameStack.pop();
        String name = (String)this.elementStack.peek();
        --this.inScript;
        if (this.inScript == 0) {
            this.inScript = -1000000;
        }
        if (HTMLEmitter.isEmptyTag(name) && this.isHTMLElement(nodeName)) {
            if (this.openStartTag) {
                this.closeStartTag();
            }
            this.elementStack.pop();
        } else {
            super.endElement();
        }
    }

    @Override
    public void characters(UnicodeString chars, Location locationId, int properties) throws XPathException {
        if (this.inScript > 0) {
            properties |= 1;
        }
        super.characters(chars, locationId, properties);
    }

    @Override
    public void processingInstruction(String target, UnicodeString data, Location locationId, int properties) throws XPathException {
        UnicodeString t;
        if (!this.started) {
            this.openDocument();
        }
        if ((t = data.tidy()).indexOf(62) >= 0L) {
            throw new XPathException("A processing instruction in HTML must not contain a > character", "SERE0015");
        }
        try {
            if (this.openStartTag) {
                this.closeStartTag();
            }
            this.writer.writeAscii(StringConstants.PI_START);
            this.writer.write(target);
            this.writer.writeCodePoint(32);
            this.writer.write(t);
            this.writer.writeCodePoint(62);
        }
        catch (IOException err) {
            throw new XPathException(err);
        }
    }

    static {
        HTMLEmitter.setBooleanAttribute("*", "hidden");
        HTMLEmitter.setBooleanAttribute("area", "nohref");
        HTMLEmitter.setBooleanAttribute("audio", "autoplay");
        HTMLEmitter.setBooleanAttribute("audio", "controls");
        HTMLEmitter.setBooleanAttribute("audio", "loop");
        HTMLEmitter.setBooleanAttribute("audio", "muted");
        HTMLEmitter.setBooleanAttribute("button", "disabled");
        HTMLEmitter.setBooleanAttribute("button", "autofocus");
        HTMLEmitter.setBooleanAttribute("button", "formnovalidate");
        HTMLEmitter.setBooleanAttribute("details", "open");
        HTMLEmitter.setBooleanAttribute("dialog", "open");
        HTMLEmitter.setBooleanAttribute("dir", "compact");
        HTMLEmitter.setBooleanAttribute("dl", "compact");
        HTMLEmitter.setBooleanAttribute("fieldset", "disabled");
        HTMLEmitter.setBooleanAttribute("form", "novalidate");
        HTMLEmitter.setBooleanAttribute("frame", "noresize");
        HTMLEmitter.setBooleanAttribute("hr", "noshade");
        HTMLEmitter.setBooleanAttribute("img", "ismap");
        HTMLEmitter.setBooleanAttribute("input", "checked");
        HTMLEmitter.setBooleanAttribute("input", "disabled");
        HTMLEmitter.setBooleanAttribute("input", "multiple");
        HTMLEmitter.setBooleanAttribute("input", "readonly");
        HTMLEmitter.setBooleanAttribute("input", "required");
        HTMLEmitter.setBooleanAttribute("input", "autofocus");
        HTMLEmitter.setBooleanAttribute("input", "formnovalidate");
        HTMLEmitter.setBooleanAttribute("iframe", "seamless");
        HTMLEmitter.setBooleanAttribute("keygen", "autofocus");
        HTMLEmitter.setBooleanAttribute("keygen", "disabled");
        HTMLEmitter.setBooleanAttribute("menu", "compact");
        HTMLEmitter.setBooleanAttribute("object", "declare");
        HTMLEmitter.setBooleanAttribute("object", "typemustmatch");
        HTMLEmitter.setBooleanAttribute("ol", "compact");
        HTMLEmitter.setBooleanAttribute("ol", "reversed");
        HTMLEmitter.setBooleanAttribute("optgroup", "disabled");
        HTMLEmitter.setBooleanAttribute("option", "selected");
        HTMLEmitter.setBooleanAttribute("option", "disabled");
        HTMLEmitter.setBooleanAttribute("script", "defer");
        HTMLEmitter.setBooleanAttribute("script", "async");
        HTMLEmitter.setBooleanAttribute("select", "multiple");
        HTMLEmitter.setBooleanAttribute("select", "disabled");
        HTMLEmitter.setBooleanAttribute("select", "autofocus");
        HTMLEmitter.setBooleanAttribute("select", "required");
        HTMLEmitter.setBooleanAttribute("style", "scoped");
        HTMLEmitter.setBooleanAttribute("td", "nowrap");
        HTMLEmitter.setBooleanAttribute("textarea", "disabled");
        HTMLEmitter.setBooleanAttribute("textarea", "readonly");
        HTMLEmitter.setBooleanAttribute("textarea", "autofocus");
        HTMLEmitter.setBooleanAttribute("textarea", "required");
        HTMLEmitter.setBooleanAttribute("th", "nowrap");
        HTMLEmitter.setBooleanAttribute("track", "default");
        HTMLEmitter.setBooleanAttribute("ul", "compact");
        HTMLEmitter.setBooleanAttribute("video", "autoplay");
        HTMLEmitter.setBooleanAttribute("video", "controls");
        HTMLEmitter.setBooleanAttribute("video", "loop");
        HTMLEmitter.setBooleanAttribute("video", "muted");
    }
}

