/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.tuple.aninteger;

import org.apache.datasketches.common.ResizeFactor;
import org.apache.datasketches.hash.MurmurHash3;
import org.apache.datasketches.theta.ThetaSketch;
import org.apache.datasketches.theta.UpdatableThetaSketch;
import org.apache.datasketches.theta.UpdatableThetaSketchBuilder;
import org.apache.datasketches.tuple.CompactTupleSketch;
import org.apache.datasketches.tuple.Summary;
import org.apache.datasketches.tuple.SummarySetOperations;
import org.apache.datasketches.tuple.TupleAnotB;
import org.apache.datasketches.tuple.TupleIntersection;
import org.apache.datasketches.tuple.TupleSketch;
import org.apache.datasketches.tuple.TupleUnion;
import org.apache.datasketches.tuple.aninteger.IntegerSummary;
import org.apache.datasketches.tuple.aninteger.IntegerSummarySetOperations;
import org.apache.datasketches.tuple.aninteger.IntegerTupleSketch;
import org.testng.Assert;
import org.testng.annotations.Test;

public class CornerCaseTupleSetOperationsTest {
    private static final long GT_MIDP_V = 3L;
    private static final float MIDP_FLT = 0.5f;
    private static final long GT_LOWP_V = 6L;
    private static final float LOWP_FLT = 0.1f;
    private static final long LT_LOWP_V = 4L;
    private IntegerSummary.Mode mode = IntegerSummary.Mode.Min;
    private IntegerSummary integerSummary = new IntegerSummary(this.mode);
    private IntegerSummarySetOperations setOperations = new IntegerSummarySetOperations(this.mode, this.mode);

    @Test
    public void emptyEmpty() {
        IntegerTupleSketch tupleA = CornerCaseTupleSetOperationsTest.getTupleSketch(SkType.EMPTY, 0.0f, 0L);
        IntegerTupleSketch tupleB = CornerCaseTupleSetOperationsTest.getTupleSketch(SkType.EMPTY, 0.0f, 0L);
        UpdatableThetaSketch thetaB = CornerCaseTupleSetOperationsTest.getThetaSketch(SkType.EMPTY, 0.0f, 0L);
        double expectedIntersectTheta = 1.0;
        boolean expectedIntersectCount = false;
        boolean expectedIntersectEmpty = true;
        double expectedAnotbTheta = 1.0;
        boolean expectedAnotbCount = false;
        boolean expectedAnotbEmpty = true;
        double expectedUnionTheta = 1.0;
        boolean expectedUnionCount = false;
        boolean expectedUnionEmpty = true;
        this.checks(tupleA, tupleB, thetaB, 1.0, 0, true, 1.0, 0, true, 1.0, 0, true);
    }

    @Test
    public void emptyExact() {
        IntegerTupleSketch tupleA = CornerCaseTupleSetOperationsTest.getTupleSketch(SkType.EMPTY, 0.0f, 0L);
        IntegerTupleSketch tupleB = CornerCaseTupleSetOperationsTest.getTupleSketch(SkType.EXACT, 0.0f, 3L);
        UpdatableThetaSketch thetaB = CornerCaseTupleSetOperationsTest.getThetaSketch(SkType.EXACT, 0.0f, 3L);
        double expectedIntersectTheta = 1.0;
        boolean expectedIntersectCount = false;
        boolean expectedIntersectEmpty = true;
        double expectedAnotbTheta = 1.0;
        boolean expectedAnotbCount = false;
        boolean expectedAnotbEmpty = true;
        double expectedUnionTheta = 1.0;
        boolean expectedUnionCount = true;
        boolean expectedUnionEmpty = false;
        this.checks(tupleA, tupleB, thetaB, 1.0, 0, true, 1.0, 0, true, 1.0, 1, false);
    }

    @Test
    public void EmptyDegenerate() {
        IntegerTupleSketch tupleA = CornerCaseTupleSetOperationsTest.getTupleSketch(SkType.EMPTY, 0.0f, 0L);
        IntegerTupleSketch tupleB = CornerCaseTupleSetOperationsTest.getTupleSketch(SkType.DEGENERATE, 0.1f, 6L);
        UpdatableThetaSketch thetaB = CornerCaseTupleSetOperationsTest.getThetaSketch(SkType.DEGENERATE, 0.1f, 6L);
        double expectedIntersectTheta = 1.0;
        boolean expectedIntersectCount = false;
        boolean expectedIntersectEmpty = true;
        double expectedAnotbTheta = 1.0;
        boolean expectedAnotbCount = false;
        boolean expectedAnotbEmpty = true;
        double expectedUnionTheta = 0.1f;
        boolean expectedUnionCount = false;
        boolean expectedUnionEmpty = false;
        this.checks(tupleA, tupleB, thetaB, 1.0, 0, true, 1.0, 0, true, 0.1f, 0, false);
    }

    @Test
    public void emptyEstimation() {
        IntegerTupleSketch tupleA = CornerCaseTupleSetOperationsTest.getTupleSketch(SkType.EMPTY, 0.0f, 0L);
        IntegerTupleSketch tupleB = CornerCaseTupleSetOperationsTest.getTupleSketch(SkType.ESTIMATION, 0.1f, 4L);
        UpdatableThetaSketch thetaB = CornerCaseTupleSetOperationsTest.getThetaSketch(SkType.ESTIMATION, 0.1f, 4L);
        double expectedIntersectTheta = 1.0;
        boolean expectedIntersectCount = false;
        boolean expectedIntersectEmpty = true;
        double expectedAnotbTheta = 1.0;
        boolean expectedAnotbCount = false;
        boolean expectedAnotbEmpty = true;
        double expectedUnionTheta = 0.1f;
        boolean expectedUnionCount = true;
        boolean expectedUnionEmpty = false;
        this.checks(tupleA, tupleB, thetaB, 1.0, 0, true, 1.0, 0, true, 0.1f, 1, false);
    }

    @Test
    public void exactEmpty() {
        IntegerTupleSketch tupleA = CornerCaseTupleSetOperationsTest.getTupleSketch(SkType.EXACT, 0.0f, 3L);
        IntegerTupleSketch tupleB = CornerCaseTupleSetOperationsTest.getTupleSketch(SkType.EMPTY, 0.0f, 0L);
        UpdatableThetaSketch thetaB = CornerCaseTupleSetOperationsTest.getThetaSketch(SkType.EMPTY, 0.0f, 0L);
        double expectedIntersectTheta = 1.0;
        boolean expectedIntersectCount = false;
        boolean expectedIntersectEmpty = true;
        double expectedAnotbTheta = 1.0;
        boolean expectedAnotbCount = true;
        boolean expectedAnotbEmpty = false;
        double expectedUnionTheta = 1.0;
        boolean expectedUnionCount = true;
        boolean expectedUnionEmpty = false;
        this.checks(tupleA, tupleB, thetaB, 1.0, 0, true, 1.0, 1, false, 1.0, 1, false);
    }

    @Test
    public void exactExact() {
        IntegerTupleSketch tupleA = CornerCaseTupleSetOperationsTest.getTupleSketch(SkType.EXACT, 0.0f, 3L);
        IntegerTupleSketch tupleB = CornerCaseTupleSetOperationsTest.getTupleSketch(SkType.EXACT, 0.0f, 3L);
        UpdatableThetaSketch thetaB = CornerCaseTupleSetOperationsTest.getThetaSketch(SkType.EXACT, 0.0f, 3L);
        double expectedIntersectTheta = 1.0;
        boolean expectedIntersectCount = true;
        boolean expectedIntersectEmpty = false;
        double expectedAnotbTheta = 1.0;
        boolean expectedAnotbCount = false;
        boolean expectedAnotbEmpty = true;
        double expectedUnionTheta = 1.0;
        boolean expectedUnionCount = true;
        boolean expectedUnionEmpty = false;
        this.checks(tupleA, tupleB, thetaB, 1.0, 1, false, 1.0, 0, true, 1.0, 1, false);
    }

    @Test
    public void exactDegenerate() {
        IntegerTupleSketch tupleA = CornerCaseTupleSetOperationsTest.getTupleSketch(SkType.EXACT, 0.0f, 4L);
        IntegerTupleSketch tupleB = CornerCaseTupleSetOperationsTest.getTupleSketch(SkType.DEGENERATE, 0.1f, 6L);
        UpdatableThetaSketch thetaB = CornerCaseTupleSetOperationsTest.getThetaSketch(SkType.DEGENERATE, 0.1f, 6L);
        double expectedIntersectTheta = 0.1f;
        boolean expectedIntersectCount = false;
        boolean expectedIntersectEmpty = false;
        double expectedAnotbTheta = 0.1f;
        boolean expectedAnotbCount = true;
        boolean expectedAnotbEmpty = false;
        double expectedUnionTheta = 0.1f;
        boolean expectedUnionCount = true;
        boolean expectedUnionEmpty = false;
        this.checks(tupleA, tupleB, thetaB, 0.1f, 0, false, 0.1f, 1, false, 0.1f, 1, false);
    }

    @Test
    public void exactEstimation() {
        IntegerTupleSketch tupleA = CornerCaseTupleSetOperationsTest.getTupleSketch(SkType.EXACT, 0.0f, 4L);
        IntegerTupleSketch tupleB = CornerCaseTupleSetOperationsTest.getTupleSketch(SkType.ESTIMATION, 0.1f, 4L);
        UpdatableThetaSketch thetaB = CornerCaseTupleSetOperationsTest.getThetaSketch(SkType.ESTIMATION, 0.1f, 4L);
        double expectedIntersectTheta = 0.1f;
        boolean expectedIntersectCount = true;
        boolean expectedIntersectEmpty = false;
        double expectedAnotbTheta = 0.1f;
        boolean expectedAnotbCount = false;
        boolean expectedAnotbEmpty = false;
        double expectedUnionTheta = 0.1f;
        boolean expectedUnionCount = true;
        boolean expectedUnionEmpty = false;
        this.checks(tupleA, tupleB, thetaB, 0.1f, 1, false, 0.1f, 0, false, 0.1f, 1, false);
    }

    @Test
    public void estimationEmpty() {
        IntegerTupleSketch tupleA = CornerCaseTupleSetOperationsTest.getTupleSketch(SkType.ESTIMATION, 0.1f, 4L);
        IntegerTupleSketch tupleB = CornerCaseTupleSetOperationsTest.getTupleSketch(SkType.EMPTY, 0.0f, 0L);
        UpdatableThetaSketch thetaB = CornerCaseTupleSetOperationsTest.getThetaSketch(SkType.EMPTY, 0.0f, 0L);
        double expectedIntersectTheta = 1.0;
        boolean expectedIntersectCount = false;
        boolean expectedIntersectEmpty = true;
        double expectedAnotbTheta = 0.1f;
        boolean expectedAnotbCount = true;
        boolean expectedAnotbEmpty = false;
        double expectedUnionTheta = 0.1f;
        boolean expectedUnionCount = true;
        boolean expectedUnionEmpty = false;
        this.checks(tupleA, tupleB, thetaB, 1.0, 0, true, 0.1f, 1, false, 0.1f, 1, false);
    }

    @Test
    public void estimationExact() {
        IntegerTupleSketch tupleA = CornerCaseTupleSetOperationsTest.getTupleSketch(SkType.ESTIMATION, 0.1f, 4L);
        IntegerTupleSketch tupleB = CornerCaseTupleSetOperationsTest.getTupleSketch(SkType.EXACT, 0.0f, 4L);
        UpdatableThetaSketch thetaB = CornerCaseTupleSetOperationsTest.getThetaSketch(SkType.EXACT, 0.0f, 4L);
        double expectedIntersectTheta = 0.1f;
        boolean expectedIntersectCount = true;
        boolean expectedIntersectEmpty = false;
        double expectedAnotbTheta = 0.1f;
        boolean expectedAnotbCount = false;
        boolean expectedAnotbEmpty = false;
        double expectedUnionTheta = 0.1f;
        boolean expectedUnionCount = true;
        boolean expectedUnionEmpty = false;
        this.checks(tupleA, tupleB, thetaB, 0.1f, 1, false, 0.1f, 0, false, 0.1f, 1, false);
    }

    @Test
    public void estimationDegenerate() {
        IntegerTupleSketch tupleA = CornerCaseTupleSetOperationsTest.getTupleSketch(SkType.ESTIMATION, 0.5f, 4L);
        IntegerTupleSketch tupleB = CornerCaseTupleSetOperationsTest.getTupleSketch(SkType.DEGENERATE, 0.1f, 6L);
        UpdatableThetaSketch thetaB = CornerCaseTupleSetOperationsTest.getThetaSketch(SkType.DEGENERATE, 0.1f, 6L);
        double expectedIntersectTheta = 0.1f;
        boolean expectedIntersectCount = false;
        boolean expectedIntersectEmpty = false;
        double expectedAnotbTheta = 0.1f;
        boolean expectedAnotbCount = true;
        boolean expectedAnotbEmpty = false;
        double expectedUnionTheta = 0.1f;
        boolean expectedUnionCount = true;
        boolean expectedUnionEmpty = false;
        this.checks(tupleA, tupleB, thetaB, 0.1f, 0, false, 0.1f, 1, false, 0.1f, 1, false);
    }

    @Test
    public void estimationEstimation() {
        IntegerTupleSketch tupleA = CornerCaseTupleSetOperationsTest.getTupleSketch(SkType.ESTIMATION, 0.5f, 4L);
        IntegerTupleSketch tupleB = CornerCaseTupleSetOperationsTest.getTupleSketch(SkType.ESTIMATION, 0.1f, 4L);
        UpdatableThetaSketch thetaB = CornerCaseTupleSetOperationsTest.getThetaSketch(SkType.ESTIMATION, 0.1f, 4L);
        double expectedIntersectTheta = 0.1f;
        boolean expectedIntersectCount = true;
        boolean expectedIntersectEmpty = false;
        double expectedAnotbTheta = 0.1f;
        boolean expectedAnotbCount = false;
        boolean expectedAnotbEmpty = false;
        double expectedUnionTheta = 0.1f;
        boolean expectedUnionCount = true;
        boolean expectedUnionEmpty = false;
        this.checks(tupleA, tupleB, thetaB, 0.1f, 1, false, 0.1f, 0, false, 0.1f, 1, false);
    }

    @Test
    public void degenerateEmpty() {
        IntegerTupleSketch tupleA = CornerCaseTupleSetOperationsTest.getTupleSketch(SkType.DEGENERATE, 0.1f, 6L);
        IntegerTupleSketch tupleB = CornerCaseTupleSetOperationsTest.getTupleSketch(SkType.EMPTY, 0.0f, 0L);
        UpdatableThetaSketch thetaB = CornerCaseTupleSetOperationsTest.getThetaSketch(SkType.EMPTY, 0.0f, 0L);
        double expectedIntersectTheta = 1.0;
        boolean expectedIntersectCount = false;
        boolean expectedIntersectEmpty = true;
        double expectedAnotbTheta = 0.1f;
        boolean expectedAnotbCount = false;
        boolean expectedAnotbEmpty = false;
        double expectedUnionTheta = 0.1f;
        boolean expectedUnionCount = false;
        boolean expectedUnionEmpty = false;
        this.checks(tupleA, tupleB, thetaB, 1.0, 0, true, 0.1f, 0, false, 0.1f, 0, false);
    }

    @Test
    public void degenerateExact() {
        IntegerTupleSketch tupleA = CornerCaseTupleSetOperationsTest.getTupleSketch(SkType.DEGENERATE, 0.1f, 6L);
        IntegerTupleSketch tupleB = CornerCaseTupleSetOperationsTest.getTupleSketch(SkType.EXACT, 0.0f, 4L);
        UpdatableThetaSketch thetaB = CornerCaseTupleSetOperationsTest.getThetaSketch(SkType.EXACT, 0.0f, 4L);
        double expectedIntersectTheta = 0.1f;
        boolean expectedIntersectCount = false;
        boolean expectedIntersectEmpty = false;
        double expectedAnotbTheta = 0.1f;
        boolean expectedAnotbCount = false;
        boolean expectedAnotbEmpty = false;
        double expectedUnionTheta = 0.1f;
        boolean expectedUnionCount = true;
        boolean expectedUnionEmpty = false;
        this.checks(tupleA, tupleB, thetaB, 0.1f, 0, false, 0.1f, 0, false, 0.1f, 1, false);
    }

    @Test
    public void degenerateDegenerate() {
        IntegerTupleSketch tupleA = CornerCaseTupleSetOperationsTest.getTupleSketch(SkType.DEGENERATE, 0.5f, 3L);
        IntegerTupleSketch tupleB = CornerCaseTupleSetOperationsTest.getTupleSketch(SkType.DEGENERATE, 0.1f, 6L);
        UpdatableThetaSketch thetaB = CornerCaseTupleSetOperationsTest.getThetaSketch(SkType.DEGENERATE, 0.1f, 6L);
        double expectedIntersectTheta = 0.1f;
        boolean expectedIntersectCount = false;
        boolean expectedIntersectEmpty = false;
        double expectedAnotbTheta = 0.1f;
        boolean expectedAnotbCount = false;
        boolean expectedAnotbEmpty = false;
        double expectedUnionTheta = 0.1f;
        boolean expectedUnionCount = false;
        boolean expectedUnionEmpty = false;
        this.checks(tupleA, tupleB, thetaB, 0.1f, 0, false, 0.1f, 0, false, 0.1f, 0, false);
    }

    @Test
    public void degenerateEstimation() {
        IntegerTupleSketch tupleA = CornerCaseTupleSetOperationsTest.getTupleSketch(SkType.DEGENERATE, 0.5f, 3L);
        IntegerTupleSketch tupleB = CornerCaseTupleSetOperationsTest.getTupleSketch(SkType.ESTIMATION, 0.1f, 4L);
        UpdatableThetaSketch thetaB = CornerCaseTupleSetOperationsTest.getThetaSketch(SkType.ESTIMATION, 0.1f, 4L);
        double expectedIntersectTheta = 0.1f;
        boolean expectedIntersectCount = false;
        boolean expectedIntersectEmpty = false;
        double expectedAnotbTheta = 0.1f;
        boolean expectedAnotbCount = false;
        boolean expectedAnotbEmpty = false;
        double expectedUnionTheta = 0.1f;
        boolean expectedUnionCount = true;
        boolean expectedUnionEmpty = false;
        this.checks(tupleA, tupleB, thetaB, 0.1f, 0, false, 0.1f, 0, false, 0.1f, 1, false);
    }

    private void checks(IntegerTupleSketch tupleA, IntegerTupleSketch tupleB, UpdatableThetaSketch thetaB, double expectedIntersectTheta, int expectedIntersectCount, boolean expectedIntersectEmpty, double expectedAnotbTheta, int expectedAnotbCount, boolean expectedAnotbEmpty, double expectedUnionTheta, int expectedUnionCount, boolean expectedUnionEmpty) {
        TupleIntersection inter = new TupleIntersection((SummarySetOperations)this.setOperations);
        TupleAnotB anotb = new TupleAnotB();
        TupleUnion union = new TupleUnion(16, (SummarySetOperations)this.setOperations);
        CompactTupleSketch csk = inter.intersect((TupleSketch)tupleA, (TupleSketch)tupleB);
        CornerCaseTupleSetOperationsTest.checkResult("Intersect Stateless TupleSketch, TupleSketch", (CompactTupleSketch<IntegerSummary>)csk, expectedIntersectTheta, expectedIntersectCount, expectedIntersectEmpty);
        csk = inter.intersect((TupleSketch)tupleA.compact(), (TupleSketch)tupleB.compact());
        CornerCaseTupleSetOperationsTest.checkResult("Intersect Stateless TupleSketch, TupleSketch", (CompactTupleSketch<IntegerSummary>)csk, expectedIntersectTheta, expectedIntersectCount, expectedIntersectEmpty);
        csk = inter.intersect((TupleSketch)tupleA, (ThetaSketch)thetaB, (Summary)this.integerSummary);
        CornerCaseTupleSetOperationsTest.checkResult("Intersect Stateless TupleSketch, ThetaSketch", (CompactTupleSketch<IntegerSummary>)csk, expectedIntersectTheta, expectedIntersectCount, expectedIntersectEmpty);
        csk = inter.intersect((TupleSketch)tupleA.compact(), (ThetaSketch)thetaB.compact(), (Summary)this.integerSummary);
        CornerCaseTupleSetOperationsTest.checkResult("Intersect Stateless TupleSketch, ThetaSketch", (CompactTupleSketch<IntegerSummary>)csk, expectedIntersectTheta, expectedIntersectCount, expectedIntersectEmpty);
        csk = TupleAnotB.aNotB((TupleSketch)tupleA, (TupleSketch)tupleB);
        CornerCaseTupleSetOperationsTest.checkResult("TupleAnotB Stateless TupleSketch, TupleSketch", (CompactTupleSketch<IntegerSummary>)csk, expectedAnotbTheta, expectedAnotbCount, expectedAnotbEmpty);
        csk = TupleAnotB.aNotB((TupleSketch)tupleA.compact(), (TupleSketch)tupleB.compact());
        CornerCaseTupleSetOperationsTest.checkResult("TupleAnotB Stateless TupleSketch, TupleSketch", (CompactTupleSketch<IntegerSummary>)csk, expectedAnotbTheta, expectedAnotbCount, expectedAnotbEmpty);
        csk = TupleAnotB.aNotB((TupleSketch)tupleA, (ThetaSketch)thetaB);
        CornerCaseTupleSetOperationsTest.checkResult("TupleAnotB Stateless TupleSketch, ThetaSketch", (CompactTupleSketch<IntegerSummary>)csk, expectedAnotbTheta, expectedAnotbCount, expectedAnotbEmpty);
        csk = TupleAnotB.aNotB((TupleSketch)tupleA.compact(), (ThetaSketch)thetaB.compact());
        CornerCaseTupleSetOperationsTest.checkResult("TupleAnotB Stateless TupleSketch, ThetaSketch", (CompactTupleSketch<IntegerSummary>)csk, expectedAnotbTheta, expectedAnotbCount, expectedAnotbEmpty);
        anotb.setA((TupleSketch)tupleA);
        anotb.notB((TupleSketch)tupleB);
        csk = anotb.getResult(true);
        CornerCaseTupleSetOperationsTest.checkResult("TupleAnotB Stateful TupleSketch, TupleSketch", (CompactTupleSketch<IntegerSummary>)csk, expectedAnotbTheta, expectedAnotbCount, expectedAnotbEmpty);
        anotb.setA((TupleSketch)tupleA.compact());
        anotb.notB((TupleSketch)tupleB.compact());
        csk = anotb.getResult(true);
        CornerCaseTupleSetOperationsTest.checkResult("TupleAnotB Stateful TupleSketch, TupleSketch", (CompactTupleSketch<IntegerSummary>)csk, expectedAnotbTheta, expectedAnotbCount, expectedAnotbEmpty);
        anotb.setA((TupleSketch)tupleA);
        anotb.notB((ThetaSketch)thetaB);
        csk = anotb.getResult(true);
        CornerCaseTupleSetOperationsTest.checkResult("TupleAnotB Stateful TupleSketch, ThetaSketch", (CompactTupleSketch<IntegerSummary>)csk, expectedAnotbTheta, expectedAnotbCount, expectedAnotbEmpty);
        anotb.setA((TupleSketch)tupleA.compact());
        anotb.notB((ThetaSketch)thetaB.compact());
        csk = anotb.getResult(true);
        CornerCaseTupleSetOperationsTest.checkResult("TupleAnotB Stateful TupleSketch, ThetaSketch", (CompactTupleSketch<IntegerSummary>)csk, expectedAnotbTheta, expectedAnotbCount, expectedAnotbEmpty);
        csk = union.union((TupleSketch)tupleA, (TupleSketch)tupleB);
        CornerCaseTupleSetOperationsTest.checkResult("TupleUnion Stateless TupleSketch, TupleSketch", (CompactTupleSketch<IntegerSummary>)csk, expectedUnionTheta, expectedUnionCount, expectedUnionEmpty);
        csk = union.union((TupleSketch)tupleA.compact(), (TupleSketch)tupleB.compact());
        CornerCaseTupleSetOperationsTest.checkResult("TupleUnion Stateless TupleSketch, TupleSketch", (CompactTupleSketch<IntegerSummary>)csk, expectedUnionTheta, expectedUnionCount, expectedUnionEmpty);
        csk = union.union((TupleSketch)tupleA, (ThetaSketch)thetaB, (Summary)this.integerSummary);
        CornerCaseTupleSetOperationsTest.checkResult("TupleUnion Stateless TupleSketch, ThetaSketch", (CompactTupleSketch<IntegerSummary>)csk, expectedUnionTheta, expectedUnionCount, expectedUnionEmpty);
        csk = union.union((TupleSketch)tupleA.compact(), (ThetaSketch)thetaB.compact(), (Summary)this.integerSummary);
        CornerCaseTupleSetOperationsTest.checkResult("TupleUnion Stateless TupleSketch, ThetaSketch", (CompactTupleSketch<IntegerSummary>)csk, expectedUnionTheta, expectedUnionCount, expectedUnionEmpty);
        union.union((TupleSketch)tupleA);
        union.union((TupleSketch)tupleB);
        csk = union.getResult(true);
        CornerCaseTupleSetOperationsTest.checkResult("TupleUnion Stateful TupleSketch, TupleSketch", (CompactTupleSketch<IntegerSummary>)csk, expectedUnionTheta, expectedUnionCount, expectedUnionEmpty);
        union.union((TupleSketch)tupleA.compact());
        union.union((TupleSketch)tupleB.compact());
        csk = union.getResult(true);
        CornerCaseTupleSetOperationsTest.checkResult("TupleUnion Stateful TupleSketch, TupleSketch", (CompactTupleSketch<IntegerSummary>)csk, expectedUnionTheta, expectedUnionCount, expectedUnionEmpty);
        union.union((TupleSketch)tupleA);
        union.union((ThetaSketch)thetaB, (Summary)this.integerSummary);
        csk = union.getResult(true);
        CornerCaseTupleSetOperationsTest.checkResult("TupleUnion Stateful TupleSketch, ThetaSketch", (CompactTupleSketch<IntegerSummary>)csk, expectedUnionTheta, expectedUnionCount, expectedUnionEmpty);
        union.union((TupleSketch)tupleA.compact());
        union.union((ThetaSketch)thetaB.compact(), (Summary)this.integerSummary);
        csk = union.getResult(true);
        CornerCaseTupleSetOperationsTest.checkResult("TupleUnion Stateful TupleSketch, ThetaSketch", (CompactTupleSketch<IntegerSummary>)csk, expectedUnionTheta, expectedUnionCount, expectedUnionEmpty);
    }

    private static void checkResult(String comment, CompactTupleSketch<IntegerSummary> csk, double expectedTheta, int expectedEntries, boolean expectedEmpty) {
        boolean emptyOk;
        double actualTheta = csk.getTheta();
        int actualEntries = csk.getRetainedEntries();
        boolean actualEmpty = csk.isEmpty();
        boolean thetaOk = actualTheta == expectedTheta;
        boolean entriesOk = actualEntries == expectedEntries;
        boolean bl = emptyOk = actualEmpty == expectedEmpty;
        if (!(thetaOk && entriesOk && emptyOk)) {
            StringBuilder sb = new StringBuilder();
            sb.append(comment + ": ");
            if (!thetaOk) {
                sb.append("Theta: expected " + expectedTheta + ", got " + actualTheta + "; ");
            }
            if (!entriesOk) {
                sb.append("Entries: expected " + expectedEntries + ", got " + actualEntries + "; ");
            }
            if (!emptyOk) {
                sb.append("Empty: expected " + expectedEmpty + ", got " + actualEmpty + ".");
            }
            throw new IllegalArgumentException(sb.toString());
        }
    }

    private static IntegerTupleSketch getTupleSketch(SkType skType, float p, long updateKey) {
        IntegerTupleSketch sk;
        switch (skType.ordinal()) {
            case 0: {
                sk = new IntegerTupleSketch(4, 2, 1.0f, IntegerSummary.Mode.Min);
                break;
            }
            case 1: {
                sk = new IntegerTupleSketch(4, 2, 1.0f, IntegerSummary.Mode.Min);
                sk.update(updateKey, Integer.valueOf(1));
                break;
            }
            case 2: {
                CornerCaseTupleSetOperationsTest.checkValidUpdate(p, updateKey);
                sk = new IntegerTupleSketch(4, 2, p, IntegerSummary.Mode.Min);
                sk.update(updateKey, Integer.valueOf(1));
                break;
            }
            case 3: {
                CornerCaseTupleSetOperationsTest.checkInvalidUpdate(p, updateKey);
                sk = new IntegerTupleSketch(4, 2, p, IntegerSummary.Mode.Min);
                sk.update(updateKey, Integer.valueOf(1));
                break;
            }
            default: {
                return null;
            }
        }
        return sk;
    }

    private static UpdatableThetaSketch getThetaSketch(SkType skType, float p, long updateKey) {
        UpdatableThetaSketch sk;
        UpdatableThetaSketchBuilder bldr = new UpdatableThetaSketchBuilder();
        bldr.setLogNominalEntries(4);
        bldr.setResizeFactor(ResizeFactor.X4);
        switch (skType.ordinal()) {
            case 0: {
                sk = bldr.build();
                break;
            }
            case 1: {
                sk = bldr.build();
                sk.update(updateKey);
                break;
            }
            case 2: {
                CornerCaseTupleSetOperationsTest.checkValidUpdate(p, updateKey);
                bldr.setP(p);
                sk = bldr.build();
                sk.update(updateKey);
                break;
            }
            case 3: {
                CornerCaseTupleSetOperationsTest.checkInvalidUpdate(p, updateKey);
                bldr.setP(p);
                sk = bldr.build();
                sk.update(updateKey);
                break;
            }
            default: {
                return null;
            }
        }
        return sk;
    }

    private static void checkValidUpdate(float p, long updateKey) {
        Assert.assertTrue((CornerCaseTupleSetOperationsTest.getLongHash(updateKey) < (long)(p * 9.223372E18f) ? 1 : 0) != 0);
    }

    private static void checkInvalidUpdate(float p, long updateKey) {
        Assert.assertTrue((CornerCaseTupleSetOperationsTest.getLongHash(updateKey) > (long)(p * 9.223372E18f) ? 1 : 0) != 0);
    }

    static long getLongHash(long v) {
        return MurmurHash3.hash((long)v, (long)9001L)[0] >>> 1;
    }

    private static enum SkType {
        EMPTY,
        EXACT,
        ESTIMATION,
        DEGENERATE;

    }
}

