/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.utils;

import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.exception.FileLockException;
import com.qcloud.cos.internal.FileLocks;
import com.qcloud.cos.internal.SkipMd5CheckStrategy;
import com.qcloud.cos.model.COSObject;
import com.qcloud.cos.model.ObjectMetadata;
import com.qcloud.cos.utils.BinaryUtils;
import com.qcloud.cos.utils.IOUtils;
import com.qcloud.cos.utils.Md5Utils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.SocketException;
import java.util.Arrays;
import javax.net.ssl.SSLProtocolException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceUtils {
    private static final Logger log = LoggerFactory.getLogger(ServiceUtils.class);
    private static final SkipMd5CheckStrategy skipMd5CheckStrategy = SkipMd5CheckStrategy.INSTANCE;
    public static final boolean APPEND_MODE = true;
    public static final boolean OVERWRITE_MODE = false;

    public static void downloadToFile(COSObject cosObject, File dstfile, boolean performIntegrityCheck, boolean appendData, long expectedFileLength) {
        File parentDirectory = dstfile.getParentFile();
        if (parentDirectory != null && !parentDirectory.exists() && !parentDirectory.mkdirs()) {
            throw new CosClientException("Unable to create directory in the path" + parentDirectory.getAbsolutePath());
        }
        if (!FileLocks.lock(dstfile)) {
            throw new FileLockException("Fail to lock " + dstfile + " for appendData=" + appendData);
        }
        BufferedOutputStream outputStream = null;
        try {
            int bytesRead;
            long actualLen = dstfile.length();
            if (appendData && actualLen != expectedFileLength) {
                throw new IllegalStateException("Expected file length to append is " + expectedFileLength + " but actual length is " + actualLen + " for file " + dstfile);
            }
            outputStream = new BufferedOutputStream(new FileOutputStream(dstfile, appendData));
            byte[] buffer = new byte[10240];
            while ((bytesRead = cosObject.getObjectContent().read(buffer)) > -1) {
                ((OutputStream)outputStream).write(buffer, 0, bytesRead);
            }
        }
        catch (IOException e) {
            try {
                cosObject.getObjectContent().abort();
                throw new CosClientException("Unable to store object contents to disk: " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(outputStream, log);
                FileLocks.unlock(dstfile);
                IOUtils.closeQuietly(cosObject.getObjectContent(), log);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(outputStream, log);
        FileLocks.unlock(dstfile);
        IOUtils.closeQuietly(cosObject.getObjectContent(), log);
        if (performIntegrityCheck) {
            byte[] clientSideHash = null;
            byte[] serverSideHash = null;
            try {
                ObjectMetadata metadata = cosObject.getObjectMetadata();
                if (!skipMd5CheckStrategy.skipClientSideValidationPerGetResponse(metadata)) {
                    clientSideHash = Md5Utils.computeMD5Hash(dstfile);
                    serverSideHash = BinaryUtils.fromHex(metadata.getETag());
                }
            }
            catch (Exception e) {
                log.warn("Unable to calculate MD5 hash to validate download: " + e.getMessage(), (Throwable)e);
            }
            if (clientSideHash != null && serverSideHash != null && !Arrays.equals(clientSideHash, serverSideHash)) {
                throw new CosClientException("Unable to verify integrity of data download.  Client calculated content hash didn't match hash calculated by Qcloud COS.  The data stored in '" + dstfile.getAbsolutePath() + "' may be corrupt.");
            }
        }
    }

    public static void downloadObjectToFile(COSObject cosObject, File destinationFile, boolean performIntegrityCheck, boolean appendData) {
        ServiceUtils.downloadToFile(cosObject, destinationFile, performIntegrityCheck, appendData, -1L);
    }

    public static COSObject retryableDownloadCOSObjectToFile(File file, RetryableCOSDownloadTask retryableCOSDownloadTask, boolean appendData) {
        COSObject cosObject;
        boolean needRetry;
        boolean hasRetried = false;
        do {
            needRetry = false;
            cosObject = retryableCOSDownloadTask.getCOSObjectStream();
            if (cosObject == null) {
                return null;
            }
            try {
                ServiceUtils.downloadObjectToFile(cosObject, file, retryableCOSDownloadTask.needIntegrityCheck(), appendData);
            }
            catch (CosClientException cse) {
                if (!cse.isRetryable()) {
                    cosObject.getObjectContent().abort();
                    throw cse;
                }
                if (cse.getCause() instanceof SocketException || cse.getCause() instanceof SSLProtocolException) {
                    throw cse;
                }
                needRetry = true;
                if (hasRetried) {
                    cosObject.getObjectContent().abort();
                    throw cse;
                }
                log.info("Retry the download of object " + cosObject.getKey() + " (bucket " + cosObject.getBucketName() + ")", (Throwable)cse);
                hasRetried = true;
            }
        } while (needRetry);
        return cosObject;
    }

    public static interface RetryableCOSDownloadTask {
        public COSObject getCOSObjectStream();

        public boolean needIntegrityCheck();
    }
}

