/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.executor.workflow;

import lombok.Generated;
import org.apache.dolphinscheduler.api.exceptions.ServiceException;
import org.apache.dolphinscheduler.api.executor.workflow.IExecutorDelegate;
import org.apache.dolphinscheduler.common.enums.WorkflowExecutionStatus;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.entity.WorkflowInstance;
import org.apache.dolphinscheduler.dao.repository.SerialCommandDao;
import org.apache.dolphinscheduler.dao.repository.WorkflowInstanceDao;
import org.apache.dolphinscheduler.extract.base.client.Clients;
import org.apache.dolphinscheduler.extract.master.IWorkflowControlClient;
import org.apache.dolphinscheduler.extract.master.transportor.workflow.WorkflowInstancePauseRequest;
import org.apache.dolphinscheduler.extract.master.transportor.workflow.WorkflowInstancePauseResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.support.TransactionTemplate;

@Component
public class PauseWorkflowInstanceExecutorDelegate
implements IExecutorDelegate<PauseWorkflowInstanceOperation, Void> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PauseWorkflowInstanceExecutorDelegate.class);
    @Autowired
    private WorkflowInstanceDao workflowInstanceDao;
    @Autowired
    private TransactionTemplate transactionTemplate;
    @Autowired
    private SerialCommandDao serialCommandDao;

    @Override
    public Void execute(PauseWorkflowInstanceOperation workflowInstanceControlRequest) {
        WorkflowInstance workflowInstance = workflowInstanceControlRequest.workflowInstance;
        this.exceptionIfWorkflowInstanceCannotPause(workflowInstance);
        if (workflowInstance.getState().isCanDirectPauseInDB()) {
            this.directPauseInDB(workflowInstance);
        } else {
            this.pauseInMaster(workflowInstance);
        }
        return null;
    }

    private void exceptionIfWorkflowInstanceCannotPause(WorkflowInstance workflowInstance) {
        WorkflowExecutionStatus workflowInstanceState = workflowInstance.getState();
        if (workflowInstanceState.isCanPause()) {
            return;
        }
        throw new ServiceException("The workflow instance: " + workflowInstance.getName() + " status is " + workflowInstanceState + ", can not pause");
    }

    private void directPauseInDB(WorkflowInstance workflowInstance) {
        this.transactionTemplate.execute(status -> {
            this.workflowInstanceDao.updateWorkflowInstanceState(workflowInstance.getId(), workflowInstance.getState(), WorkflowExecutionStatus.PAUSE);
            this.serialCommandDao.deleteByWorkflowInstanceId(workflowInstance.getId());
            return null;
        });
        log.info("Update workflow instance {} state from: {} to {} success", new Object[]{workflowInstance.getName(), workflowInstance.getState().name(), WorkflowExecutionStatus.PAUSE.name()});
    }

    private void pauseInMaster(WorkflowInstance workflowInstance) {
        try {
            WorkflowInstancePauseResponse pauseResponse = ((IWorkflowControlClient)Clients.withService(IWorkflowControlClient.class).withHost(workflowInstance.getHost())).pauseWorkflowInstance(new WorkflowInstancePauseRequest(workflowInstance.getId()));
            if (pauseResponse == null || !pauseResponse.isSuccess()) {
                throw new ServiceException("WorkflowInstance: " + workflowInstance.getName() + " pause failed: " + pauseResponse);
            }
            log.info("WorkflowInstance: {} pause success", (Object)workflowInstance.getName());
        }
        catch (ServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServiceException(String.format("WorkflowInstance: %s pause failed", workflowInstance.getName()), e);
        }
    }

    public static class PauseWorkflowInstanceOperation {
        private final PauseWorkflowInstanceExecutorDelegate pauseWorkflowInstanceExecutorDelegate;
        private WorkflowInstance workflowInstance;
        private User executeUser;

        public PauseWorkflowInstanceOperation(PauseWorkflowInstanceExecutorDelegate pauseWorkflowInstanceExecutorDelegate) {
            this.pauseWorkflowInstanceExecutorDelegate = pauseWorkflowInstanceExecutorDelegate;
        }

        public PauseWorkflowInstanceOperation onWorkflowInstance(WorkflowInstance workflowInstance) {
            this.workflowInstance = workflowInstance;
            return this;
        }

        public PauseWorkflowInstanceOperation byUser(User executeUser) {
            this.executeUser = executeUser;
            return this;
        }

        public void execute() {
            this.pauseWorkflowInstanceExecutorDelegate.execute(this);
        }
    }
}

