/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.vo;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.dolphinscheduler.common.enums.WorkflowExecutionStatus;
import org.apache.dolphinscheduler.dao.model.WorkflowInstanceStatusCountDto;

public class WorkflowInstanceCountVO {
    private int totalCount;
    private List<WorkflowInstanceStatusCountDto> workflowInstanceStatusCounts;

    public static WorkflowInstanceCountVO empty() {
        return WorkflowInstanceCountVO.of(Collections.emptyList());
    }

    public static WorkflowInstanceCountVO of(List<WorkflowInstanceStatusCountDto> workflowInstanceStatusCountDtos) {
        workflowInstanceStatusCountDtos = new ArrayList<WorkflowInstanceStatusCountDto>(workflowInstanceStatusCountDtos);
        Map workflowExecutionStatusWorkflowInstanceStatusCountMap = workflowInstanceStatusCountDtos.stream().collect(Collectors.toMap(WorkflowInstanceStatusCountDto::getState, Function.identity()));
        for (WorkflowExecutionStatus workflowExecutionStatus : WorkflowExecutionStatus.values()) {
            if (workflowExecutionStatusWorkflowInstanceStatusCountMap.containsKey(workflowExecutionStatus)) continue;
            workflowInstanceStatusCountDtos.add(new WorkflowInstanceStatusCountDto(workflowExecutionStatus, 0));
        }
        WorkflowInstanceCountVO workflowInstanceCountVo = new WorkflowInstanceCountVO();
        workflowInstanceCountVo.setWorkflowInstanceStatusCounts(workflowInstanceStatusCountDtos);
        workflowInstanceCountVo.setTotalCount(workflowInstanceStatusCountDtos.stream().mapToInt(WorkflowInstanceStatusCountDto::getCount).sum());
        return workflowInstanceCountVo;
    }

    @Generated
    public int getTotalCount() {
        return this.totalCount;
    }

    @Generated
    public List<WorkflowInstanceStatusCountDto> getWorkflowInstanceStatusCounts() {
        return this.workflowInstanceStatusCounts;
    }

    @Generated
    public void setTotalCount(int totalCount) {
        this.totalCount = totalCount;
    }

    @Generated
    public void setWorkflowInstanceStatusCounts(List<WorkflowInstanceStatusCountDto> workflowInstanceStatusCounts) {
        this.workflowInstanceStatusCounts = workflowInstanceStatusCounts;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WorkflowInstanceCountVO)) {
            return false;
        }
        WorkflowInstanceCountVO other = (WorkflowInstanceCountVO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTotalCount() != other.getTotalCount()) {
            return false;
        }
        List<WorkflowInstanceStatusCountDto> this$workflowInstanceStatusCounts = this.getWorkflowInstanceStatusCounts();
        List<WorkflowInstanceStatusCountDto> other$workflowInstanceStatusCounts = other.getWorkflowInstanceStatusCounts();
        return !(this$workflowInstanceStatusCounts == null ? other$workflowInstanceStatusCounts != null : !((Object)this$workflowInstanceStatusCounts).equals(other$workflowInstanceStatusCounts));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof WorkflowInstanceCountVO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getTotalCount();
        List<WorkflowInstanceStatusCountDto> $workflowInstanceStatusCounts = this.getWorkflowInstanceStatusCounts();
        result = result * 59 + ($workflowInstanceStatusCounts == null ? 43 : ((Object)$workflowInstanceStatusCounts).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "WorkflowInstanceCountVO(totalCount=" + this.getTotalCount() + ", workflowInstanceStatusCounts=" + this.getWorkflowInstanceStatusCounts() + ")";
    }

    @Generated
    public WorkflowInstanceCountVO() {
    }

    @Generated
    public WorkflowInstanceCountVO(int totalCount, List<WorkflowInstanceStatusCountDto> workflowInstanceStatusCounts) {
        this.totalCount = totalCount;
        this.workflowInstanceStatusCounts = workflowInstanceStatusCounts;
    }
}

