/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1ConfigMapVolumeSource;
import io.kubernetes.client.openapi.models.V1ConfigMapVolumeSourceFluent;
import io.kubernetes.client.openapi.models.V1KeyToPath;
import io.kubernetes.client.openapi.models.V1KeyToPathBuilder;
import io.kubernetes.client.openapi.models.V1KeyToPathFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class V1ConfigMapVolumeSourceFluentImpl<A extends V1ConfigMapVolumeSourceFluent<A>>
extends BaseFluent<A>
implements V1ConfigMapVolumeSourceFluent<A> {
    private Integer defaultMode;
    private List<V1KeyToPathBuilder> items;
    private String name;
    private Boolean optional;

    public V1ConfigMapVolumeSourceFluentImpl() {
    }

    public V1ConfigMapVolumeSourceFluentImpl(V1ConfigMapVolumeSource instance) {
        this.withDefaultMode(instance.getDefaultMode());
        this.withItems(instance.getItems());
        this.withName(instance.getName());
        this.withOptional(instance.getOptional());
    }

    @Override
    public Integer getDefaultMode() {
        return this.defaultMode;
    }

    @Override
    public A withDefaultMode(Integer defaultMode) {
        this.defaultMode = defaultMode;
        return (A)this;
    }

    @Override
    public Boolean hasDefaultMode() {
        return this.defaultMode != null;
    }

    @Override
    public A addToItems(int index, V1KeyToPath item) {
        if (this.items == null) {
            this.items = new ArrayList<V1KeyToPathBuilder>();
        }
        V1KeyToPathBuilder builder = new V1KeyToPathBuilder(item);
        this._visitables.get("items").add(index >= 0 ? index : this._visitables.get("items").size(), builder);
        this.items.add(index >= 0 ? index : this.items.size(), builder);
        return (A)this;
    }

    @Override
    public A setToItems(int index, V1KeyToPath item) {
        if (this.items == null) {
            this.items = new ArrayList<V1KeyToPathBuilder>();
        }
        V1KeyToPathBuilder builder = new V1KeyToPathBuilder(item);
        if (index < 0 || index >= this._visitables.get("items").size()) {
            this._visitables.get("items").add(builder);
        } else {
            this._visitables.get("items").set(index, builder);
        }
        if (index < 0 || index >= this.items.size()) {
            this.items.add(builder);
        } else {
            this.items.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToItems(V1KeyToPath ... items) {
        if (this.items == null) {
            this.items = new ArrayList<V1KeyToPathBuilder>();
        }
        for (V1KeyToPath item : items) {
            V1KeyToPathBuilder builder = new V1KeyToPathBuilder(item);
            this._visitables.get("items").add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToItems(Collection<V1KeyToPath> items) {
        if (this.items == null) {
            this.items = new ArrayList<V1KeyToPathBuilder>();
        }
        for (V1KeyToPath item : items) {
            V1KeyToPathBuilder builder = new V1KeyToPathBuilder(item);
            this._visitables.get("items").add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromItems(V1KeyToPath ... items) {
        for (V1KeyToPath item : items) {
            V1KeyToPathBuilder builder = new V1KeyToPathBuilder(item);
            this._visitables.get("items").remove(builder);
            if (this.items == null) continue;
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromItems(Collection<V1KeyToPath> items) {
        for (V1KeyToPath item : items) {
            V1KeyToPathBuilder builder = new V1KeyToPathBuilder(item);
            this._visitables.get("items").remove(builder);
            if (this.items == null) continue;
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromItems(Predicate<V1KeyToPathBuilder> predicate) {
        if (this.items == null) {
            return (A)this;
        }
        Iterator<V1KeyToPathBuilder> each = this.items.iterator();
        Object visitables = this._visitables.get("items");
        while (each.hasNext()) {
            V1KeyToPathBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<V1KeyToPath> getItems() {
        return V1ConfigMapVolumeSourceFluentImpl.build(this.items);
    }

    @Override
    public List<V1KeyToPath> buildItems() {
        return V1ConfigMapVolumeSourceFluentImpl.build(this.items);
    }

    @Override
    public V1KeyToPath buildItem(int index) {
        return this.items.get(index).build();
    }

    @Override
    public V1KeyToPath buildFirstItem() {
        return this.items.get(0).build();
    }

    @Override
    public V1KeyToPath buildLastItem() {
        return this.items.get(this.items.size() - 1).build();
    }

    @Override
    public V1KeyToPath buildMatchingItem(Predicate<V1KeyToPathBuilder> predicate) {
        for (V1KeyToPathBuilder item : this.items) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingItem(Predicate<V1KeyToPathBuilder> predicate) {
        for (V1KeyToPathBuilder item : this.items) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withItems(List<V1KeyToPath> items) {
        if (this.items != null) {
            this._visitables.get("items").removeAll(this.items);
        }
        if (items != null) {
            this.items = new ArrayList<V1KeyToPathBuilder>();
            for (V1KeyToPath item : items) {
                this.addToItems(item);
            }
        } else {
            this.items = null;
        }
        return (A)this;
    }

    @Override
    public A withItems(V1KeyToPath ... items) {
        if (this.items != null) {
            this.items.clear();
        }
        if (items != null) {
            for (V1KeyToPath item : items) {
                this.addToItems(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasItems() {
        return this.items != null && !this.items.isEmpty();
    }

    @Override
    public V1ConfigMapVolumeSourceFluent.ItemsNested<A> addNewItem() {
        return new ItemsNestedImpl();
    }

    @Override
    public V1ConfigMapVolumeSourceFluent.ItemsNested<A> addNewItemLike(V1KeyToPath item) {
        return new ItemsNestedImpl(-1, item);
    }

    @Override
    public V1ConfigMapVolumeSourceFluent.ItemsNested<A> setNewItemLike(int index, V1KeyToPath item) {
        return new ItemsNestedImpl(index, item);
    }

    @Override
    public V1ConfigMapVolumeSourceFluent.ItemsNested<A> editItem(int index) {
        if (this.items.size() <= index) {
            throw new RuntimeException("Can't edit items. Index exceeds size.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public V1ConfigMapVolumeSourceFluent.ItemsNested<A> editFirstItem() {
        if (this.items.size() == 0) {
            throw new RuntimeException("Can't edit first items. The list is empty.");
        }
        return this.setNewItemLike(0, this.buildItem(0));
    }

    @Override
    public V1ConfigMapVolumeSourceFluent.ItemsNested<A> editLastItem() {
        int index = this.items.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last items. The list is empty.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public V1ConfigMapVolumeSourceFluent.ItemsNested<A> editMatchingItem(Predicate<V1KeyToPathBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.items.size(); ++i) {
            if (!predicate.test(this.items.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching items. No match found.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public Boolean hasName() {
        return this.name != null;
    }

    @Override
    @Deprecated
    public A withNewName(String original) {
        return this.withName(new String(original));
    }

    @Override
    public Boolean getOptional() {
        return this.optional;
    }

    @Override
    public A withOptional(Boolean optional) {
        this.optional = optional;
        return (A)this;
    }

    @Override
    public Boolean hasOptional() {
        return this.optional != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1ConfigMapVolumeSourceFluentImpl that = (V1ConfigMapVolumeSourceFluentImpl)o;
        if (this.defaultMode != null ? !this.defaultMode.equals(that.defaultMode) : that.defaultMode != null) {
            return false;
        }
        if (this.items != null ? !this.items.equals(that.items) : that.items != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        return !(this.optional != null ? !this.optional.equals(that.optional) : that.optional != null);
    }

    public int hashCode() {
        return Objects.hash(this.defaultMode, this.items, this.name, this.optional, super.hashCode());
    }

    public class ItemsNestedImpl<N>
    extends V1KeyToPathFluentImpl<V1ConfigMapVolumeSourceFluent.ItemsNested<N>>
    implements V1ConfigMapVolumeSourceFluent.ItemsNested<N>,
    Nested<N> {
        private final V1KeyToPathBuilder builder;
        private final int index;

        ItemsNestedImpl(int index, V1KeyToPath item) {
            this.index = index;
            this.builder = new V1KeyToPathBuilder(this, item);
        }

        ItemsNestedImpl() {
            this.index = -1;
            this.builder = new V1KeyToPathBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1ConfigMapVolumeSourceFluentImpl.this.setToItems(this.index, this.builder.build());
        }

        @Override
        public N endItem() {
            return this.and();
        }
    }
}

