/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="HorizontalPodAutoscalerCondition describes the state of a HorizontalPodAutoscaler at a certain point.")
public class V2beta1HorizontalPodAutoscalerCondition {
    public static final String SERIALIZED_NAME_LAST_TRANSITION_TIME = "lastTransitionTime";
    @SerializedName(value="lastTransitionTime")
    private OffsetDateTime lastTransitionTime;
    public static final String SERIALIZED_NAME_MESSAGE = "message";
    @SerializedName(value="message")
    private String message;
    public static final String SERIALIZED_NAME_REASON = "reason";
    @SerializedName(value="reason")
    private String reason;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private String status;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private String type;

    public V2beta1HorizontalPodAutoscalerCondition lastTransitionTime(OffsetDateTime lastTransitionTime) {
        this.lastTransitionTime = lastTransitionTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="lastTransitionTime is the last time the condition transitioned from one status to another")
    public OffsetDateTime getLastTransitionTime() {
        return this.lastTransitionTime;
    }

    public void setLastTransitionTime(OffsetDateTime lastTransitionTime) {
        this.lastTransitionTime = lastTransitionTime;
    }

    public V2beta1HorizontalPodAutoscalerCondition message(String message) {
        this.message = message;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="message is a human-readable explanation containing details about the transition")
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public V2beta1HorizontalPodAutoscalerCondition reason(String reason) {
        this.reason = reason;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="reason is the reason for the condition's last transition.")
    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public V2beta1HorizontalPodAutoscalerCondition status(String status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(required=true, value="status is the status of the condition (True, False, Unknown)")
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public V2beta1HorizontalPodAutoscalerCondition type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="type describes the current condition")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V2beta1HorizontalPodAutoscalerCondition v2beta1HorizontalPodAutoscalerCondition = (V2beta1HorizontalPodAutoscalerCondition)o;
        return Objects.equals(this.lastTransitionTime, v2beta1HorizontalPodAutoscalerCondition.lastTransitionTime) && Objects.equals(this.message, v2beta1HorizontalPodAutoscalerCondition.message) && Objects.equals(this.reason, v2beta1HorizontalPodAutoscalerCondition.reason) && Objects.equals(this.status, v2beta1HorizontalPodAutoscalerCondition.status) && Objects.equals(this.type, v2beta1HorizontalPodAutoscalerCondition.type);
    }

    public int hashCode() {
        return Objects.hash(this.lastTransitionTime, this.message, this.reason, this.status, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V2beta1HorizontalPodAutoscalerCondition {\n");
        sb.append("    lastTransitionTime: ").append(this.toIndentedString(this.lastTransitionTime)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    reason: ").append(this.toIndentedString(this.reason)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

