/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.common.log.remote;

import com.azure.storage.blob.BlobContainerClient;
import com.azure.storage.blob.BlobServiceClient;
import com.azure.storage.blob.BlobServiceClientBuilder;
import com.azure.storage.blob.specialized.BlobInputStream;
import com.azure.storage.common.StorageSharedKeyCredential;
import java.io.Closeable;
import java.io.FileOutputStream;
import java.io.IOException;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.log.remote.RemoteLogHandler;
import org.apache.dolphinscheduler.common.log.remote.RemoteLogUtils;
import org.apache.dolphinscheduler.common.utils.PropertyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbsRemoteLogHandler
implements RemoteLogHandler,
Closeable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbsRemoteLogHandler.class);
    private String accountName = this.readAccountName();
    private String accountKey = this.readAccountKey();
    private String containerName = this.readContainerName();
    private BlobContainerClient blobContainerClient = this.buildBlobContainerClient();
    private static AbsRemoteLogHandler instance;

    private AbsRemoteLogHandler() {
    }

    public static synchronized AbsRemoteLogHandler getInstance() {
        if (instance == null) {
            instance = new AbsRemoteLogHandler();
        }
        return instance;
    }

    protected BlobContainerClient buildBlobContainerClient() {
        BlobServiceClient serviceClient = new BlobServiceClientBuilder().endpoint(String.format("https://%s.blob.core.windows.net/", this.accountName)).credential(new StorageSharedKeyCredential(this.accountName, this.accountKey)).buildClient();
        if (StringUtils.isBlank((CharSequence)this.containerName)) {
            throw new IllegalArgumentException("remote.logging.abs.container.name is blank");
        }
        try {
            this.blobContainerClient = serviceClient.getBlobContainerClient(this.containerName);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("containerName: " + this.containerName + " is not exists, you need to create them by yourself");
        }
        log.info("containerName: {} has been found.", (Object)this.containerName);
        return this.blobContainerClient;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void sendRemoteLog(String logPath) {
        String objectName = RemoteLogUtils.getObjectNameFromLogPath(logPath);
        try {
            log.info("send remote log {} to Azure Blob {}", (Object)logPath, (Object)objectName);
            this.blobContainerClient.getBlobClient(objectName).uploadFromFile(logPath);
        }
        catch (Exception e) {
            log.error("error while sending remote log {} to Azure Blob {}", new Object[]{logPath, objectName, e});
        }
    }

    @Override
    public void getRemoteLog(String logPath) {
        String objectName = RemoteLogUtils.getObjectNameFromLogPath(logPath);
        try {
            log.info("get remote log on Azure Blob {} to {}", (Object)objectName, (Object)logPath);
            try (BlobInputStream bis = this.blobContainerClient.getBlobClient(objectName).openInputStream();
                 FileOutputStream fos = new FileOutputStream(logPath);){
                byte[] readBuf = new byte[1024];
                int readLen = 0;
                while ((readLen = bis.read(readBuf)) > 0) {
                    fos.write(readBuf, 0, readLen);
                }
            }
        }
        catch (Exception e) {
            log.error("error while getting remote log on Azure Blob {} to {}", new Object[]{objectName, logPath, e});
        }
    }

    protected String readAccountName() {
        return PropertyUtils.getString("remote.logging.abs.account.name");
    }

    protected String readAccountKey() {
        return PropertyUtils.getString("remote.logging.abs.account.key");
    }

    protected String readContainerName() {
        return PropertyUtils.getString("remote.logging.abs.container.name");
    }
}

