/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.trafficmanager.implementation;

import com.azure.core.management.Resource;
import com.azure.resourcemanager.resources.fluentcore.arm.Manager;
import com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.GroupableResourceImpl;
import com.azure.resourcemanager.resources.fluentcore.model.implementation.IndexableRefreshableWrapperImpl;
import com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import com.azure.resourcemanager.trafficmanager.TrafficManager;
import com.azure.resourcemanager.trafficmanager.fluent.ProfilesClient;
import com.azure.resourcemanager.trafficmanager.fluent.TrafficManagerManagementClient;
import com.azure.resourcemanager.trafficmanager.fluent.models.ProfileInner;
import com.azure.resourcemanager.trafficmanager.implementation.TrafficManagerEndpointImpl;
import com.azure.resourcemanager.trafficmanager.implementation.TrafficManagerEndpointsImpl;
import com.azure.resourcemanager.trafficmanager.models.MonitorProtocol;
import com.azure.resourcemanager.trafficmanager.models.ProfileMonitorStatus;
import com.azure.resourcemanager.trafficmanager.models.ProfileStatus;
import com.azure.resourcemanager.trafficmanager.models.TrafficManagerAzureEndpoint;
import com.azure.resourcemanager.trafficmanager.models.TrafficManagerExternalEndpoint;
import com.azure.resourcemanager.trafficmanager.models.TrafficManagerNestedProfileEndpoint;
import com.azure.resourcemanager.trafficmanager.models.TrafficManagerProfile;
import com.azure.resourcemanager.trafficmanager.models.TrafficRoutingMethod;
import java.util.Map;
import reactor.core.publisher.Mono;

class TrafficManagerProfileImpl
extends GroupableResourceImpl<TrafficManagerProfile, ProfileInner, TrafficManagerProfileImpl, TrafficManager>
implements TrafficManagerProfile,
TrafficManagerProfile.Definition,
TrafficManagerProfile.Update {
    private TrafficManagerEndpointsImpl endpoints;

    TrafficManagerProfileImpl(String name, ProfileInner innerModel, TrafficManager trafficManager) {
        super(name, (Resource)innerModel, (Manager)trafficManager);
        this.endpoints = new TrafficManagerEndpointsImpl(((TrafficManagerManagementClient)trafficManager.serviceClient()).getEndpoints(), this);
        this.endpoints.enablePostRunMode();
    }

    @Override
    public String dnsLabel() {
        return ((ProfileInner)((Object)this.innerModel())).dnsConfig().relativeName();
    }

    @Override
    public String fqdn() {
        return ((ProfileInner)((Object)this.innerModel())).dnsConfig().fqdn();
    }

    @Override
    public long timeToLive() {
        return ResourceManagerUtils.toPrimitiveLong((Long)((ProfileInner)((Object)this.innerModel())).dnsConfig().ttl());
    }

    @Override
    public boolean isEnabled() {
        return ((ProfileInner)((Object)this.innerModel())).profileStatus().equals((Object)ProfileStatus.ENABLED);
    }

    @Override
    public TrafficRoutingMethod trafficRoutingMethod() {
        return ((ProfileInner)((Object)this.innerModel())).trafficRoutingMethod();
    }

    @Override
    public ProfileMonitorStatus monitorStatus() {
        return ((ProfileInner)((Object)this.innerModel())).monitorConfig().profileMonitorStatus();
    }

    @Override
    public long monitoringPort() {
        return ResourceManagerUtils.toPrimitiveLong((Long)((ProfileInner)((Object)this.innerModel())).monitorConfig().port());
    }

    @Override
    public String monitoringPath() {
        return ((ProfileInner)((Object)this.innerModel())).monitorConfig().path();
    }

    @Override
    public Map<String, TrafficManagerExternalEndpoint> externalEndpoints() {
        return this.endpoints.externalEndpointsAsMap();
    }

    @Override
    public Map<String, TrafficManagerAzureEndpoint> azureEndpoints() {
        return this.endpoints.azureEndpointsAsMap();
    }

    @Override
    public Map<String, TrafficManagerNestedProfileEndpoint> nestedProfileEndpoints() {
        return this.endpoints.nestedProfileEndpointsAsMap();
    }

    public Mono<TrafficManagerProfile> refreshAsync() {
        return super.refreshAsync().map(trafficManagerProfile -> {
            TrafficManagerProfileImpl impl = (TrafficManagerProfileImpl)trafficManagerProfile;
            impl.endpoints.refresh();
            return impl;
        });
    }

    protected Mono<ProfileInner> getInnerAsync() {
        return ((TrafficManagerManagementClient)((TrafficManager)this.manager()).serviceClient()).getProfiles().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    @Override
    public TrafficManagerProfileImpl withLeafDomainLabel(String dnsLabel) {
        ((ProfileInner)((Object)this.innerModel())).dnsConfig().withRelativeName(dnsLabel);
        return this;
    }

    @Override
    public TrafficManagerProfileImpl withPriorityBasedRouting() {
        return this.withTrafficRoutingMethod(TrafficRoutingMethod.PRIORITY);
    }

    @Override
    public TrafficManagerProfileImpl withWeightBasedRouting() {
        return this.withTrafficRoutingMethod(TrafficRoutingMethod.WEIGHTED);
    }

    @Override
    public TrafficManagerProfileImpl withPerformanceBasedRouting() {
        return this.withTrafficRoutingMethod(TrafficRoutingMethod.PERFORMANCE);
    }

    @Override
    public TrafficManagerProfileImpl withGeographicBasedRouting() {
        return this.withTrafficRoutingMethod(TrafficRoutingMethod.GEOGRAPHIC);
    }

    @Override
    public TrafficManagerProfileImpl withMultiValueBasedRouting(long maxResult) {
        ((ProfileInner)((Object)this.innerModel())).withMaxReturn(maxResult);
        return this.withTrafficRoutingMethod(TrafficRoutingMethod.MULTI_VALUE);
    }

    @Override
    public TrafficManagerProfileImpl withSubnetBasedRouting() {
        return this.withTrafficRoutingMethod(TrafficRoutingMethod.SUBNET);
    }

    @Override
    public TrafficManagerProfileImpl withTrafficRoutingMethod(TrafficRoutingMethod routingMethod) {
        ((ProfileInner)((Object)this.innerModel())).withTrafficRoutingMethod(routingMethod);
        return this;
    }

    public TrafficManagerEndpointImpl defineAzureTargetEndpoint(String name) {
        return this.endpoints.defineAzureTargetEndpoint(name);
    }

    public TrafficManagerEndpointImpl defineExternalTargetEndpoint(String name) {
        return this.endpoints.defineExteralTargetEndpoint(name);
    }

    public TrafficManagerEndpointImpl defineNestedTargetEndpoint(String name) {
        return this.endpoints.defineNestedProfileTargetEndpoint(name);
    }

    @Override
    public TrafficManagerEndpointImpl updateAzureTargetEndpoint(String name) {
        return this.endpoints.updateAzureEndpoint(name);
    }

    @Override
    public TrafficManagerEndpointImpl updateExternalTargetEndpoint(String name) {
        return this.endpoints.updateExternalEndpoint(name);
    }

    @Override
    public TrafficManagerEndpointImpl updateNestedProfileTargetEndpoint(String name) {
        return this.endpoints.updateNestedProfileEndpoint(name);
    }

    @Override
    public TrafficManagerProfileImpl withoutEndpoint(String name) {
        this.endpoints.remove(name);
        return this;
    }

    @Override
    public TrafficManagerProfileImpl withHttpMonitoring() {
        return this.withHttpMonitoring(80, "/");
    }

    @Override
    public TrafficManagerProfileImpl withHttpsMonitoring() {
        return this.withHttpsMonitoring(443, "/");
    }

    @Override
    public TrafficManagerProfileImpl withHttpMonitoring(int port, String path) {
        ((ProfileInner)((Object)this.innerModel())).monitorConfig().withPort(Long.valueOf(port)).withPath(path).withProtocol(MonitorProtocol.HTTP);
        return this;
    }

    @Override
    public TrafficManagerProfileImpl withHttpsMonitoring(int port, String path) {
        ((ProfileInner)((Object)this.innerModel())).monitorConfig().withPort(Long.valueOf(port)).withPath(path).withProtocol(MonitorProtocol.HTTPS);
        return this;
    }

    @Override
    public TrafficManagerProfileImpl withProfileStatusDisabled() {
        ((ProfileInner)((Object)this.innerModel())).withProfileStatus(ProfileStatus.DISABLED);
        return this;
    }

    @Override
    public TrafficManagerProfileImpl withProfileStatusEnabled() {
        ((ProfileInner)((Object)this.innerModel())).withProfileStatus(ProfileStatus.ENABLED);
        return this;
    }

    @Override
    public TrafficManagerProfileImpl withTimeToLive(int ttlInSeconds) {
        ((ProfileInner)((Object)this.innerModel())).dnsConfig().withTtl(Long.valueOf(ttlInSeconds));
        return this;
    }

    public TrafficManagerProfileImpl update() {
        this.endpoints.enableCommitMode();
        return (TrafficManagerProfileImpl)super.update();
    }

    public Mono<TrafficManagerProfile> createResourceAsync() {
        return ((TrafficManagerManagementClient)((TrafficManager)this.manager()).serviceClient()).getProfiles().createOrUpdateAsync(this.resourceGroupName(), this.name(), (ProfileInner)((Object)this.innerModel())).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this));
    }

    public Mono<TrafficManagerProfile> updateResourceAsync() {
        ProfilesClient innerCollection = ((TrafficManagerManagementClient)((TrafficManager)this.manager()).serviceClient()).getProfiles();
        return this.endpoints.commitAndGetAllAsync().flatMap(endpoints -> {
            ((ProfileInner)((Object)((Object)this.innerModel()))).withEndpoints(this.endpoints.allEndpointsInners());
            return innerCollection.createOrUpdateAsync(this.resourceGroupName(), this.name(), (ProfileInner)((Object)((Object)this.innerModel()))).map(profileInner -> {
                this.setInner(profileInner);
                return this;
            });
        });
    }

    public Mono<Void> afterPostRunAsync(boolean isGroupFaulted) {
        this.endpoints.clear();
        if (isGroupFaulted) {
            return Mono.empty();
        }
        return this.refreshAsync().then();
    }

    TrafficManagerProfileImpl withEndpoint(TrafficManagerEndpointImpl endpoint) {
        this.endpoints.addEndpoint(endpoint);
        return this;
    }
}

