/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.trafficmanager.models;

import com.azure.resourcemanager.resources.fluentcore.arm.models.GroupableResource;
import com.azure.resourcemanager.resources.fluentcore.arm.models.Resource;
import com.azure.resourcemanager.resources.fluentcore.model.Appliable;
import com.azure.resourcemanager.resources.fluentcore.model.Creatable;
import com.azure.resourcemanager.resources.fluentcore.model.Refreshable;
import com.azure.resourcemanager.resources.fluentcore.model.Updatable;
import com.azure.resourcemanager.trafficmanager.TrafficManager;
import com.azure.resourcemanager.trafficmanager.fluent.models.ProfileInner;
import com.azure.resourcemanager.trafficmanager.models.ProfileMonitorStatus;
import com.azure.resourcemanager.trafficmanager.models.TrafficManagerAzureEndpoint;
import com.azure.resourcemanager.trafficmanager.models.TrafficManagerEndpoint;
import com.azure.resourcemanager.trafficmanager.models.TrafficManagerExternalEndpoint;
import com.azure.resourcemanager.trafficmanager.models.TrafficManagerNestedProfileEndpoint;
import com.azure.resourcemanager.trafficmanager.models.TrafficRoutingMethod;
import java.util.Map;

public interface TrafficManagerProfile
extends GroupableResource<TrafficManager, ProfileInner>,
Refreshable<TrafficManagerProfile>,
Updatable<Update> {
    public String dnsLabel();

    public String fqdn();

    public long timeToLive();

    public boolean isEnabled();

    public TrafficRoutingMethod trafficRoutingMethod();

    public ProfileMonitorStatus monitorStatus();

    public long monitoringPort();

    public String monitoringPath();

    public Map<String, TrafficManagerExternalEndpoint> externalEndpoints();

    public Map<String, TrafficManagerAzureEndpoint> azureEndpoints();

    public Map<String, TrafficManagerNestedProfileEndpoint> nestedProfileEndpoints();

    public static interface Update
    extends Appliable<TrafficManagerProfile>,
    UpdateStages.WithTrafficRoutingMethod,
    UpdateStages.WithMonitoringConfiguration,
    UpdateStages.WithEndpoint,
    UpdateStages.WithTtl,
    UpdateStages.WithProfileStatus,
    Resource.UpdateWithTags<Update> {
    }

    public static interface UpdateStages {

        public static interface WithProfileStatus {
            public Update withProfileStatusDisabled();

            public Update withProfileStatusEnabled();
        }

        public static interface WithTtl {
            public Update withTimeToLive(int var1);
        }

        public static interface WithEndpoint {
            public TrafficManagerEndpoint.UpdateDefinitionStages.AzureTargetEndpointBlank<Update> defineAzureTargetEndpoint(String var1);

            public TrafficManagerEndpoint.UpdateDefinitionStages.ExternalTargetEndpointBlank<Update> defineExternalTargetEndpoint(String var1);

            public TrafficManagerEndpoint.UpdateDefinitionStages.NestedProfileTargetEndpointBlank<Update> defineNestedTargetEndpoint(String var1);

            public TrafficManagerEndpoint.UpdateAzureEndpoint updateAzureTargetEndpoint(String var1);

            public TrafficManagerEndpoint.UpdateExternalEndpoint updateExternalTargetEndpoint(String var1);

            public TrafficManagerEndpoint.UpdateNestedProfileEndpoint updateNestedProfileTargetEndpoint(String var1);

            public Update withoutEndpoint(String var1);
        }

        public static interface WithMonitoringConfiguration {
            public Update withHttpMonitoring();

            public Update withHttpsMonitoring();

            public Update withHttpMonitoring(int var1, String var2);

            public Update withHttpsMonitoring(int var1, String var2);
        }

        public static interface WithTrafficRoutingMethod {
            public Update withPriorityBasedRouting();

            public Update withWeightBasedRouting();

            public Update withPerformanceBasedRouting();

            public Update withGeographicBasedRouting();

            public Update withMultiValueBasedRouting(long var1);

            public Update withSubnetBasedRouting();

            public Update withTrafficRoutingMethod(TrafficRoutingMethod var1);
        }
    }

    public static interface DefinitionStages {

        public static interface WithCreate
        extends Creatable<TrafficManagerProfile>,
        Resource.DefinitionWithTags<WithCreate>,
        WithMonitoringConfiguration,
        WithTtl,
        WithProfileStatus,
        WithEndpoint {
        }

        public static interface WithProfileStatus {
            public WithCreate withProfileStatusDisabled();
        }

        public static interface WithTtl {
            public WithCreate withTimeToLive(int var1);
        }

        public static interface WithMonitoringConfiguration {
            public WithCreate withHttpMonitoring();

            public WithCreate withHttpsMonitoring();

            public WithCreate withHttpMonitoring(int var1, String var2);

            public WithCreate withHttpsMonitoring(int var1, String var2);
        }

        public static interface WithEndpoint {
            public TrafficManagerEndpoint.DefinitionStages.AzureTargetEndpointBlank<WithCreate> defineAzureTargetEndpoint(String var1);

            public TrafficManagerEndpoint.DefinitionStages.ExternalTargetEndpointBlank<WithCreate> defineExternalTargetEndpoint(String var1);

            public TrafficManagerEndpoint.DefinitionStages.NestedProfileTargetEndpointBlank<WithCreate> defineNestedTargetEndpoint(String var1);
        }

        public static interface WithTrafficRoutingMethod {
            public WithEndpoint withPriorityBasedRouting();

            public WithEndpoint withWeightBasedRouting();

            public WithEndpoint withPerformanceBasedRouting();

            public WithEndpoint withGeographicBasedRouting();

            public WithEndpoint withMultiValueBasedRouting(long var1);

            public WithEndpoint withSubnetBasedRouting();

            public WithEndpoint withTrafficRoutingMethod(TrafficRoutingMethod var1);
        }

        public static interface WithLeafDomainLabel {
            public WithTrafficRoutingMethod withLeafDomainLabel(String var1);
        }

        public static interface Blank
        extends GroupableResource.DefinitionStages.WithGroupAndRegion<WithLeafDomainLabel> {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithLeafDomainLabel,
    DefinitionStages.WithTrafficRoutingMethod,
    DefinitionStages.WithCreate {
    }
}

