/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.tools.datasource.upgrader.v320;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.dolphinscheduler.tools.datasource.upgrader.DolphinSchedulerUpgrader;
import org.apache.dolphinscheduler.tools.datasource.upgrader.DolphinSchedulerVersion;
import org.apache.dolphinscheduler.tools.datasource.upgrader.UpgradeDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class V320DolphinSchedulerUpgrader
implements DolphinSchedulerUpgrader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(V320DolphinSchedulerUpgrader.class);
    @Autowired
    private DataSource dataSource;
    @Autowired
    private UpgradeDao upgradeDao;

    @Override
    public void doUpgrade() {
        this.upgradeWorkflowInstance();
        this.upgradeTaskInstance();
        this.upgradeDao.upgradeDolphinSchedulerDDL(this.getCurrentVersion().getVersionName() + "_schema", "dolphinscheduler_ddl_post.sql");
    }

    private void upgradeWorkflowInstance() {
        Map<Integer, String> userMap = this.getUserMap();
        List<Map<String, Object>> needUpdateWorkflowInstances;
        while (!CollectionUtils.isEmpty(needUpdateWorkflowInstances = this.getProcessInstanceWhichProjectCodeIsNull())) {
            needUpdateWorkflowInstances.parallelStream().forEach(processInstance -> {
                Integer id = (Integer)processInstance.get("id");
                Long processDefinitionCode = (Long)processInstance.get("process_definition_code");
                Integer processDefinitionVersion = (Integer)processInstance.get("process_definition_version");
                Map<String, Object> processDefinitionLog = this.getProcessDefinitionLogByCode(processDefinitionCode, processDefinitionVersion);
                Long projectCode = -1L;
                String tenantCode = null;
                String executorName = null;
                if (MapUtils.isNotEmpty(processDefinitionLog)) {
                    Map<String, Object> scheduler = this.getSchedulerByProcessDefinitionCode(processDefinitionCode);
                    projectCode = processDefinitionLog.get("project_code") == null ? -1L : (Long)processDefinitionLog.get("project_code");
                    tenantCode = scheduler.get("tenant_code") == null ? "default" : (String)scheduler.get("tenant_code");
                    executorName = (String)userMap.get((Integer)processInstance.get("executor_id"));
                }
                this.updateProjectCodeInProcessInstance(id, projectCode, tenantCode, executorName);
            });
            log.info("Success upgrade workflow instance, current batch size: {}", (Object)needUpdateWorkflowInstances.size());
        }
        return;
    }

    private void upgradeTaskInstance() {
        List<Map<String, Object>> taskInstances;
        while (!CollectionUtils.isEmpty(taskInstances = this.getTaskInstanceWhichProjectCodeIsNull())) {
            taskInstances.parallelStream().forEach(taskInstance -> {
                Integer id = (Integer)taskInstance.get("id");
                Integer processInstanceId = (Integer)taskInstance.get("process_instance_id");
                Map<String, Object> processInstance = this.getProcessInstanceById(processInstanceId);
                Long projectCode = -1L;
                String processInstanceName = null;
                String executorName = null;
                if (MapUtils.isNotEmpty(processInstance)) {
                    projectCode = processInstance.get("project_code") == null ? -1L : (Long)processInstance.get("project_code");
                    processInstanceName = (String)processInstance.get("name");
                    executorName = (String)processInstance.get("executor_name");
                }
                this.updateProjectCodeInTaskInstance(id, projectCode, processInstanceName, executorName);
            });
            log.info("Success upgrade task instance, current batch size: {}", (Object)taskInstances.size());
        }
        return;
    }

    /*
     * Exception decompiling
     */
    private List<Map<String, Object>> getTaskInstanceWhichProjectCodeIsNull() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Map<Integer, String> getUserMap() {
        HashMap<Integer, String> userMap = new HashMap<Integer, String>();
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement("select id, user_name from t_ds_user");
             ResultSet resultSet = preparedStatement.executeQuery();){
            while (resultSet.next()) {
                userMap.put(resultSet.getInt("id"), resultSet.getString("user_name"));
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Query t_ds_user error", ex);
        }
        return userMap;
    }

    /*
     * Exception decompiling
     */
    private List<Map<String, Object>> getProcessInstanceWhichProjectCodeIsNull() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private Map<String, Object> getProcessInstanceById(Integer processInstanceId) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private Map<String, Object> getProcessDefinitionLogByCode(Long processDefinitionCode, Integer processDefinitionVersion) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private Map<String, Object> getSchedulerByProcessDefinitionCode(Long processDefinitionCode) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void updateProjectCodeInProcessInstance(Integer processInstanceId, Long projectCode, String tenantCode, String executorName) {
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement("update t_ds_process_instance set project_code = ?, tenant_code = ?, executor_name = ? where id = ?");){
            preparedStatement.setLong(1, projectCode);
            preparedStatement.setString(2, tenantCode);
            preparedStatement.setString(3, executorName);
            preparedStatement.setInt(4, processInstanceId);
            preparedStatement.executeUpdate();
        }
        catch (Exception ex) {
            throw new RuntimeException("Update t_ds_process_instance error", ex);
        }
    }

    private void updateProjectCodeInTaskInstance(Integer id, Long projectCode, String processInstanceName, String executorName) {
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement("update t_ds_task_instance set project_code = ?, process_instance_name = ?, executor_name = ? where id = ?");){
            preparedStatement.setLong(1, projectCode);
            preparedStatement.setString(2, processInstanceName);
            preparedStatement.setString(3, executorName);
            preparedStatement.setInt(4, id);
            preparedStatement.executeUpdate();
        }
        catch (Exception ex) {
            throw new RuntimeException("Update t_ds_process_instance error", ex);
        }
    }

    @Override
    public DolphinSchedulerVersion getCurrentVersion() {
        return DolphinSchedulerVersion.V3_2_0;
    }
}

