/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.common.utils;

import ch.qos.logback.classic.LoggerContext;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.dolphinscheduler.common.log.remote.RemoteLogUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LogUtils.class);

    /*
     * Exception decompiling
     */
    public static byte[] getFileContentBytesFromLocal(String filePath) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static byte[] getFileContentBytesFromRemote(String filePath) {
        RemoteLogUtils.getRemoteLog(filePath);
        return LogUtils.getFileContentBytesFromLocal(filePath);
    }

    public static byte[] getFileContentBytes(String filePath) {
        File file = new File(filePath);
        if (file.exists()) {
            return LogUtils.getFileContentBytesFromLocal(filePath);
        }
        if (RemoteLogUtils.isRemoteLoggingEnable()) {
            return LogUtils.getFileContentBytesFromRemote(filePath);
        }
        return LogUtils.getFileContentBytesFromLocal(filePath);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<String> readPartFileContentFromLocal(String filePath, int skipLine, int limit) {
        File file = new File(filePath);
        if (!file.exists()) throw new RuntimeException("The file path: " + filePath + " not exists");
        if (!file.isFile()) throw new RuntimeException("The file path: " + filePath + " not exists");
        try (Stream<String> stream = Files.lines(Paths.get(filePath, new String[0]));){
            List<String> list = stream.skip(skipLine).limit(limit).collect(Collectors.toList());
            return list;
        }
        catch (IOException e) {
            log.error("read file error", (Throwable)e);
            throw new RuntimeException(String.format("Read file: %s error", filePath), e);
        }
    }

    public static List<String> readPartFileContentFromRemote(String filePath, int skipLine, int limit) {
        RemoteLogUtils.getRemoteLog(filePath);
        return LogUtils.readPartFileContentFromLocal(filePath, skipLine, limit);
    }

    public static List<String> readPartFileContent(String filePath, int skipLine, int limit) {
        File file = new File(filePath);
        if (file.exists()) {
            return LogUtils.readPartFileContentFromLocal(filePath, skipLine, limit);
        }
        if (RemoteLogUtils.isRemoteLoggingEnable()) {
            return LogUtils.readPartFileContentFromRemote(filePath, skipLine, limit);
        }
        return LogUtils.readPartFileContentFromLocal(filePath, skipLine, limit);
    }

    public static String readWholeFileContentFromRemote(String filePath) {
        RemoteLogUtils.getRemoteLog(filePath);
        return LogUtils.readWholeFileContentFromLocal(filePath);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readWholeFileContentFromLocal(String filePath) {
        StringBuilder sb = new StringBuilder();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(filePath)));){
            String line;
            while ((line = br.readLine()) != null) {
                sb.append(line + "\r\n");
            }
            String string = sb.toString();
            return string;
        }
        catch (IOException e) {
            log.error("read file error", (Throwable)e);
            return "";
        }
    }

    public static String readWholeFileContent(String filePath) {
        File file = new File(filePath);
        if (file.exists()) {
            return LogUtils.readWholeFileContentFromLocal(filePath);
        }
        if (RemoteLogUtils.isRemoteLoggingEnable()) {
            return LogUtils.readWholeFileContentFromRemote(filePath);
        }
        return LogUtils.readWholeFileContentFromLocal(filePath);
    }

    public static String rollViewLogLines(List<String> lines) {
        StringBuilder builder = new StringBuilder();
        int MaxResponseLogSize = 65535;
        int totalLogByteSize = 0;
        for (String line : lines) {
            int lineByteSize = line.getBytes(StandardCharsets.UTF_8).length;
            if (lineByteSize >= 65535) {
                builder.append(line, 0, 65535).append(" [this line's size ").append(lineByteSize).append(" bytes is exceed ").append(65535).append(" bytes, so only ").append(65535).append(" characters are reserved for performance reasons.]").append("\r\n");
            } else {
                builder.append(line).append("\r\n");
            }
            if ((totalLogByteSize += lineByteSize) < 65535) continue;
            break;
        }
        return builder.toString();
    }

    public static String getLocalLogBaseDir() {
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        return loggerContext.getProperty("log.base.ctx");
    }
}

