/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.validator.resource;

import com.google.common.base.Preconditions;
import org.apache.dolphinscheduler.api.dto.resources.CreateFileFromContentDto;
import org.apache.dolphinscheduler.api.dto.resources.CreateFileFromContentRequest;
import org.apache.dolphinscheduler.api.validator.resource.AbstractResourceTransformer;
import org.apache.dolphinscheduler.common.utils.FileUtils;
import org.apache.dolphinscheduler.dao.repository.TenantDao;
import org.apache.dolphinscheduler.plugin.storage.api.StorageOperator;
import org.springframework.stereotype.Component;

@Component
public class FileFromContentRequestTransformer
extends AbstractResourceTransformer<CreateFileFromContentRequest, CreateFileFromContentDto> {
    public FileFromContentRequestTransformer(TenantDao tenantDao, StorageOperator storageOperator) {
        super(tenantDao, storageOperator);
    }

    @Override
    public CreateFileFromContentDto transform(CreateFileFromContentRequest createFileFromContentRequest) {
        this.validateCreateFileRequest(createFileFromContentRequest);
        return this.doTransform(createFileFromContentRequest);
    }

    private void validateCreateFileRequest(CreateFileFromContentRequest createFileFromContentRequest) {
        Preconditions.checkNotNull((Object)createFileFromContentRequest.getLoginUser(), (Object)"loginUser is null");
        Preconditions.checkNotNull((Object)createFileFromContentRequest.getType(), (Object)"resource type is null");
        Preconditions.checkNotNull((Object)createFileFromContentRequest.getFileName(), (Object)"file name is null");
        Preconditions.checkNotNull((Object)createFileFromContentRequest.getParentAbsoluteDirectory(), (Object)"parent directory is null");
        Preconditions.checkNotNull((Object)createFileFromContentRequest.getFileContent(), (Object)"file content is null");
    }

    private CreateFileFromContentDto doTransform(CreateFileFromContentRequest createFileFromContentRequest) {
        String fileAbsolutePath = this.getFileAbsolutePath(createFileFromContentRequest);
        return CreateFileFromContentDto.builder().loginUser(createFileFromContentRequest.getLoginUser()).fileAbsolutePath(fileAbsolutePath).fileContent(createFileFromContentRequest.getFileContent()).build();
    }

    private String getFileAbsolutePath(CreateFileFromContentRequest createFileFromContentRequest) {
        String parentDirectoryAbsolutePath = this.getParentDirectoryAbsolutePath(createFileFromContentRequest.getLoginUser(), createFileFromContentRequest.getParentAbsoluteDirectory(), createFileFromContentRequest.getType());
        return FileUtils.concatFilePath((String[])new String[]{parentDirectoryAbsolutePath, createFileFromContentRequest.getFileName()});
    }
}

