/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.validator.resource;

import org.apache.dolphinscheduler.api.dto.resources.RenameDirectoryDto;
import org.apache.dolphinscheduler.api.validator.resource.AbstractResourceValidator;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.repository.TenantDao;
import org.apache.dolphinscheduler.plugin.storage.api.StorageOperator;
import org.springframework.stereotype.Component;

@Component
public class RenameDirectoryDtoValidator
extends AbstractResourceValidator<RenameDirectoryDto> {
    public RenameDirectoryDtoValidator(StorageOperator storageOperator, TenantDao tenantDao) {
        super(storageOperator, tenantDao);
    }

    @Override
    public void validate(RenameDirectoryDto renameDirectoryDto) {
        String originDirectoryAbsolutePath = renameDirectoryDto.getOriginDirectoryAbsolutePath();
        User loginUser = renameDirectoryDto.getLoginUser();
        String targetDirectoryAbsolutePath = renameDirectoryDto.getTargetDirectoryAbsolutePath();
        this.exceptionResourceAbsolutePathInvalidated(originDirectoryAbsolutePath);
        this.exceptionResourceIsNotDirectory(originDirectoryAbsolutePath);
        this.exceptionResourceNotExists(originDirectoryAbsolutePath);
        this.exceptionUserNoResourcePermission(loginUser, originDirectoryAbsolutePath);
        this.exceptionResourceAbsolutePathInvalidated(targetDirectoryAbsolutePath);
        this.exceptionResourceIsNotDirectory(targetDirectoryAbsolutePath);
        this.exceptionResourceExists(targetDirectoryAbsolutePath);
        this.exceptionUserNoResourcePermission(loginUser, targetDirectoryAbsolutePath);
    }
}

