/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.model.select;

import com.obs.services.model.select.SelectEventVisitor;
import com.obs.services.model.select.SelectObjectException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.CRC32;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SelectInputStream
extends InputStream {
    private static final int DEFAULT_MESSAGE_BUFFER_SIZE = 0x200000;
    private static final int CHUNK_SIZE = 256;
    private static final String OCTET_STREAM_TYPE = "application/octet-stream";
    private static final String XML_STREAM_TYPE = "text/xml";
    private InputStream input;
    private byte[] inputChunk;
    private ByteBuffer messageBuffer;
    private SelectEventVisitor visitor;
    private ByteBuffer dataBuffer;
    private boolean done;
    private boolean isAborting;
    private int totalLength;
    private int headersLength;
    private int next;

    SelectInputStream(InputStream input, SelectEventVisitor visitor) {
        this.input = input;
        this.visitor = visitor;
        this.inputChunk = new byte[256];
        this.messageBuffer = ByteBuffer.allocate(0x200000);
        this.done = false;
        this.isAborting = false;
        this.totalLength = 0;
        this.next = 0;
    }

    SelectInputStream(InputStream input) {
        this(input, null);
    }

    public void abort() {
        this.isAborting = true;
    }

    @Override
    public int read() throws IOException {
        if (this.isAborting) {
            this.close();
            return -1;
        }
        if (this.available() == 0) {
            return -1;
        }
        int c = this.dataBuffer.getInt(this.next);
        this.consume(1);
        return c;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.isAborting) {
            this.close();
            return -1;
        }
        int n = this.available();
        if (n == 0) {
            return -1;
        }
        if (n < len) {
            this.fetch(len - n);
            n = this.available();
        }
        n = Math.min(n, len);
        int pos = this.dataBuffer.position();
        this.dataBuffer.position(this.next);
        this.dataBuffer.get(b, off, n);
        this.dataBuffer.position(pos);
        this.consume(n);
        return n;
    }

    @Override
    public long skip(long len) throws IOException {
        int n;
        if (this.isAborting) {
            this.close();
            return 0L;
        }
        long remaining = len;
        if (!this.done && this.dataBuffer != null && (n = this.dataBuffer.position() - this.next) > 0) {
            if ((long)n > remaining) {
                n = (int)remaining;
            }
            remaining -= (long)n;
            this.consume(n);
        }
        if (remaining > 0L) {
            remaining -= this.input.skip(remaining);
        }
        return len - remaining;
    }

    @Override
    public int available() throws IOException {
        if (this.isAborting) {
            this.close();
            return 0;
        }
        int n;
        while (this.dataBuffer == null || (n = this.dataBuffer.position() - this.next) <= 0) {
            if (this.done) {
                return 0;
            }
            this.fetch(1);
        }
        return n;
    }

    @Override
    public void close() throws IOException {
        this.dataBuffer = null;
        this.next = 0;
        this.done = true;
        this.isAborting = false;
        this.input.close();
    }

    @Override
    public synchronized void mark(int readLimit) {
    }

    @Override
    public synchronized void reset() throws IOException {
        throw new IOException("OBS Select input stream does not support mark and reset methods");
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    private void consume(int len) {
        this.next += len;
        if (this.next == this.dataBuffer.position()) {
            this.next = 0;
            this.dataBuffer.position(0);
        }
    }

    private void fetch(int len) throws IOException {
        if (this.done) {
            throw new ClosedChannelException();
        }
        block0: while (this.dataBuffer == null || this.dataBuffer.position() < len) {
            int loaded = this.input.read(this.inputChunk);
            if (loaded == -1) {
                if (this.messageBuffer.position() <= 0) break;
                throw new IOException("Service stream ended before a SELECT event could be entirely decoded.");
            }
            if (loaded <= 0) continue;
            int avail = this.messageBuffer.remaining();
            if (avail < loaded) {
                int newCapacity = this.totalLength + loaded;
                ByteBuffer current = this.messageBuffer.duplicate();
                current.flip();
                this.messageBuffer = ByteBuffer.allocate(newCapacity);
                this.messageBuffer.put(current);
            }
            this.messageBuffer.put(this.inputChunk, 0, loaded);
            while (this.messageBuffer.position() >= 16) {
                if (this.done) {
                    throw new IOException("There is still message data to process after End event");
                }
                if (this.totalLength == 0) {
                    this.extractPrelude();
                }
                if (this.totalLength > this.messageBuffer.position()) continue block0;
                long crc = this.toLong(this.messageBuffer.getInt(this.totalLength - 4));
                if (crc != this.crc32(this.totalLength - 4)) {
                    throw new IOException("Invalid CRC in OBS Select message");
                }
                Map<String, String> headers = this.extractHeaders();
                String messageType = headers.get(":message-type");
                if (messageType == null) {
                    throw new IOException("Missing message type in OBS Select message");
                }
                if (!messageType.equals("event")) {
                    if (messageType.equals("error")) {
                        throw new SelectObjectException(headers.get(":error-code"), headers.get(":error-message"));
                    }
                    throw new IOException("Unsupported message type '" + messageType + "'' in OBS Select message");
                }
                this.processEvent(headers);
                if (this.messageBuffer.position() == this.totalLength) {
                    this.messageBuffer.clear();
                } else {
                    byte[] remaining = new byte[this.messageBuffer.position() - this.totalLength];
                    this.messageBuffer.position(this.totalLength);
                    this.messageBuffer.get(remaining);
                    this.messageBuffer.position(0);
                    this.messageBuffer.put(remaining);
                }
                this.totalLength = 0;
            }
        }
    }

    private void processEvent(Map<String, String> headers) throws IOException {
        String eventType;
        String contentType = headers.get(":content-type");
        if (contentType == null) {
            contentType = OCTET_STREAM_TYPE;
        }
        if ((eventType = headers.get(":event-type")) == null) {
            throw new IOException("Missing event type in OBS Select message");
        }
        ByteBuffer tmp = this.messageBuffer.duplicate();
        tmp.position(this.headersLength + 12);
        tmp.limit(this.totalLength - 4);
        ByteBuffer payload = tmp.slice();
        if (eventType.equals("Records")) {
            if (!contentType.equals(OCTET_STREAM_TYPE)) {
                throw new IOException("Stream type '" + contentType + "' for Records event in OBS Select is not supported");
            }
            if (payload.limit() > 0) {
                if (this.visitor != null) {
                    this.visitor.visitRecordsEvent(payload);
                }
                if (this.dataBuffer == null) {
                    this.dataBuffer = ByteBuffer.allocate(payload.limit());
                } else if (this.dataBuffer.remaining() < payload.limit()) {
                    ByteBuffer currentBuffer = this.dataBuffer.duplicate();
                    currentBuffer.flip();
                    this.dataBuffer = ByteBuffer.allocate(currentBuffer.limit() + payload.limit());
                    this.dataBuffer.put(currentBuffer);
                }
                this.dataBuffer.put(payload);
            }
            return;
        }
        if (eventType.equals("Cont")) {
            if (this.visitor != null) {
                this.visitor.visitContinuationEvent();
            }
            return;
        }
        if (eventType.equals("Stats") || eventType.equals("Progress")) {
            if (!contentType.equals(XML_STREAM_TYPE)) {
                throw new IOException("Stream type '" + contentType + "' for " + eventType + " event in OBS Select is not supported");
            }
            if (this.visitor != null) {
                Stats stats = this.extractStats(payload, eventType);
                if (eventType.equals("Stats")) {
                    this.visitor.visitStatsEvent(stats.bytesScanned, stats.bytesProcessed, stats.bytesReturned);
                } else {
                    this.visitor.visitProgressEvent(stats.bytesScanned, stats.bytesProcessed, stats.bytesReturned);
                }
            }
            return;
        }
        if (eventType.equals("End")) {
            if (this.visitor != null) {
                this.visitor.visitEndEvent();
            }
            this.done = true;
            return;
        }
        throw new IOException("Unsupported event type '" + eventType + "'' in OBS Select message");
    }

    private Stats extractStats(ByteBuffer payload, String event) throws IOException {
        if (payload.limit() == 0) {
            throw new IOException("XML document for " + event + " event in OBS Select is empty");
        }
        byte[] s = new byte[payload.limit()];
        payload.get(s);
        Stats stats = new Stats();
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            dbf.setFeature("http://xml.org/sax/features/external-general-entities", false);
            dbf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            Document doc = dbf.newDocumentBuilder().parse(new InputSource(new StringReader(new String(s, StandardCharsets.UTF_8))));
            Node node = doc.getDocumentElement();
            if (!event.equals(node.getNodeName())) {
                throw new IOException("Wrong root XML element in " + event + " document in OBS Select");
            }
            for (node = node.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (node.getNodeType() != 1) continue;
                String name = node.getNodeName();
                Node value = node.getFirstChild();
                if (value == null || value.getNodeType() != 3) {
                    throw new IOException("Invalid value for XML element " + name + " in " + event + " document in OBS Select");
                }
                long stat = Long.parseLong(value.getTextContent());
                if (name.equals("BytesScanned")) {
                    stats.bytesScanned = stat;
                    continue;
                }
                if (name.equals("BytesProcessed")) {
                    stats.bytesProcessed = stat;
                    continue;
                }
                if (name.equals("BytesReturned")) {
                    stats.bytesReturned = stat;
                    continue;
                }
                throw new IOException("Unknown element " + name + " in " + event + " document in OBS Select");
            }
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new IOException("Wrong XML " + event + " document in OBS Select");
        }
        if (stats.bytesScanned == -1L || stats.bytesProcessed == -1L || stats.bytesReturned == -1L) {
            throw new IOException("Missing elements in " + event + " document in OBS Select");
        }
        return stats;
    }

    private void extractPrelude() throws IOException {
        ByteBuffer buf = this.messageBuffer.duplicate();
        buf.flip();
        this.totalLength = buf.getInt();
        this.headersLength = buf.getInt();
        long crc = this.toLong(buf.getInt());
        if (crc != this.crc32(8)) {
            throw new IOException("Invalid CRC in OBS Select message header");
        }
    }

    Map<String, String> extractHeaders() throws IOException {
        HashMap<String, String> headers = new HashMap<String, String>();
        ByteBuffer buf = this.messageBuffer.duplicate();
        buf.position(12);
        buf.limit(this.headersLength + 12);
        while (buf.position() < buf.limit()) {
            byte[] str = new byte[buf.get()];
            buf.get(str);
            String headerName = new String(str, StandardCharsets.UTF_8);
            if (buf.get() != 7) {
                throw new IOException("Wrong header in OBS Select message");
            }
            str = new byte[buf.get() * 256 + buf.get()];
            buf.get(str);
            String headerValue = new String(str, StandardCharsets.UTF_8);
            headers.put(headerName, headerValue);
        }
        if (buf.position() != buf.limit()) {
            throw new IOException("Wrong headers size in OBS Select message");
        }
        return headers;
    }

    private long toLong(int i) {
        return (long)i & 0xFFFFFFFFL;
    }

    private long crc32(int length) {
        byte[] chunk = new byte[length];
        ByteBuffer buf = this.messageBuffer.duplicate();
        buf.flip();
        buf.get(chunk);
        CRC32 crc = new CRC32();
        crc.update(chunk, 0, length);
        return crc.getValue();
    }

    private class Stats {
        long bytesScanned = -1L;
        long bytesProcessed = -1L;
        long bytesReturned = -1L;

        private Stats() {
        }
    }
}

