/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.registry;

import lombok.Generated;
import lombok.NonNull;
import org.apache.dolphinscheduler.common.enums.ServerStatus;
import org.apache.dolphinscheduler.common.lifecycle.ServerLifeCycleManager;
import org.apache.dolphinscheduler.common.model.BaseHeartBeat;
import org.apache.dolphinscheduler.common.model.BaseHeartBeatTask;
import org.apache.dolphinscheduler.common.model.MasterHeartBeat;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.common.utils.NetUtils;
import org.apache.dolphinscheduler.common.utils.OSUtils;
import org.apache.dolphinscheduler.meter.metrics.MetricsProvider;
import org.apache.dolphinscheduler.meter.metrics.SystemMetrics;
import org.apache.dolphinscheduler.registry.api.RegistryClient;
import org.apache.dolphinscheduler.registry.api.utils.RegistryUtils;
import org.apache.dolphinscheduler.server.master.config.MasterConfig;
import org.apache.dolphinscheduler.server.master.config.MasterServerLoadProtection;
import org.apache.dolphinscheduler.server.master.engine.MasterCoordinator;
import org.apache.dolphinscheduler.server.master.metrics.MasterServerMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MasterHeartBeatTask
extends BaseHeartBeatTask<MasterHeartBeat> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MasterHeartBeatTask.class);
    private final MasterConfig masterConfig;
    private MasterServerLoadProtection masterServerLoadProtection;
    private final MetricsProvider metricsProvider;
    private final RegistryClient registryClient;
    private final MasterCoordinator masterCoordinator;
    private final String heartBeatPath;
    private final int processId;

    public MasterHeartBeatTask(@NonNull MasterConfig masterConfig, @NonNull MasterServerLoadProtection masterServerLoadProtection, @NonNull MetricsProvider metricsProvider, @NonNull RegistryClient registryClient, @NonNull MasterCoordinator masterCoordinator) {
        super("MasterHeartBeatTask", masterConfig.getMaxHeartbeatInterval().toMillis());
        if (masterConfig == null) {
            throw new NullPointerException("masterConfig is marked non-null but is null");
        }
        if (masterServerLoadProtection == null) {
            throw new NullPointerException("masterServerLoadProtection is marked non-null but is null");
        }
        if (metricsProvider == null) {
            throw new NullPointerException("metricsProvider is marked non-null but is null");
        }
        if (registryClient == null) {
            throw new NullPointerException("registryClient is marked non-null but is null");
        }
        if (masterCoordinator == null) {
            throw new NullPointerException("masterCoordinator is marked non-null but is null");
        }
        this.masterConfig = masterConfig;
        this.masterServerLoadProtection = masterServerLoadProtection;
        this.metricsProvider = metricsProvider;
        this.registryClient = registryClient;
        this.masterCoordinator = masterCoordinator;
        this.heartBeatPath = masterConfig.getMasterRegistryPath();
        this.processId = OSUtils.getProcessID();
    }

    public MasterHeartBeat getHeartBeat() {
        SystemMetrics systemMetrics = this.metricsProvider.getSystemMetrics();
        return ((MasterHeartBeat.MasterHeartBeatBuilder)((MasterHeartBeat.MasterHeartBeatBuilder)((MasterHeartBeat.MasterHeartBeatBuilder)((MasterHeartBeat.MasterHeartBeatBuilder)((MasterHeartBeat.MasterHeartBeatBuilder)((MasterHeartBeat.MasterHeartBeatBuilder)((MasterHeartBeat.MasterHeartBeatBuilder)((MasterHeartBeat.MasterHeartBeatBuilder)((MasterHeartBeat.MasterHeartBeatBuilder)((MasterHeartBeat.MasterHeartBeatBuilder)((MasterHeartBeat.MasterHeartBeatBuilder)((MasterHeartBeat.MasterHeartBeatBuilder)((MasterHeartBeat.MasterHeartBeatBuilder)((MasterHeartBeat.MasterHeartBeatBuilder)((MasterHeartBeat.MasterHeartBeatBuilder)MasterHeartBeat.builder().startupTime(ServerLifeCycleManager.getServerStartupTime())).reportTime(System.currentTimeMillis())).jvmCpuUsage(systemMetrics.getJvmCpuUsagePercentage())).cpuUsage(systemMetrics.getSystemCpuUsagePercentage())).jvmMemoryUsage(systemMetrics.getJvmMemoryUsedPercentage())).jvmHeapUsed(systemMetrics.getJvmHeapUsed())).jvmHeapMax(systemMetrics.getJvmHeapMax())).jvmNonHeapUsed(systemMetrics.getJvmNonHeapUsed())).jvmNonHeapMax(systemMetrics.getJvmNonHeapMax())).memoryUsage(systemMetrics.getSystemMemoryUsedPercentage())).diskUsage(systemMetrics.getDiskUsedPercentage())).processId(this.processId)).serverStatus(this.masterServerLoadProtection.isOverload(systemMetrics) ? ServerStatus.BUSY : ServerStatus.NORMAL)).host(NetUtils.getHost())).port(this.masterConfig.getListenPort())).isCoordinator(this.masterCoordinator.isActive()).build();
    }

    public void writeHeartBeat(MasterHeartBeat masterHeartBeat) {
        String failoverNodePath = RegistryUtils.getFailoveredNodePath((BaseHeartBeat)masterHeartBeat);
        if (this.registryClient.exists(failoverNodePath)) {
            log.warn("The master: {} is under {}, means it has been failover will close myself", (Object)masterHeartBeat, (Object)failoverNodePath);
            this.registryClient.getStoppable().stop("The master exist: " + failoverNodePath + ", means it has been failover will close myself");
            return;
        }
        String masterHeartBeatJson = JSONUtils.toJsonString((Object)masterHeartBeat);
        this.registryClient.persistEphemeral(this.heartBeatPath, masterHeartBeatJson);
        MasterServerMetrics.incMasterHeartbeatCount();
        log.debug("Success write master heartBeatInfo into registry, masterRegistryPath: {}, heartBeatInfo: {}", (Object)this.heartBeatPath, (Object)masterHeartBeatJson);
    }
}

