/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.engine.task.runnable;

import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.dao.repository.TaskInstanceDao;
import org.apache.dolphinscheduler.plugin.task.api.enums.TaskExecutionStatus;
import org.apache.dolphinscheduler.server.master.engine.task.runnable.AbstractTaskInstanceFactory;
import org.apache.dolphinscheduler.server.master.engine.task.runnable.ITaskInstanceFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class PauseRecoverTaskInstanceFactory
extends AbstractTaskInstanceFactory<PauseRecoverTaskInstanceBuilder> {
    @Autowired
    private TaskInstanceDao taskInstanceDao;

    @Override
    public PauseRecoverTaskInstanceBuilder builder() {
        return new PauseRecoverTaskInstanceBuilder(this);
    }

    @Override
    @Transactional
    public TaskInstance createTaskInstance(PauseRecoverTaskInstanceBuilder builder) {
        TaskInstance needRecoverTaskInstance = builder.needRecoverTaskInstance;
        needRecoverTaskInstance.setState(TaskExecutionStatus.SUBMITTED_SUCCESS);
        this.taskInstanceDao.updateById((Object)needRecoverTaskInstance);
        return needRecoverTaskInstance;
    }

    public static class PauseRecoverTaskInstanceBuilder
    implements ITaskInstanceFactory.ITaskInstanceBuilder {
        private final PauseRecoverTaskInstanceFactory pauseRecoverTaskInstanceFactory;
        private TaskInstance needRecoverTaskInstance;

        public PauseRecoverTaskInstanceBuilder(PauseRecoverTaskInstanceFactory pauseRecoverTaskInstanceFactory) {
            this.pauseRecoverTaskInstanceFactory = pauseRecoverTaskInstanceFactory;
        }

        public PauseRecoverTaskInstanceBuilder withTaskInstance(TaskInstance needRecoverTaskInstance) {
            this.needRecoverTaskInstance = needRecoverTaskInstance;
            return this;
        }

        @Override
        public TaskInstance build() {
            return this.pauseRecoverTaskInstanceFactory.createTaskInstance(this);
        }
    }
}

