/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datasync.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datasync.model.AgentArnListCopier;
import software.amazon.awssdk.services.datasync.model.DataSyncRequest;
import software.amazon.awssdk.services.datasync.model.HdfsAuthenticationType;
import software.amazon.awssdk.services.datasync.model.HdfsNameNode;
import software.amazon.awssdk.services.datasync.model.HdfsNameNodeListCopier;
import software.amazon.awssdk.services.datasync.model.InputTagListCopier;
import software.amazon.awssdk.services.datasync.model.QopConfiguration;
import software.amazon.awssdk.services.datasync.model.TagListEntry;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateLocationHdfsRequest
extends DataSyncRequest
implements ToCopyableBuilder<Builder, CreateLocationHdfsRequest> {
    private static final SdkField<String> SUBDIRECTORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Subdirectory").getter(CreateLocationHdfsRequest.getter(CreateLocationHdfsRequest::subdirectory)).setter(CreateLocationHdfsRequest.setter(Builder::subdirectory)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subdirectory").build()}).build();
    private static final SdkField<List<HdfsNameNode>> NAME_NODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NameNodes").getter(CreateLocationHdfsRequest.getter(CreateLocationHdfsRequest::nameNodes)).setter(CreateLocationHdfsRequest.setter(Builder::nameNodes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NameNodes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(HdfsNameNode::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> BLOCK_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("BlockSize").getter(CreateLocationHdfsRequest.getter(CreateLocationHdfsRequest::blockSize)).setter(CreateLocationHdfsRequest.setter(Builder::blockSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlockSize").build()}).build();
    private static final SdkField<Integer> REPLICATION_FACTOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ReplicationFactor").getter(CreateLocationHdfsRequest.getter(CreateLocationHdfsRequest::replicationFactor)).setter(CreateLocationHdfsRequest.setter(Builder::replicationFactor)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationFactor").build()}).build();
    private static final SdkField<String> KMS_KEY_PROVIDER_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyProviderUri").getter(CreateLocationHdfsRequest.getter(CreateLocationHdfsRequest::kmsKeyProviderUri)).setter(CreateLocationHdfsRequest.setter(Builder::kmsKeyProviderUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyProviderUri").build()}).build();
    private static final SdkField<QopConfiguration> QOP_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("QopConfiguration").getter(CreateLocationHdfsRequest.getter(CreateLocationHdfsRequest::qopConfiguration)).setter(CreateLocationHdfsRequest.setter(Builder::qopConfiguration)).constructor(QopConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QopConfiguration").build()}).build();
    private static final SdkField<String> AUTHENTICATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AuthenticationType").getter(CreateLocationHdfsRequest.getter(CreateLocationHdfsRequest::authenticationTypeAsString)).setter(CreateLocationHdfsRequest.setter(Builder::authenticationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthenticationType").build()}).build();
    private static final SdkField<String> SIMPLE_USER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SimpleUser").getter(CreateLocationHdfsRequest.getter(CreateLocationHdfsRequest::simpleUser)).setter(CreateLocationHdfsRequest.setter(Builder::simpleUser)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SimpleUser").build()}).build();
    private static final SdkField<String> KERBEROS_PRINCIPAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KerberosPrincipal").getter(CreateLocationHdfsRequest.getter(CreateLocationHdfsRequest::kerberosPrincipal)).setter(CreateLocationHdfsRequest.setter(Builder::kerberosPrincipal)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KerberosPrincipal").build()}).build();
    private static final SdkField<SdkBytes> KERBEROS_KEYTAB_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("KerberosKeytab").getter(CreateLocationHdfsRequest.getter(CreateLocationHdfsRequest::kerberosKeytab)).setter(CreateLocationHdfsRequest.setter(Builder::kerberosKeytab)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KerberosKeytab").build()}).build();
    private static final SdkField<SdkBytes> KERBEROS_KRB5_CONF_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("KerberosKrb5Conf").getter(CreateLocationHdfsRequest.getter(CreateLocationHdfsRequest::kerberosKrb5Conf)).setter(CreateLocationHdfsRequest.setter(Builder::kerberosKrb5Conf)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KerberosKrb5Conf").build()}).build();
    private static final SdkField<List<String>> AGENT_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AgentArns").getter(CreateLocationHdfsRequest.getter(CreateLocationHdfsRequest::agentArns)).setter(CreateLocationHdfsRequest.setter(Builder::agentArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AgentArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<TagListEntry>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateLocationHdfsRequest.getter(CreateLocationHdfsRequest::tags)).setter(CreateLocationHdfsRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TagListEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBDIRECTORY_FIELD, NAME_NODES_FIELD, BLOCK_SIZE_FIELD, REPLICATION_FACTOR_FIELD, KMS_KEY_PROVIDER_URI_FIELD, QOP_CONFIGURATION_FIELD, AUTHENTICATION_TYPE_FIELD, SIMPLE_USER_FIELD, KERBEROS_PRINCIPAL_FIELD, KERBEROS_KEYTAB_FIELD, KERBEROS_KRB5_CONF_FIELD, AGENT_ARNS_FIELD, TAGS_FIELD));
    private final String subdirectory;
    private final List<HdfsNameNode> nameNodes;
    private final Integer blockSize;
    private final Integer replicationFactor;
    private final String kmsKeyProviderUri;
    private final QopConfiguration qopConfiguration;
    private final String authenticationType;
    private final String simpleUser;
    private final String kerberosPrincipal;
    private final SdkBytes kerberosKeytab;
    private final SdkBytes kerberosKrb5Conf;
    private final List<String> agentArns;
    private final List<TagListEntry> tags;

    private CreateLocationHdfsRequest(BuilderImpl builder) {
        super(builder);
        this.subdirectory = builder.subdirectory;
        this.nameNodes = builder.nameNodes;
        this.blockSize = builder.blockSize;
        this.replicationFactor = builder.replicationFactor;
        this.kmsKeyProviderUri = builder.kmsKeyProviderUri;
        this.qopConfiguration = builder.qopConfiguration;
        this.authenticationType = builder.authenticationType;
        this.simpleUser = builder.simpleUser;
        this.kerberosPrincipal = builder.kerberosPrincipal;
        this.kerberosKeytab = builder.kerberosKeytab;
        this.kerberosKrb5Conf = builder.kerberosKrb5Conf;
        this.agentArns = builder.agentArns;
        this.tags = builder.tags;
    }

    public final String subdirectory() {
        return this.subdirectory;
    }

    public final boolean hasNameNodes() {
        return this.nameNodes != null && !(this.nameNodes instanceof SdkAutoConstructList);
    }

    public final List<HdfsNameNode> nameNodes() {
        return this.nameNodes;
    }

    public final Integer blockSize() {
        return this.blockSize;
    }

    public final Integer replicationFactor() {
        return this.replicationFactor;
    }

    public final String kmsKeyProviderUri() {
        return this.kmsKeyProviderUri;
    }

    public final QopConfiguration qopConfiguration() {
        return this.qopConfiguration;
    }

    public final HdfsAuthenticationType authenticationType() {
        return HdfsAuthenticationType.fromValue(this.authenticationType);
    }

    public final String authenticationTypeAsString() {
        return this.authenticationType;
    }

    public final String simpleUser() {
        return this.simpleUser;
    }

    public final String kerberosPrincipal() {
        return this.kerberosPrincipal;
    }

    public final SdkBytes kerberosKeytab() {
        return this.kerberosKeytab;
    }

    public final SdkBytes kerberosKrb5Conf() {
        return this.kerberosKrb5Conf;
    }

    public final boolean hasAgentArns() {
        return this.agentArns != null && !(this.agentArns instanceof SdkAutoConstructList);
    }

    public final List<String> agentArns() {
        return this.agentArns;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<TagListEntry> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.subdirectory());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNameNodes() ? this.nameNodes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.blockSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationFactor());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyProviderUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.qopConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.simpleUser());
        hashCode = 31 * hashCode + Objects.hashCode(this.kerberosPrincipal());
        hashCode = 31 * hashCode + Objects.hashCode(this.kerberosKeytab());
        hashCode = 31 * hashCode + Objects.hashCode(this.kerberosKrb5Conf());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAgentArns() ? this.agentArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLocationHdfsRequest)) {
            return false;
        }
        CreateLocationHdfsRequest other = (CreateLocationHdfsRequest)((Object)obj);
        return Objects.equals(this.subdirectory(), other.subdirectory()) && this.hasNameNodes() == other.hasNameNodes() && Objects.equals(this.nameNodes(), other.nameNodes()) && Objects.equals(this.blockSize(), other.blockSize()) && Objects.equals(this.replicationFactor(), other.replicationFactor()) && Objects.equals(this.kmsKeyProviderUri(), other.kmsKeyProviderUri()) && Objects.equals(this.qopConfiguration(), other.qopConfiguration()) && Objects.equals(this.authenticationTypeAsString(), other.authenticationTypeAsString()) && Objects.equals(this.simpleUser(), other.simpleUser()) && Objects.equals(this.kerberosPrincipal(), other.kerberosPrincipal()) && Objects.equals(this.kerberosKeytab(), other.kerberosKeytab()) && Objects.equals(this.kerberosKrb5Conf(), other.kerberosKrb5Conf()) && this.hasAgentArns() == other.hasAgentArns() && Objects.equals(this.agentArns(), other.agentArns()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateLocationHdfsRequest").add("Subdirectory", (Object)this.subdirectory()).add("NameNodes", this.hasNameNodes() ? this.nameNodes() : null).add("BlockSize", (Object)this.blockSize()).add("ReplicationFactor", (Object)this.replicationFactor()).add("KmsKeyProviderUri", (Object)this.kmsKeyProviderUri()).add("QopConfiguration", (Object)this.qopConfiguration()).add("AuthenticationType", (Object)this.authenticationTypeAsString()).add("SimpleUser", (Object)this.simpleUser()).add("KerberosPrincipal", (Object)this.kerberosPrincipal()).add("KerberosKeytab", (Object)this.kerberosKeytab()).add("KerberosKrb5Conf", (Object)this.kerberosKrb5Conf()).add("AgentArns", this.hasAgentArns() ? this.agentArns() : null).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Subdirectory": {
                return Optional.ofNullable(clazz.cast(this.subdirectory()));
            }
            case "NameNodes": {
                return Optional.ofNullable(clazz.cast(this.nameNodes()));
            }
            case "BlockSize": {
                return Optional.ofNullable(clazz.cast(this.blockSize()));
            }
            case "ReplicationFactor": {
                return Optional.ofNullable(clazz.cast(this.replicationFactor()));
            }
            case "KmsKeyProviderUri": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyProviderUri()));
            }
            case "QopConfiguration": {
                return Optional.ofNullable(clazz.cast(this.qopConfiguration()));
            }
            case "AuthenticationType": {
                return Optional.ofNullable(clazz.cast(this.authenticationTypeAsString()));
            }
            case "SimpleUser": {
                return Optional.ofNullable(clazz.cast(this.simpleUser()));
            }
            case "KerberosPrincipal": {
                return Optional.ofNullable(clazz.cast(this.kerberosPrincipal()));
            }
            case "KerberosKeytab": {
                return Optional.ofNullable(clazz.cast(this.kerberosKeytab()));
            }
            case "KerberosKrb5Conf": {
                return Optional.ofNullable(clazz.cast(this.kerberosKrb5Conf()));
            }
            case "AgentArns": {
                return Optional.ofNullable(clazz.cast(this.agentArns()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateLocationHdfsRequest, T> g) {
        return obj -> g.apply((CreateLocationHdfsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataSyncRequest.BuilderImpl
    implements Builder {
        private String subdirectory;
        private List<HdfsNameNode> nameNodes = DefaultSdkAutoConstructList.getInstance();
        private Integer blockSize;
        private Integer replicationFactor;
        private String kmsKeyProviderUri;
        private QopConfiguration qopConfiguration;
        private String authenticationType;
        private String simpleUser;
        private String kerberosPrincipal;
        private SdkBytes kerberosKeytab;
        private SdkBytes kerberosKrb5Conf;
        private List<String> agentArns = DefaultSdkAutoConstructList.getInstance();
        private List<TagListEntry> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLocationHdfsRequest model) {
            super(model);
            this.subdirectory(model.subdirectory);
            this.nameNodes(model.nameNodes);
            this.blockSize(model.blockSize);
            this.replicationFactor(model.replicationFactor);
            this.kmsKeyProviderUri(model.kmsKeyProviderUri);
            this.qopConfiguration(model.qopConfiguration);
            this.authenticationType(model.authenticationType);
            this.simpleUser(model.simpleUser);
            this.kerberosPrincipal(model.kerberosPrincipal);
            this.kerberosKeytab(model.kerberosKeytab);
            this.kerberosKrb5Conf(model.kerberosKrb5Conf);
            this.agentArns(model.agentArns);
            this.tags(model.tags);
        }

        public final String getSubdirectory() {
            return this.subdirectory;
        }

        public final void setSubdirectory(String subdirectory) {
            this.subdirectory = subdirectory;
        }

        @Override
        public final Builder subdirectory(String subdirectory) {
            this.subdirectory = subdirectory;
            return this;
        }

        public final List<HdfsNameNode.Builder> getNameNodes() {
            List<HdfsNameNode.Builder> result = HdfsNameNodeListCopier.copyToBuilder(this.nameNodes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNameNodes(Collection<HdfsNameNode.BuilderImpl> nameNodes) {
            this.nameNodes = HdfsNameNodeListCopier.copyFromBuilder(nameNodes);
        }

        @Override
        public final Builder nameNodes(Collection<HdfsNameNode> nameNodes) {
            this.nameNodes = HdfsNameNodeListCopier.copy(nameNodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nameNodes(HdfsNameNode ... nameNodes) {
            this.nameNodes(Arrays.asList(nameNodes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nameNodes(Consumer<HdfsNameNode.Builder> ... nameNodes) {
            this.nameNodes(Stream.of(nameNodes).map(c -> (HdfsNameNode)((HdfsNameNode.Builder)HdfsNameNode.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getBlockSize() {
            return this.blockSize;
        }

        public final void setBlockSize(Integer blockSize) {
            this.blockSize = blockSize;
        }

        @Override
        public final Builder blockSize(Integer blockSize) {
            this.blockSize = blockSize;
            return this;
        }

        public final Integer getReplicationFactor() {
            return this.replicationFactor;
        }

        public final void setReplicationFactor(Integer replicationFactor) {
            this.replicationFactor = replicationFactor;
        }

        @Override
        public final Builder replicationFactor(Integer replicationFactor) {
            this.replicationFactor = replicationFactor;
            return this;
        }

        public final String getKmsKeyProviderUri() {
            return this.kmsKeyProviderUri;
        }

        public final void setKmsKeyProviderUri(String kmsKeyProviderUri) {
            this.kmsKeyProviderUri = kmsKeyProviderUri;
        }

        @Override
        public final Builder kmsKeyProviderUri(String kmsKeyProviderUri) {
            this.kmsKeyProviderUri = kmsKeyProviderUri;
            return this;
        }

        public final QopConfiguration.Builder getQopConfiguration() {
            return this.qopConfiguration != null ? this.qopConfiguration.toBuilder() : null;
        }

        public final void setQopConfiguration(QopConfiguration.BuilderImpl qopConfiguration) {
            this.qopConfiguration = qopConfiguration != null ? qopConfiguration.build() : null;
        }

        @Override
        public final Builder qopConfiguration(QopConfiguration qopConfiguration) {
            this.qopConfiguration = qopConfiguration;
            return this;
        }

        public final String getAuthenticationType() {
            return this.authenticationType;
        }

        public final void setAuthenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
        }

        @Override
        public final Builder authenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
            return this;
        }

        @Override
        public final Builder authenticationType(HdfsAuthenticationType authenticationType) {
            this.authenticationType(authenticationType == null ? null : authenticationType.toString());
            return this;
        }

        public final String getSimpleUser() {
            return this.simpleUser;
        }

        public final void setSimpleUser(String simpleUser) {
            this.simpleUser = simpleUser;
        }

        @Override
        public final Builder simpleUser(String simpleUser) {
            this.simpleUser = simpleUser;
            return this;
        }

        public final String getKerberosPrincipal() {
            return this.kerberosPrincipal;
        }

        public final void setKerberosPrincipal(String kerberosPrincipal) {
            this.kerberosPrincipal = kerberosPrincipal;
        }

        @Override
        public final Builder kerberosPrincipal(String kerberosPrincipal) {
            this.kerberosPrincipal = kerberosPrincipal;
            return this;
        }

        public final ByteBuffer getKerberosKeytab() {
            return this.kerberosKeytab == null ? null : this.kerberosKeytab.asByteBuffer();
        }

        public final void setKerberosKeytab(ByteBuffer kerberosKeytab) {
            this.kerberosKeytab(kerberosKeytab == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)kerberosKeytab));
        }

        @Override
        public final Builder kerberosKeytab(SdkBytes kerberosKeytab) {
            this.kerberosKeytab = kerberosKeytab;
            return this;
        }

        public final ByteBuffer getKerberosKrb5Conf() {
            return this.kerberosKrb5Conf == null ? null : this.kerberosKrb5Conf.asByteBuffer();
        }

        public final void setKerberosKrb5Conf(ByteBuffer kerberosKrb5Conf) {
            this.kerberosKrb5Conf(kerberosKrb5Conf == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)kerberosKrb5Conf));
        }

        @Override
        public final Builder kerberosKrb5Conf(SdkBytes kerberosKrb5Conf) {
            this.kerberosKrb5Conf = kerberosKrb5Conf;
            return this;
        }

        public final Collection<String> getAgentArns() {
            if (this.agentArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.agentArns;
        }

        public final void setAgentArns(Collection<String> agentArns) {
            this.agentArns = AgentArnListCopier.copy(agentArns);
        }

        @Override
        public final Builder agentArns(Collection<String> agentArns) {
            this.agentArns = AgentArnListCopier.copy(agentArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder agentArns(String ... agentArns) {
            this.agentArns(Arrays.asList(agentArns));
            return this;
        }

        public final List<TagListEntry.Builder> getTags() {
            List<TagListEntry.Builder> result = InputTagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<TagListEntry.BuilderImpl> tags) {
            this.tags = InputTagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<TagListEntry> tags) {
            this.tags = InputTagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(TagListEntry ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<TagListEntry.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (TagListEntry)((TagListEntry.Builder)TagListEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateLocationHdfsRequest build() {
            return new CreateLocationHdfsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DataSyncRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateLocationHdfsRequest> {
        public Builder subdirectory(String var1);

        public Builder nameNodes(Collection<HdfsNameNode> var1);

        public Builder nameNodes(HdfsNameNode ... var1);

        public Builder nameNodes(Consumer<HdfsNameNode.Builder> ... var1);

        public Builder blockSize(Integer var1);

        public Builder replicationFactor(Integer var1);

        public Builder kmsKeyProviderUri(String var1);

        public Builder qopConfiguration(QopConfiguration var1);

        default public Builder qopConfiguration(Consumer<QopConfiguration.Builder> qopConfiguration) {
            return this.qopConfiguration((QopConfiguration)((QopConfiguration.Builder)QopConfiguration.builder().applyMutation(qopConfiguration)).build());
        }

        public Builder authenticationType(String var1);

        public Builder authenticationType(HdfsAuthenticationType var1);

        public Builder simpleUser(String var1);

        public Builder kerberosPrincipal(String var1);

        public Builder kerberosKeytab(SdkBytes var1);

        public Builder kerberosKrb5Conf(SdkBytes var1);

        public Builder agentArns(Collection<String> var1);

        public Builder agentArns(String ... var1);

        public Builder tags(Collection<TagListEntry> var1);

        public Builder tags(TagListEntry ... var1);

        public Builder tags(Consumer<TagListEntry.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

