/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.registry.jdbc;

import com.zaxxer.hikari.HikariConfig;
import java.time.Duration;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.utils.NetUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;
import org.springframework.validation.annotation.Validated;

@Validated
@Configuration
@ConditionalOnProperty(prefix="registry", name={"type"}, havingValue="jdbc")
@ConfigurationProperties(prefix="registry")
public class JdbcRegistryProperties
implements Validator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JdbcRegistryProperties.class);
    private static final Duration MIN_HEARTBEAT_REFRESH_INTERVAL = Duration.ofSeconds(1L);
    @Value(value="${server.port:8080}")
    private int serverPort;
    private String jdbcRegistryClientName;
    private Duration heartbeatRefreshInterval = Duration.ofSeconds(3L);
    private Duration sessionTimeout = Duration.ofSeconds(60L);
    private HikariConfig hikariConfig;

    public boolean supports(Class<?> clazz) {
        return JdbcRegistryProperties.class.isAssignableFrom(clazz);
    }

    public void validate(Object target, Errors errors) {
        JdbcRegistryProperties jdbcRegistryProperties = (JdbcRegistryProperties)target;
        if (jdbcRegistryProperties.getHeartbeatRefreshInterval().compareTo(MIN_HEARTBEAT_REFRESH_INTERVAL) < 0) {
            errors.rejectValue("heartbeatRefreshInterval", "heartbeatRefreshInterval", "registry.heartbeatRefreshInterval must be greater than 1s");
        }
        if (jdbcRegistryProperties.getSessionTimeout().toMillis() < 3L * jdbcRegistryProperties.getHeartbeatRefreshInterval().toMillis()) {
            errors.rejectValue("sessionTimeout", "sessionTimeout", "registry.sessionTimeout must be greater than 3 * heartbeatRefreshInterval");
        }
        if (StringUtils.isEmpty((CharSequence)this.jdbcRegistryClientName)) {
            this.jdbcRegistryClientName = NetUtils.getHost() + ":" + this.serverPort;
        }
        this.print();
    }

    private void print() {
        String config = "\n****************************JdbcRegistryProperties**************************************\n  jdbcRegistryClientName -> " + this.jdbcRegistryClientName + "\n  heartbeatRefreshInterval -> " + this.heartbeatRefreshInterval + "\n  sessionTimeout -> " + this.sessionTimeout + "\n****************************JdbcRegistryProperties**************************************";
        log.info(config);
    }

    @Generated
    public JdbcRegistryProperties() {
    }

    @Generated
    public int getServerPort() {
        return this.serverPort;
    }

    @Generated
    public String getJdbcRegistryClientName() {
        return this.jdbcRegistryClientName;
    }

    @Generated
    public Duration getHeartbeatRefreshInterval() {
        return this.heartbeatRefreshInterval;
    }

    @Generated
    public Duration getSessionTimeout() {
        return this.sessionTimeout;
    }

    @Generated
    public HikariConfig getHikariConfig() {
        return this.hikariConfig;
    }

    @Generated
    public void setServerPort(int serverPort) {
        this.serverPort = serverPort;
    }

    @Generated
    public void setJdbcRegistryClientName(String jdbcRegistryClientName) {
        this.jdbcRegistryClientName = jdbcRegistryClientName;
    }

    @Generated
    public void setHeartbeatRefreshInterval(Duration heartbeatRefreshInterval) {
        this.heartbeatRefreshInterval = heartbeatRefreshInterval;
    }

    @Generated
    public void setSessionTimeout(Duration sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
    }

    @Generated
    public void setHikariConfig(HikariConfig hikariConfig) {
        this.hikariConfig = hikariConfig;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JdbcRegistryProperties)) {
            return false;
        }
        JdbcRegistryProperties other = (JdbcRegistryProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getServerPort() != other.getServerPort()) {
            return false;
        }
        String this$jdbcRegistryClientName = this.getJdbcRegistryClientName();
        String other$jdbcRegistryClientName = other.getJdbcRegistryClientName();
        if (this$jdbcRegistryClientName == null ? other$jdbcRegistryClientName != null : !this$jdbcRegistryClientName.equals(other$jdbcRegistryClientName)) {
            return false;
        }
        Duration this$heartbeatRefreshInterval = this.getHeartbeatRefreshInterval();
        Duration other$heartbeatRefreshInterval = other.getHeartbeatRefreshInterval();
        if (this$heartbeatRefreshInterval == null ? other$heartbeatRefreshInterval != null : !((Object)this$heartbeatRefreshInterval).equals(other$heartbeatRefreshInterval)) {
            return false;
        }
        Duration this$sessionTimeout = this.getSessionTimeout();
        Duration other$sessionTimeout = other.getSessionTimeout();
        if (this$sessionTimeout == null ? other$sessionTimeout != null : !((Object)this$sessionTimeout).equals(other$sessionTimeout)) {
            return false;
        }
        HikariConfig this$hikariConfig = this.getHikariConfig();
        HikariConfig other$hikariConfig = other.getHikariConfig();
        return !(this$hikariConfig == null ? other$hikariConfig != null : !this$hikariConfig.equals(other$hikariConfig));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof JdbcRegistryProperties;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getServerPort();
        String $jdbcRegistryClientName = this.getJdbcRegistryClientName();
        result = result * 59 + ($jdbcRegistryClientName == null ? 43 : $jdbcRegistryClientName.hashCode());
        Duration $heartbeatRefreshInterval = this.getHeartbeatRefreshInterval();
        result = result * 59 + ($heartbeatRefreshInterval == null ? 43 : ((Object)$heartbeatRefreshInterval).hashCode());
        Duration $sessionTimeout = this.getSessionTimeout();
        result = result * 59 + ($sessionTimeout == null ? 43 : ((Object)$sessionTimeout).hashCode());
        HikariConfig $hikariConfig = this.getHikariConfig();
        result = result * 59 + ($hikariConfig == null ? 43 : $hikariConfig.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "JdbcRegistryProperties(serverPort=" + this.getServerPort() + ", jdbcRegistryClientName=" + this.getJdbcRegistryClientName() + ", heartbeatRefreshInterval=" + this.getHeartbeatRefreshInterval() + ", sessionTimeout=" + this.getSessionTimeout() + ", hikariConfig=" + this.getHikariConfig() + ")";
    }
}

