/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.DataFactoryManager;
import com.azure.resourcemanager.datafactory.fluent.TriggersClient;
import com.azure.resourcemanager.datafactory.fluent.models.TriggerQueryResponseInner;
import com.azure.resourcemanager.datafactory.fluent.models.TriggerResourceInner;
import com.azure.resourcemanager.datafactory.fluent.models.TriggerSubscriptionOperationStatusInner;
import com.azure.resourcemanager.datafactory.implementation.TriggerQueryResponseImpl;
import com.azure.resourcemanager.datafactory.implementation.TriggerResourceImpl;
import com.azure.resourcemanager.datafactory.implementation.TriggerSubscriptionOperationStatusImpl;
import com.azure.resourcemanager.datafactory.implementation.Utils;
import com.azure.resourcemanager.datafactory.models.TriggerFilterParameters;
import com.azure.resourcemanager.datafactory.models.TriggerQueryResponse;
import com.azure.resourcemanager.datafactory.models.TriggerResource;
import com.azure.resourcemanager.datafactory.models.TriggerSubscriptionOperationStatus;
import com.azure.resourcemanager.datafactory.models.Triggers;

public final class TriggersImpl
implements Triggers {
    private static final ClientLogger LOGGER = new ClientLogger(TriggersImpl.class);
    private final TriggersClient innerClient;
    private final DataFactoryManager serviceManager;

    public TriggersImpl(TriggersClient innerClient, DataFactoryManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<TriggerResource> listByFactory(String resourceGroupName, String factoryName) {
        PagedIterable<TriggerResourceInner> inner = this.serviceClient().listByFactory(resourceGroupName, factoryName);
        return Utils.mapPage(inner, inner1 -> new TriggerResourceImpl((TriggerResourceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<TriggerResource> listByFactory(String resourceGroupName, String factoryName, Context context) {
        PagedIterable<TriggerResourceInner> inner = this.serviceClient().listByFactory(resourceGroupName, factoryName, context);
        return Utils.mapPage(inner, inner1 -> new TriggerResourceImpl((TriggerResourceInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<TriggerQueryResponse> queryByFactoryWithResponse(String resourceGroupName, String factoryName, TriggerFilterParameters filterParameters, Context context) {
        Response<TriggerQueryResponseInner> inner = this.serviceClient().queryByFactoryWithResponse(resourceGroupName, factoryName, filterParameters, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new TriggerQueryResponseImpl((TriggerQueryResponseInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public TriggerQueryResponse queryByFactory(String resourceGroupName, String factoryName, TriggerFilterParameters filterParameters) {
        TriggerQueryResponseInner inner = this.serviceClient().queryByFactory(resourceGroupName, factoryName, filterParameters);
        if (inner != null) {
            return new TriggerQueryResponseImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<TriggerResource> getWithResponse(String resourceGroupName, String factoryName, String triggerName, String ifNoneMatch, Context context) {
        Response<TriggerResourceInner> inner = this.serviceClient().getWithResponse(resourceGroupName, factoryName, triggerName, ifNoneMatch, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new TriggerResourceImpl((TriggerResourceInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public TriggerResource get(String resourceGroupName, String factoryName, String triggerName) {
        TriggerResourceInner inner = this.serviceClient().get(resourceGroupName, factoryName, triggerName);
        if (inner != null) {
            return new TriggerResourceImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String factoryName, String triggerName, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, factoryName, triggerName, context);
    }

    @Override
    public void delete(String resourceGroupName, String factoryName, String triggerName) {
        this.serviceClient().delete(resourceGroupName, factoryName, triggerName);
    }

    @Override
    public TriggerSubscriptionOperationStatus subscribeToEvents(String resourceGroupName, String factoryName, String triggerName) {
        TriggerSubscriptionOperationStatusInner inner = this.serviceClient().subscribeToEvents(resourceGroupName, factoryName, triggerName);
        if (inner != null) {
            return new TriggerSubscriptionOperationStatusImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public TriggerSubscriptionOperationStatus subscribeToEvents(String resourceGroupName, String factoryName, String triggerName, Context context) {
        TriggerSubscriptionOperationStatusInner inner = this.serviceClient().subscribeToEvents(resourceGroupName, factoryName, triggerName, context);
        if (inner != null) {
            return new TriggerSubscriptionOperationStatusImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<TriggerSubscriptionOperationStatus> getEventSubscriptionStatusWithResponse(String resourceGroupName, String factoryName, String triggerName, Context context) {
        Response<TriggerSubscriptionOperationStatusInner> inner = this.serviceClient().getEventSubscriptionStatusWithResponse(resourceGroupName, factoryName, triggerName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new TriggerSubscriptionOperationStatusImpl((TriggerSubscriptionOperationStatusInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public TriggerSubscriptionOperationStatus getEventSubscriptionStatus(String resourceGroupName, String factoryName, String triggerName) {
        TriggerSubscriptionOperationStatusInner inner = this.serviceClient().getEventSubscriptionStatus(resourceGroupName, factoryName, triggerName);
        if (inner != null) {
            return new TriggerSubscriptionOperationStatusImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public TriggerSubscriptionOperationStatus unsubscribeFromEvents(String resourceGroupName, String factoryName, String triggerName) {
        TriggerSubscriptionOperationStatusInner inner = this.serviceClient().unsubscribeFromEvents(resourceGroupName, factoryName, triggerName);
        if (inner != null) {
            return new TriggerSubscriptionOperationStatusImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public TriggerSubscriptionOperationStatus unsubscribeFromEvents(String resourceGroupName, String factoryName, String triggerName, Context context) {
        TriggerSubscriptionOperationStatusInner inner = this.serviceClient().unsubscribeFromEvents(resourceGroupName, factoryName, triggerName, context);
        if (inner != null) {
            return new TriggerSubscriptionOperationStatusImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void start(String resourceGroupName, String factoryName, String triggerName) {
        this.serviceClient().start(resourceGroupName, factoryName, triggerName);
    }

    @Override
    public void start(String resourceGroupName, String factoryName, String triggerName, Context context) {
        this.serviceClient().start(resourceGroupName, factoryName, triggerName, context);
    }

    @Override
    public void stop(String resourceGroupName, String factoryName, String triggerName) {
        this.serviceClient().stop(resourceGroupName, factoryName, triggerName);
    }

    @Override
    public void stop(String resourceGroupName, String factoryName, String triggerName, Context context) {
        this.serviceClient().stop(resourceGroupName, factoryName, triggerName, context);
    }

    @Override
    public TriggerResource getById(String id) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String factoryName = Utils.getValueFromIdByName(id, "factories");
        if (factoryName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'factories'.", id)));
        }
        String triggerName = Utils.getValueFromIdByName(id, "triggers");
        if (triggerName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'triggers'.", id)));
        }
        String localIfNoneMatch = null;
        return (TriggerResource)this.getWithResponse(resourceGroupName, factoryName, triggerName, localIfNoneMatch, Context.NONE).getValue();
    }

    @Override
    public Response<TriggerResource> getByIdWithResponse(String id, String ifNoneMatch, Context context) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String factoryName = Utils.getValueFromIdByName(id, "factories");
        if (factoryName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'factories'.", id)));
        }
        String triggerName = Utils.getValueFromIdByName(id, "triggers");
        if (triggerName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'triggers'.", id)));
        }
        return this.getWithResponse(resourceGroupName, factoryName, triggerName, ifNoneMatch, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String factoryName = Utils.getValueFromIdByName(id, "factories");
        if (factoryName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'factories'.", id)));
        }
        String triggerName = Utils.getValueFromIdByName(id, "triggers");
        if (triggerName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'triggers'.", id)));
        }
        this.deleteWithResponse(resourceGroupName, factoryName, triggerName, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String factoryName = Utils.getValueFromIdByName(id, "factories");
        if (factoryName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'factories'.", id)));
        }
        String triggerName = Utils.getValueFromIdByName(id, "triggers");
        if (triggerName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'triggers'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, factoryName, triggerName, context);
    }

    private TriggersClient serviceClient() {
        return this.innerClient;
    }

    private DataFactoryManager manager() {
        return this.serviceManager;
    }

    @Override
    public TriggerResourceImpl define(String name) {
        return new TriggerResourceImpl(name, this.manager());
    }
}

