/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jackson.jq.internal.tree;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.thisptr.jackson.jq.JsonQuery;
import net.thisptr.jackson.jq.Scope;
import net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.jackson.jq.internal.tree.FieldConstruction;

public class ObjectConstruction
extends JsonQuery {
    private final List<FieldConstruction> fields = new ArrayList<FieldConstruction>();

    public void add(FieldConstruction field) {
        this.fields.add(field);
    }

    @Override
    public List<JsonNode> apply(Scope scope, JsonNode in) throws JsonQueryException {
        ArrayList<JsonNode> out = new ArrayList<JsonNode>();
        HashMap<String, JsonNode> tmp = new HashMap<String, JsonNode>();
        ObjectConstruction.applyRecursive(scope, in, out, this.fields, tmp);
        return out;
    }

    private static void applyRecursive(Scope scope, JsonNode in, List<JsonNode> out, List<FieldConstruction> fields, Map<String, JsonNode> tmp) throws JsonQueryException {
        if (fields.size() == 0) {
            ObjectNode obj = scope.getObjectMapper().createObjectNode();
            for (Map.Entry<String, JsonNode> e : tmp.entrySet()) {
                obj.set(e.getKey(), e.getValue());
            }
            out.add((JsonNode)obj);
            return;
        }
        fields.get(0).evaluate(scope, in, (k, v) -> {
            tmp.put(k, v);
            ObjectConstruction.applyRecursive(scope, in, out, fields.subList(1, fields.size()), tmp);
            tmp.remove(k);
        });
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("{");
        String sep = "";
        for (FieldConstruction field : this.fields) {
            builder.append(sep);
            builder.append(field);
            sep = ",";
        }
        builder.append("}");
        return builder.toString();
    }
}

