/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.io.colors.sources;

import com.github.rvesse.airline.io.AnsiControlCodes;
import com.github.rvesse.airline.io.ControlCodeSource;
import com.github.rvesse.airline.io.colors.AnsiColorProvider;

public abstract class AnsiColorSource<T extends AnsiColorProvider>
implements ControlCodeSource<T> {
    private final boolean foreground;

    public AnsiColorSource() {
        this(true);
    }

    protected AnsiColorSource(boolean foreground) {
        this.foreground = foreground;
    }

    @Override
    public String getControlCode(T attributeSource) {
        return this.foreground ? attributeSource.getAnsiForegroundControlCode() : attributeSource.getAnsiBackgroundControlCode();
    }

    @Override
    public String getResetControlCode(T attributeSource) {
        if (attributeSource.usesExtendedColors()) {
            return this.getFullResetControlCode();
        }
        StringBuilder builder = new StringBuilder();
        builder.append("\u001b[");
        builder.append(this.foreground ? 39 : 49);
        builder.append('m');
        return builder.toString();
    }

    @Override
    public String getFullResetControlCode() {
        return AnsiControlCodes.getGraphicsResetCode();
    }
}

