/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.model;

import com.github.rvesse.airline.builder.ParserBuilder;
import com.github.rvesse.airline.help.sections.HelpSection;
import com.github.rvesse.airline.model.CommandGroupMetadata;
import com.github.rvesse.airline.model.CommandMetadata;
import com.github.rvesse.airline.model.OptionMetadata;
import com.github.rvesse.airline.model.ParserMetadata;
import com.github.rvesse.airline.restrictions.GlobalRestriction;
import com.github.rvesse.airline.utils.AirlineUtils;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class GlobalMetadata<T> {
    private final String name;
    private final String description;
    private final List<OptionMetadata> options;
    private final CommandMetadata defaultCommand;
    private final List<CommandMetadata> defaultGroupCommands;
    private final List<CommandGroupMetadata> commandGroups;
    private final ParserMetadata<T> parserConfig;
    private final List<GlobalRestriction> restrictions;
    private final List<HelpSection> baseHelpSections;

    public GlobalMetadata(String name, String description, Iterable<OptionMetadata> options, CommandMetadata defaultCommand, Iterable<CommandMetadata> defaultGroupCommands, Iterable<CommandGroupMetadata> commandGroups, Iterable<GlobalRestriction> restrictions, Iterable<HelpSection> baseHelpSections, ParserMetadata<T> parserConfig) {
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new IllegalArgumentException("Program name cannot be null/empty/whitespace");
        }
        if (parserConfig == null) {
            throw new NullPointerException("parserConfig cannot be null");
        }
        this.name = name;
        this.description = description;
        this.options = AirlineUtils.unmodifiableListCopy(options);
        this.defaultCommand = defaultCommand;
        this.defaultGroupCommands = AirlineUtils.unmodifiableListCopy(defaultGroupCommands);
        this.commandGroups = AirlineUtils.unmodifiableListCopy(commandGroups);
        this.restrictions = AirlineUtils.unmodifiableListCopy(restrictions);
        this.baseHelpSections = AirlineUtils.unmodifiableListCopy(baseHelpSections);
        this.parserConfig = parserConfig != null ? parserConfig : ParserBuilder.defaultConfiguration();
        GlobalMetadata.checkForSuppressedCommands(this.defaultGroupCommands, this.defaultCommand, "");
        for (CommandGroupMetadata group : this.commandGroups) {
            GlobalMetadata.checkForSuppressedCommands(group, "");
        }
    }

    private static void checkForSuppressedCommands(CommandGroupMetadata group, String groupPath) {
        StringBuilder groupName = new StringBuilder();
        if (groupPath.length() > 0) {
            groupName.append(groupPath);
            groupName.append(' ');
        }
        groupName.append(group.getName());
        GlobalMetadata.checkForSuppressedCommands(group.getCommands(), group.getDefaultCommand(), groupName.toString());
        for (CommandGroupMetadata subGroup : group.getSubGroups()) {
            GlobalMetadata.checkForSuppressedCommands(subGroup, groupName.toString());
        }
    }

    private static void checkForSuppressedCommands(List<CommandMetadata> commands, CommandMetadata defaultCommand, String groupName) {
        Class cls;
        HashMap nameToClass = new HashMap();
        for (CommandMetadata cmd : commands) {
            Class cls2 = (Class)nameToClass.get(cmd.getName());
            if (cls2 == null) {
                nameToClass.put(cmd.getName(), cmd.getType());
                continue;
            }
            if (cls2.equals(cmd.getType())) continue;
            GlobalMetadata.suppressedCommand(cls2, cmd, groupName);
        }
        if (defaultCommand != null && (cls = (Class)nameToClass.get(defaultCommand.getName())) != null && !cls.equals(defaultCommand.getType())) {
            GlobalMetadata.suppressedCommand(cls, defaultCommand, groupName);
        }
    }

    private static void suppressedCommand(Class<?> cls, CommandMetadata cmd, String groupName) {
        throw new IllegalArgumentException(String.format("Command classes '%s' and '%s' both declare the command name '%s' and are both in the %s and as such one of these commands would be inaccessible.  Please correct your @Command annotations to use distinct command names.", cls, cmd.getType(), cmd.getName(), groupName != null ? String.format("group '%s'", groupName) : "default group"));
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public List<OptionMetadata> getOptions() {
        return this.options;
    }

    public CommandMetadata getDefaultCommand() {
        return this.defaultCommand;
    }

    public List<CommandMetadata> getDefaultGroupCommands() {
        return this.defaultGroupCommands;
    }

    public List<CommandGroupMetadata> getCommandGroups() {
        return this.commandGroups;
    }

    public List<GlobalRestriction> getRestrictions() {
        return this.restrictions;
    }

    public List<HelpSection> getBaseHelpSections() {
        return this.baseHelpSections;
    }

    public ParserMetadata<T> getParserConfiguration() {
        return this.parserConfig;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("GlobalMetadata");
        sb.append("{name='").append(this.name).append('\'');
        sb.append(", description='").append(this.description).append('\'');
        sb.append(", options=").append(this.options);
        sb.append(", defaultCommand=").append(this.defaultCommand);
        sb.append(", defaultGroupCommands=").append(this.defaultGroupCommands);
        sb.append(", commandGroups=").append(this.commandGroups);
        sb.append(", parserConfig=").append('\n').append(this.parserConfig);
        sb.append('\n').append('}');
        return sb.toString();
    }
}

