/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.dart.controller.messages;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.apache.druid.msq.counters.CounterSnapshotsTree;
import org.apache.druid.msq.dart.controller.messages.ControllerMessage;
import org.apache.druid.msq.exec.Controller;

public class PostCounters
implements ControllerMessage {
    private final String queryId;
    private final String workerId;
    private final CounterSnapshotsTree counters;

    @JsonCreator
    public PostCounters(@JsonProperty(value="queryId") String queryId, @JsonProperty(value="workerId") String workerId, @JsonProperty(value="counters") CounterSnapshotsTree counters) {
        this.queryId = (String)Preconditions.checkNotNull((Object)queryId, (Object)"queryId");
        this.workerId = (String)Preconditions.checkNotNull((Object)workerId, (Object)"workerId");
        this.counters = (CounterSnapshotsTree)Preconditions.checkNotNull((Object)counters, (Object)"counters");
    }

    @Override
    @JsonProperty
    public String getQueryId() {
        return this.queryId;
    }

    @JsonProperty
    public String getWorkerId() {
        return this.workerId;
    }

    @JsonProperty(value="counters")
    public CounterSnapshotsTree getCounters() {
        return this.counters;
    }

    @Override
    public void handle(Controller controller) {
        controller.updateCounters(this.workerId, this.counters);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PostCounters that = (PostCounters)o;
        return Objects.equals(this.queryId, that.queryId) && Objects.equals(this.workerId, that.workerId) && Objects.equals(this.counters, that.counters);
    }

    public int hashCode() {
        return Objects.hash(this.queryId, this.workerId, this.counters);
    }

    public String toString() {
        return "PostCounters{queryId='" + this.queryId + "', workerId='" + this.workerId + "', counters=" + String.valueOf(this.counters) + "}";
    }
}

