/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.dart.controller.sql;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import org.apache.druid.guice.annotations.EscalatedGlobal;
import org.apache.druid.guice.annotations.Json;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.msq.dart.controller.sql.DartSqlClient;
import org.apache.druid.msq.dart.controller.sql.DartSqlClientFactory;
import org.apache.druid.msq.dart.controller.sql.DartSqlClientImpl;
import org.apache.druid.rpc.FixedServiceLocator;
import org.apache.druid.rpc.ServiceClient;
import org.apache.druid.rpc.ServiceClientFactory;
import org.apache.druid.rpc.ServiceLocation;
import org.apache.druid.rpc.ServiceLocator;
import org.apache.druid.rpc.ServiceRetryPolicy;
import org.apache.druid.rpc.StandardRetryPolicy;
import org.apache.druid.server.DruidNode;

public class DartSqlClientFactoryImpl
implements DartSqlClientFactory {
    private final ServiceClientFactory clientFactory;
    private final ObjectMapper jsonMapper;

    @Inject
    public DartSqlClientFactoryImpl(@EscalatedGlobal ServiceClientFactory clientFactory, @Json ObjectMapper jsonMapper) {
        this.clientFactory = clientFactory;
        this.jsonMapper = jsonMapper;
    }

    @Override
    public DartSqlClient makeClient(DruidNode node) {
        ServiceClient client = this.clientFactory.makeClient(StringUtils.format((String)"%s[dart-sql]", (Object[])new Object[]{node.getHostAndPortToUse()}), (ServiceLocator)new FixedServiceLocator(ServiceLocation.fromDruidNode((DruidNode)node).withBasePath(StringUtils.maybeRemoveTrailingSlash((String)"/druid/v2/sql/"))), (ServiceRetryPolicy)StandardRetryPolicy.noRetries());
        return new DartSqlClientImpl(client, this.jsonMapper);
    }
}

