/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.indexing;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.druid.indexer.report.TaskContextReport;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.jackson.JacksonUtils;
import org.apache.druid.msq.exec.QueryListener;
import org.apache.druid.msq.indexing.report.MSQResultsReport;
import org.apache.druid.msq.indexing.report.MSQStatusReport;
import org.apache.druid.msq.indexing.report.MSQTaskReportPayload;

public class TaskReportQueryListener
implements QueryListener {
    private static final String FIELD_TYPE = "type";
    private static final String FIELD_TASK_ID = "taskId";
    private static final String FIELD_PAYLOAD = "payload";
    private static final String FIELD_STATUS = "status";
    private static final String FIELD_STAGES = "stages";
    private static final String FIELD_COUNTERS = "counters";
    private static final String FIELD_RESULTS = "results";
    private static final String FIELD_RESULTS_SIGNATURE = "signature";
    private static final String FIELD_RESULTS_SQL_TYPE_NAMES = "sqlTypeNames";
    private static final String FIELD_RESULTS_RESULTS = "results";
    private static final String FIELD_RESULTS_TRUNCATED = "resultsTruncated";
    private final long rowsInTaskReport;
    private final OutputStreamSupplier reportSink;
    private final ObjectMapper jsonMapper;
    private final SerializerProvider serializers;
    private final String taskId;
    private final Map<String, Object> taskContext;
    private JsonGenerator jg;
    private long numResults;
    private MSQStatusReport statusReport;
    private boolean resultsCurrentlyOpen;

    public TaskReportQueryListener(OutputStreamSupplier reportSink, ObjectMapper jsonMapper, String taskId, Map<String, Object> taskContext, long rowsInTaskReport) {
        this.reportSink = reportSink;
        this.jsonMapper = jsonMapper;
        this.serializers = jsonMapper.getSerializerProviderInstance();
        this.taskId = taskId;
        this.taskContext = taskContext;
        this.rowsInTaskReport = rowsInTaskReport;
    }

    @Override
    public boolean readResults() {
        return this.rowsInTaskReport == -1L || this.rowsInTaskReport > 0L;
    }

    @Override
    public void onResultsStart(List<MSQResultsReport.ColumnAndType> signature, @Nullable List<SqlTypeName> sqlTypeNames) {
        try {
            this.openGenerator();
            this.resultsCurrentlyOpen = true;
            this.jg.writeObjectFieldStart("results");
            this.writeObjectField(FIELD_RESULTS_SIGNATURE, signature);
            if (sqlTypeNames != null) {
                this.writeObjectField(FIELD_RESULTS_SQL_TYPE_NAMES, sqlTypeNames);
            }
            this.jg.writeArrayFieldStart("results");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean onResultRow(Object[] row) {
        try {
            JacksonUtils.writeObjectUsingSerializerProvider((JsonGenerator)this.jg, (SerializerProvider)this.serializers, (Object)row);
            ++this.numResults;
            return this.rowsInTaskReport == -1L || this.numResults < this.rowsInTaskReport;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void onResultsComplete() {
        try {
            this.resultsCurrentlyOpen = false;
            this.jg.writeEndArray();
            this.jg.writeBooleanField(FIELD_RESULTS_TRUNCATED, false);
            this.jg.writeEndObject();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void onQueryComplete(MSQTaskReportPayload report) {
        try {
            if (this.resultsCurrentlyOpen) {
                this.jg.writeEndArray();
                this.jg.writeBooleanField(FIELD_RESULTS_TRUNCATED, true);
                this.jg.writeEndObject();
            } else {
                this.openGenerator();
            }
            this.statusReport = report.getStatus();
            this.writeObjectField(FIELD_STATUS, report.getStatus());
            if (report.getStages() != null) {
                this.writeObjectField(FIELD_STAGES, report.getStages());
            }
            if (report.getCounters() != null) {
                this.writeObjectField(FIELD_COUNTERS, report.getCounters());
            }
            this.jg.writeEndObject();
            this.jg.writeEndObject();
            this.jg.writeObjectField("taskContext", (Object)new TaskContextReport(this.taskId, this.taskContext));
            this.jg.writeEndObject();
            this.jg.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public MSQStatusReport getStatusReport() {
        if (this.statusReport == null) {
            throw new ISE("Status report not available", new Object[0]);
        }
        return this.statusReport;
    }

    private void openGenerator() throws IOException {
        if (this.jg == null) {
            this.jg = this.jsonMapper.createGenerator(this.reportSink.get());
            this.jg.writeStartObject();
            this.jg.writeObjectFieldStart("multiStageQuery");
            this.jg.writeStringField(FIELD_TYPE, "multiStageQuery");
            this.jg.writeStringField(FIELD_TASK_ID, this.taskId);
            this.jg.writeObjectFieldStart(FIELD_PAYLOAD);
        }
    }

    private void writeObjectField(String fieldName, Object value) throws IOException {
        this.jg.writeFieldName(fieldName);
        JacksonUtils.writeObjectUsingSerializerProvider((JsonGenerator)this.jg, (SerializerProvider)this.serializers, (Object)value);
    }

    public static interface OutputStreamSupplier {
        public OutputStream get() throws IOException;
    }
}

