/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.indexing.destination;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Iterables;
import it.unimi.dsi.fastutil.ints.Int2ObjectAVLTreeMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.IntBidirectionalIterator;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.druid.frame.key.ClusterBy;
import org.apache.druid.msq.indexing.MSQSpec;
import org.apache.druid.msq.indexing.MSQTuningConfig;
import org.apache.druid.msq.indexing.destination.SegmentGenerationUtils;
import org.apache.druid.msq.indexing.destination.TerminalStageSpec;
import org.apache.druid.msq.indexing.processor.SegmentGeneratorStageProcessor;
import org.apache.druid.msq.input.stage.ReadablePartition;
import org.apache.druid.msq.input.stage.StageInputSlice;
import org.apache.druid.msq.input.stage.StageInputSpec;
import org.apache.druid.msq.kernel.QueryDefinition;
import org.apache.druid.msq.kernel.StageDefinition;
import org.apache.druid.msq.kernel.StageDefinitionBuilder;
import org.apache.druid.msq.kernel.controller.WorkerInputs;
import org.apache.druid.query.Query;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.indexing.DataSchema;
import org.apache.druid.segment.realtime.appenderator.SegmentIdWithShardSpec;
import org.apache.druid.sql.calcite.planner.ColumnMappings;

public class SegmentGenerationStageSpec
implements TerminalStageSpec {
    public static final String TYPE = "segmentGeneration";
    private static final SegmentGenerationStageSpec INSTANCE = new SegmentGenerationStageSpec();

    private SegmentGenerationStageSpec() {
    }

    @JsonCreator
    public static SegmentGenerationStageSpec instance() {
        return INSTANCE;
    }

    @Override
    public StageDefinitionBuilder constructFinalStage(QueryDefinition queryDef, MSQSpec querySpec, ObjectMapper jsonMapper, Query<?> query) {
        MSQTuningConfig tuningConfig = querySpec.getTuningConfig();
        ColumnMappings columnMappings = querySpec.getColumnMappings();
        RowSignature querySignature = queryDef.getFinalStageDefinition().getSignature();
        ClusterBy queryClusterBy = queryDef.getFinalStageDefinition().getClusterBy();
        DataSchema dataSchema = SegmentGenerationUtils.makeDataSchemaForIngestion(querySpec, querySignature, queryClusterBy, columnMappings, jsonMapper, query);
        return StageDefinition.builder(queryDef.getNextStageNumber()).inputs(new StageInputSpec(queryDef.getFinalStageDefinition().getStageNumber())).maxWorkerCount(tuningConfig.getMaxNumWorkers()).processor(new SegmentGeneratorStageProcessor(dataSchema, columnMappings, tuningConfig));
    }

    public Int2ObjectMap<List<SegmentIdWithShardSpec>> getWorkerInfo(WorkerInputs workerInputs, @Nullable List<SegmentIdWithShardSpec> segmentsToGenerate) {
        Int2ObjectAVLTreeMap retVal = new Int2ObjectAVLTreeMap();
        if (segmentsToGenerate == null || segmentsToGenerate.isEmpty()) {
            return retVal;
        }
        IntBidirectionalIterator intBidirectionalIterator = workerInputs.workers().iterator();
        while (intBidirectionalIterator.hasNext()) {
            int workerNumber = (Integer)intBidirectionalIterator.next();
            StageInputSlice stageInputSlice = (StageInputSlice)Iterables.getOnlyElement(workerInputs.inputsForWorker(workerNumber));
            ArrayList<SegmentIdWithShardSpec> workerSegments = new ArrayList<SegmentIdWithShardSpec>();
            retVal.put(workerNumber, workerSegments);
            for (ReadablePartition partition : stageInputSlice.getPartitions()) {
                workerSegments.add(segmentsToGenerate.get(partition.getPartitionNumber()));
            }
        }
        return retVal;
    }
}

