/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.indexing.error;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Objects;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.msq.indexing.error.BaseMSQFault;

@JsonTypeName(value="NotEnoughMemory")
public class NotEnoughMemoryFault
extends BaseMSQFault {
    static final String CODE = "NotEnoughMemory";
    private final long suggestedServerMemory;
    private final long serverMemory;
    private final long usableMemory;
    private final int serverWorkers;
    private final int serverThreads;
    private final int inputWorkers;
    private final int maxConcurrentStages;

    @JsonCreator
    public NotEnoughMemoryFault(@JsonProperty(value="suggestedServerMemory") long suggestedServerMemory, @JsonProperty(value="serverMemory") long serverMemory, @JsonProperty(value="usableMemory") long usableMemory, @JsonProperty(value="serverWorkers") int serverWorkers, @JsonProperty(value="serverThreads") int serverThreads, @JsonProperty(value="inputWorkers") int inputWorkers, @JsonProperty(value="maxConcurrentStages") int maxConcurrentStages) {
        super(CODE, "Not enough memory. " + (suggestedServerMemory > 0L ? StringUtils.format((String)"Minimum bytes[%,d] is needed for the current configuration. ", (Object[])new Object[]{suggestedServerMemory}) : "") + "(total bytes[%,d]; usable bytes[%,d]; input workers[%,d]; concurrent stages[%,d]; server worker capacity[%,d]; server processing threads[%,d]). Increase JVM memory with the -Xmx option" + (inputWorkers > 1 ? ", or reduce maxNumTasks for this query" : "") + (maxConcurrentStages > 1 ? ", or reduce maxConcurrentStages for this query" : "") + (serverWorkers > 1 ? ", or reduce worker capacity on this server" : "") + (serverThreads > 1 ? ", or reduce processing threads on this server" : ""), serverMemory, usableMemory, inputWorkers, maxConcurrentStages, serverWorkers, serverThreads);
        this.suggestedServerMemory = suggestedServerMemory;
        this.serverMemory = serverMemory;
        this.usableMemory = usableMemory;
        this.serverWorkers = serverWorkers;
        this.serverThreads = serverThreads;
        this.inputWorkers = inputWorkers;
        this.maxConcurrentStages = maxConcurrentStages;
    }

    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public long getSuggestedServerMemory() {
        return this.suggestedServerMemory;
    }

    @JsonProperty
    public long getServerMemory() {
        return this.serverMemory;
    }

    @JsonProperty
    public long getUsableMemory() {
        return this.usableMemory;
    }

    @JsonProperty
    public int getServerWorkers() {
        return this.serverWorkers;
    }

    @JsonProperty
    public int getServerThreads() {
        return this.serverThreads;
    }

    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public int getInputWorkers() {
        return this.inputWorkers;
    }

    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public int getMaxConcurrentStages() {
        return this.maxConcurrentStages;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NotEnoughMemoryFault that = (NotEnoughMemoryFault)o;
        return this.suggestedServerMemory == that.suggestedServerMemory && this.serverMemory == that.serverMemory && this.usableMemory == that.usableMemory && this.serverWorkers == that.serverWorkers && this.serverThreads == that.serverThreads && this.inputWorkers == that.inputWorkers && this.maxConcurrentStages == that.maxConcurrentStages;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.suggestedServerMemory, this.serverMemory, this.usableMemory, this.serverWorkers, this.serverThreads, this.inputWorkers, this.maxConcurrentStages);
    }

    @Override
    public String toString() {
        return "NotEnoughMemoryFault{suggestedServerMemory=" + this.suggestedServerMemory + ", serverMemory=" + this.serverMemory + ", usableMemory=" + this.usableMemory + ", serverWorkers=" + this.serverWorkers + ", serverThreads=" + this.serverThreads + ", inputWorkers=" + this.inputWorkers + ", maxConcurrentStages=" + this.maxConcurrentStages + "}";
    }
}

